#ifndef LFC_BLAS_H
#define LFC_BLAS_H 1

#define LFC_xerbla(info,rout,fmt,ival) do{fprintf(stderr,"Parameter %d to routine %s was incorrect.\n",info,rout);fprintf(stderr,fmt,ival);fflush(stderr);exit(1);}while(0)

LFC_BEGIN_C_DECLS

typedef int integer;
typedef int logical;
typedef int ftnlen;
typedef float real;
typedef double doublereal;
typedef struct {real r, i;} complex;
typedef struct {doublereal r, i;} doublecomplex;

extern float  LFC_snrm2( int N, /*const*/ float *X, int incX);
extern double LFC_dnrm2( int N, /*const*/ double *X, int incX);
extern float  LFC_scnrm2( int N, /*const*/ void *X, int incX);
extern double LFC_dznrm2( int N, /*const*/ void *X, int incX);
extern float  LFC_sasum( int N, /*const*/ float *X, int incX);
extern double LFC_dasum( int N, /*const*/ double *X, int incX);
extern float  LFC_scasum( int N, /*const*/ void *X, int incX);
extern double LFC_dzasum( int N, /*const*/ void *X, int incX);

extern logical LFC_F77_sbigp(integer *ip, integer *dim1, integer *dim2);
extern logical LFC_F77_dbigp(integer *ip, integer *dim1, integer *dim2);
extern logical LFC_F77_cbigp(integer *ip, integer *dim1, integer *dim2);
extern logical LFC_F77_zbigp(integer *ip, integer *dim1, integer *dim2);

extern float  LFC_F77_sasum(int *n, float *dx, int *incx);
extern double LFC_F77_dasum(int *n, double *dx, int *incx);
extern float  LFC_F77_scasum(int *n, complex *zx, int *incx);
extern double LFC_F77_dzasum(int *n, doublecomplex *zx, int *incx);
extern float  LFC_F77_snrm2(int *n, /*const*/ float *dx, int *incx);
extern double LFC_F77_dnrm2(int *n, /*const*/ double *dx, int *incx);
extern float  LFC_F77_scnrm2(int *n, /*const*/ complex *zx, int *incx);
extern double LFC_F77_dznrm2(int *n, /*const*/ doublecomplex *zx, int *incx);

extern int LFC_F77_isamax(int *n, float *dx, int *incx);
extern int LFC_F77_idamax(int *n, double *dx, int *incx);
extern int LFC_F77_icamax(int *n, complex *dx, int *incx);
extern int LFC_F77_izamax(int *n, doublecomplex *dx, int *incx);

extern int
LFC_F77_daxpy(int *n, double *da, double *dx, int *incx, double *dy, int *incy);
extern int LFC_F77_dcopy(int *n, double *dx, int *incx, double *dy, int *incy);
extern double
LFC_F77_ddot(int *n, double *x, int *incX, double *y, int *incY);
extern int
LFC_F77_dger(int *m, int *n, double *alpha, double *x, int *incx, double *y, int *incy,
        double *a, int *lda);
extern int LFC_F77_dscal(int *n, double *da, double *dx, int *incx);
extern int
LFC_F77_dsyr(char *uplo, int *n, double *alpha, double *x, int *incx, double *a,
  int *lda);
extern int LFC_F77_dswap(int *n, double *dx, int *incx, double *dy, int *incy);

extern int
LFC_F77_dgemv(char *trans, int *m, int *n, double * alpha, double *a,
  int *lda, double *x, int *incx, double *beta, double *y, int *incy);
extern int
LFC_F77_dtrmv(char *uplo, char *trans, char *diag, int *n, double *a, int *lda,
  double *x, int *incx);
extern int
LFC_F77_dtrsv(char *uplo, char *trans, char *diag, int *n, double *a, int *lda,
  double *x, int *incx);

extern int
LFC_F77_dgemm(char *transa, char *transb, int *m, int * n, int *k,
  double *alpha, double *a, int *lda, double *b, int *ldb, double *beta,
  double *c__, int *ldc);
extern int
LFC_F77_dsymm(char *side, char *uplo, int *m, int *n, double *alpha,
  double *a, int *lda, double *b, int *ldb, double *beta, double *c__, int *ldc);
extern int
LFC_F77_dsyrk(char *uplo, char *trans, int *n, int *k, double *alpha,
  double *a, int *lda, double *beta, double *c__, int *ldc);
extern int
LFC_F77_dtrmm(char *side, char *uplo, char *transa, char *diag, int *m, int *n,
  double *alpha, double *a, int *lda, double *c__, int *ldc);
extern int
LFC_F77_dtrsm(char *side, char *uplo, char *transa, char *diag, int *m, int *n,
  double *alpha, double *a, int * lda, double *c__, int *ldc);

extern int
LFC_F77_dgbmv(char *trans, integer *m, integer *n, integer *kl,
  integer *ku, doublereal *alpha, doublereal *a, integer *lda,
  doublereal *x, integer *incx, doublereal *beta, doublereal *y,
  integer *incy);
extern int
LFC_F77_drot(integer *n, doublereal *dx, integer *incx,
  doublereal *dy, integer *incy, doublereal *c__, doublereal *s);
extern int
LFC_F77_dsbmv(char *uplo, integer *n, integer *k, doublereal *
  alpha, doublereal *a, integer *lda, doublereal *x, integer *incx,
  doublereal *beta, doublereal *y, integer *incy);
extern int
LFC_F77_dsymv(char *uplo, integer *n, doublereal *alpha,
  doublereal *a, integer *lda, doublereal *x, integer *incx, doublereal
  *beta, doublereal *y, integer *incy);
extern int
LFC_F77_dsyr2(char *uplo, integer *n, doublereal *alpha,
  doublereal *x, integer *incx, doublereal *y, integer *incy,
  doublereal *a, integer *lda);
extern int
LFC_F77_dsyr2k(char *uplo, char *trans, integer *n, integer *k,
  doublereal *alpha, doublereal *a, integer *lda, doublereal *b,
  integer *ldb, doublereal *beta, doublereal *c__, integer *ldc);
extern int
LFC_F77_dtbsv(char *uplo, char *trans, char *diag, integer *n,
  integer *k, doublereal *a, integer *lda, doublereal *x, integer *incx);

extern int
LFC_F77_saxpy(int *n, float *da, float *dx, int *incx, float *dy, int *incy);
extern int LFC_F77_scopy(int *n, float *dx, int *incx, float *dy, int *incy);
extern float
LFC_F77_sdot(int *n, float *x, int *incX, float *y, int *incY);
extern int
LFC_F77_sger(int *m, int *n, float *alpha, float *x, int *incx, float *y, int *incy,
        float *a, int *lda);
extern int LFC_F77_sscal(int *n, float *da, float *dx, int *incx);
extern int
LFC_F77_ssyr(char *uplo, int *n, float *alpha, float *x, int *incx, float *a,
  int *lda);
extern int LFC_F77_sswap(int *n, float *dx, int *incx, float *dy, int *incy);

extern int
LFC_F77_sgemv(char *trans, int *m, int *n, float * alpha, float *a,
  int *lda, float *x, int *incx, float *beta, float *y, int *incy);
extern int
LFC_F77_strmv(char *uplo, char *trans, char *diag, int *n, float *a, int *lda,
  float *x, int *incx);
extern int
LFC_F77_strsv(char *uplo, char *trans, char *diag, int *n, float *a, int *lda,
  float *x, int *incx);

extern int
LFC_F77_sgemm(char *transa, char *transb, int *m, int * n, int *k,
  float *alpha, float *a, int *lda, float *b, int *ldb, float *beta,
  float *c__, int *ldc);
extern int
LFC_F77_ssymm(char *side, char *uplo, int *m, int *n, float *alpha,
  float *a, int *lda, float *b, int *ldb, float *beta, float *c__, int *ldc);
extern int
LFC_F77_ssyrk(char *uplo, char *trans, int *n, int *k, float *alpha,
  float *a, int *lda, float *beta, float *c__, int *ldc);
extern int
LFC_F77_strmm(char *side, char *uplo, char *transa, char *diag, int *m, int *n,
  float *alpha, float *a, int *lda, float *c__, int *ldc);
extern int
LFC_F77_strsm(char *side, char *uplo, char *transa, char *diag, int *m, int *n,
  float *alpha, float *a, int * lda, float *c__, int *ldc);

extern int
LFC_F77_sgbmv(char *trans, integer *m, integer *n, integer *kl,
  integer *ku, real *alpha, real *a, integer *lda,
  real *x, integer *incx, real *beta, real *y,
  integer *incy);
extern int
LFC_F77_srot(integer *n, real *dx, integer *incx,
  real *dy, integer *incy, real *c__, real *s);
extern int
LFC_F77_ssbmv(char *uplo, integer *n, integer *k, real *
  alpha, real *a, integer *lda, real *x, integer *incx,
  real *beta, real *y, integer *incy);
extern int
LFC_F77_ssymv(char *uplo, integer *n, real *alpha,
  real *a, integer *lda, real *x, integer *incx, real
  *beta, real *y, integer *incy);
extern int
LFC_F77_ssyr2(char *uplo, integer *n, real *alpha,
  real *x, integer *incx, real *y, integer *incy,
  real *a, integer *lda);
extern int
LFC_F77_ssyr2k(char *uplo, char *trans, integer *n, integer *k,
  real *alpha, real *a, integer *lda, real *b,
  integer *ldb, real *beta, real *c__, integer *ldc);
extern int
LFC_F77_stbsv(char *uplo, char *trans, char *diag, integer *n,
  integer *k, real *a, integer *lda, real *x, integer *incx);

extern int LFC_F77_caxpy(integer *n, complex *ca, complex *cx, integer *
	incx, complex *cy, integer *incy);
extern int LFC_F77_ccopy(integer *n, complex *cx, integer *incx, complex *
	cy, integer *incy);
extern int LFC_F77_cgbmv(char *trans, integer *m, integer *n, integer *kl, 
	integer *ku, complex *alpha, complex *a, integer *lda, complex *x, 
	integer *incx, complex *beta, complex *y, integer *incy);
extern int LFC_F77_cgemm(char *transa, char *transb, integer *m, integer *
	n, integer *k, complex *alpha, complex *a, integer *lda, complex *b, 
	integer *ldb, complex *beta, complex *c__, integer *ldc);
extern int LFC_F77_cgemv(char *trans, integer *m, integer *n, complex *
	alpha, complex *a, integer *lda, complex *x, integer *incx, complex *
	beta, complex *y, integer *incy);
extern int LFC_F77_chbmv(char *uplo, integer *n, integer *k, complex *
	alpha, complex *a, integer *lda, complex *x, integer *incx, complex *
	beta, complex *y, integer *incy);
extern int LFC_F77_chemm(char *side, char *uplo, integer *m, integer *n, 
	complex *alpha, complex *a, integer *lda, complex *b, integer *ldb, 
	complex *beta, complex *c__, integer *ldc);
extern int LFC_F77_chemv(char *uplo, integer *n, complex *alpha, complex *
	a, integer *lda, complex *x, integer *incx, complex *beta, complex *y,
	 integer *incy);
extern int LFC_F77_cher2(char *uplo, integer *n, complex *alpha, complex *
	x, integer *incx, complex *y, integer *incy, complex *a, integer *lda);
extern int LFC_F77_cher2k(char *uplo, char *trans, integer *n, integer *k, 
	complex *alpha, complex *a, integer *lda, complex *b, integer *ldb, 
	real *beta, complex *c__, integer *ldc);
extern int LFC_F77_cher(char *uplo, integer *n, real *alpha, complex *x, 
	integer *incx, complex *a, integer *lda);
extern int LFC_F77_cherk(char *uplo, char *trans, integer *n, integer *k, 
	real *alpha, complex *a, integer *lda, real *beta, complex *c__, 
	integer *ldc);
extern int LFC_F77_cscal(integer *n, complex *ca, complex *cx, integer * incx);
extern int LFC_F77_csscal(integer *n, real *sa, complex *cx, integer *incx);
extern int LFC_F77_cswap(integer *n, complex *cx, integer *incx, complex *
	cy, integer *incy);
extern int LFC_F77_csymm(char *side, char *uplo, integer *m, integer *n, 
	complex *alpha, complex *a, integer *lda, complex *b, integer *ldb, 
	complex *beta, complex *c__, integer *ldc);
extern int LFC_F77_csyr2k(char *uplo, char *trans, integer *n, integer *k, 
	complex *alpha, complex *a, integer *lda, complex *b, integer *ldb, 
	complex *beta, complex *c__, integer *ldc);
extern int LFC_F77_csyrk(char *uplo, char *trans, integer *n, integer *k, 
	complex *alpha, complex *a, integer *lda, complex *beta, complex *c__,
	 integer *ldc);
extern int LFC_F77_ctbsv(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, complex *a, integer *lda, complex *x, integer *incx);
extern int LFC_F77_ctrmm(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, complex *alpha, complex *a, integer *lda, 
	complex *c__, integer *ldc);
extern int LFC_F77_ctrmv(char *uplo, char *trans, char *diag, integer *n, 
	complex *a, integer *lda, complex *x, integer *incx);
extern int LFC_F77_ctrsm(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, complex *alpha, complex *a, integer *lda, 
	complex *c__, integer *ldc);
extern int LFC_F77_ctrsv(char *uplo, char *trans, char *diag, integer *n, 
	complex *a, integer *lda, complex *x, integer *incx);

extern int
LFC_F77_cgerc(int *m, int *n, complex *alpha, complex *x, int *incx, complex *y,
  int *incy, complex *a, int *lda);
extern int
LFC_F77_cgeru(int *m, int *n, complex *alpha, complex *x, int *incx, complex *y,
  int *incy, complex *a, int *lda);

extern int LFC_F77_zaxpy(integer *n, doublecomplex *ca, doublecomplex *cx, integer *
	incx, doublecomplex *cy, integer *incy);
extern int LFC_F77_zcopy(integer *n, doublecomplex *cx, integer *incx, doublecomplex *
	cy, integer *incy);
extern int LFC_F77_zgbmv(char *trans, integer *m, integer *n, integer *kl, 
	integer *ku, doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *x, 
	integer *incx, doublecomplex *beta, doublecomplex *y, integer *incy);
extern int LFC_F77_zgemm(char *transa, char *transb, integer *m, integer *
	n, integer *k, doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *b, 
	integer *ldb, doublecomplex *beta, doublecomplex *c__, integer *ldc);
extern int LFC_F77_zgemv(char *trans, integer *m, integer *n, doublecomplex *
	alpha, doublecomplex *a, integer *lda, doublecomplex *x, integer *incx, doublecomplex *
	beta, doublecomplex *y, integer *incy);
extern int LFC_F77_zhbmv(char *uplo, integer *n, integer *k, doublecomplex *
	alpha, doublecomplex *a, integer *lda, doublecomplex *x, integer *incx, doublecomplex *
	beta, doublecomplex *y, integer *incy);
extern int LFC_F77_zhemm(char *side, char *uplo, integer *m, integer *n, 
	doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *b, integer *ldb, 
	doublecomplex *beta, doublecomplex *c__, integer *ldc);
extern int LFC_F77_zhemv(char *uplo, integer *n, doublecomplex *alpha, doublecomplex *
	a, integer *lda, doublecomplex *x, integer *incx, doublecomplex *beta, doublecomplex *y,
	 integer *incy);
extern int LFC_F77_zher2(char *uplo, integer *n, doublecomplex *alpha, doublecomplex *
	x, integer *incx, doublecomplex *y, integer *incy, doublecomplex *a, integer *lda);
extern int LFC_F77_zher2k(char *uplo, char *trans, integer *n, integer *k, 
	doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *b, integer *ldb, 
	doublereal *beta, doublecomplex *c__, integer *ldc);
extern int LFC_F77_zher(char *uplo, integer *n, doublereal *alpha, doublecomplex *x, 
	integer *incx, doublecomplex *a, integer *lda);
extern int LFC_F77_zherk(char *uplo, char *trans, integer *n, integer *k, 
	doublereal *alpha, doublecomplex *a, integer *lda, doublereal *beta, doublecomplex *c__, 
	integer *ldc);
extern int LFC_F77_zscal(integer *n, doublecomplex *ca, doublecomplex *cx, integer * incx);
extern int LFC_F77_zdscal(integer *n, doublereal *sa, doublecomplex *cx, integer *incx);
extern int LFC_F77_zswap(integer *n, doublecomplex *cx, integer *incx, doublecomplex *
	cy, integer *incy);
extern int LFC_F77_zsymm(char *side, char *uplo, integer *m, integer *n, 
	doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *b, integer *ldb, 
	doublecomplex *beta, doublecomplex *c__, integer *ldc);
extern int LFC_F77_zsyr2k(char *uplo, char *trans, integer *n, integer *k, 
	doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *b, integer *ldb, 
	doublecomplex *beta, doublecomplex *c__, integer *ldc);
extern int LFC_F77_zsyrk(char *uplo, char *trans, integer *n, integer *k, 
	doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *beta, doublecomplex *c__,
	 integer *ldc);
extern int LFC_F77_ztbsv(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, doublecomplex *a, integer *lda, doublecomplex *x, integer *incx);
extern int LFC_F77_ztrmm(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublecomplex *alpha, doublecomplex *a, integer *lda, 
	doublecomplex *c__, integer *ldc);
extern int LFC_F77_ztrmv(char *uplo, char *trans, char *diag, integer *n, 
	doublecomplex *a, integer *lda, doublecomplex *x, integer *incx);
extern int LFC_F77_ztrsm(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublecomplex *alpha, doublecomplex *a, integer *lda, 
	doublecomplex *c__, integer *ldc);
extern int LFC_F77_ztrsv(char *uplo, char *trans, char *diag, integer *n, 
	doublecomplex *a, integer *lda, doublecomplex *x, integer *incx);

extern int
LFC_F77_zgerc(int *m, int *n, doublecomplex *alpha, doublecomplex *x, int *incx, doublecomplex *y,
  int *incy, doublecomplex *a, int *lda);
extern int
LFC_F77_zgeru(int *m, int *n, doublecomplex *alpha, doublecomplex *x, int *incx, doublecomplex *y,
  int *incy, doublecomplex *a, int *lda);

LFC_END_C_DECLS

#endif /* !LFC_BLAS_H */
