/* -*- C -*- */
/* argvutil.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

static char argvSentinel[13] = "argvSentinel";

int
LFC_argvNew(char ***uargv, int initialLength) {
  char **argv; int i;

  if (initialLength < 1) return LFC_FAILURE;

  argv = LFC_MALLOC( char *, initialLength + 2 );
  if (uargv) *uargv = argv;

  if (! argv) return LFC_FAILURE;

  /* at any given point there is sentinel at the end and NULL preceding it (for
     execvp() */
  for (i = 0; i <= initialLength; i++) argv[i] = NULL;
  argv[initialLength + 1] = argvSentinel;

  return LFC_SUCCESS;
}	/* LFC_argvNew */

int
LFC_argvAppend(char ***uargv, const char *fmt, void *data) {
  char **argv, **argv1; int i, j, k;

  if (uargv) argv = *uargv;
  else return LFC_FAILURE;

  /* search for an empty slot */
  for (i = 0; argv[i] && argv[i] != argvSentinel; i++) ;

  /* i is the number of elements currently stored */

#if 0
  if (argv[i] == argvSentinel) return -1; /* no more space -- this is unlikely */
  if (argv[i+1] == argvSentinel) return -1; /* no more space -- this is the
					       true full list with one NULL */
#endif

  /* if no more space */
  if (argv[i] == argvSentinel || argv[i+1] == argvSentinel) {
    /* try to allocate more */

    if (argv[i+1] == argvSentinel) i++; 

    for (j = 2 * (i - 1); j >= i; j--) {
      argv1 = LFC_REALLOC( char *, argv, j + 2 );
      if (argv1) break;
    }
    argv = argv1;

    if (! argv) return -1;
    *uargv = argv;

    for (k = i; k <= j; k++) argv[k] = NULL;
    argv[j + 1] = argvSentinel;
    if (i > 0 && ! argv[i-1]) i--;
  }

  argv[i] = LFC_StrSubst1( fmt, data );
  if (! argv[i]) return LFC_FAILURE;

  return LFC_SUCCESS;
}	/* LFC_argvAppend */

int
LFC_argvPop(char **argv) {
  int i;

  if (! argv) return LFC_FAILURE;

  for (i = 0; argv[i] && argv[i] != argvSentinel; i++) ;

  if (argv[i] == argvSentinel) return LFC_FAILURE;
  if (! i) return LFC_SUCCESS;

  i--;
  LFC_FREE( argv[i] );
  argv[i] = NULL;

  return LFC_SUCCESS;
}	/* LFC_argvPop */

int
LFC_argvLen(char **argv, int *ulen) {
  int i;

  if (! argv) return LFC_FAILURE;

  for (i = 0; argv[i] && argv[i] != argvSentinel; i++) ;

  if (ulen) *ulen = i;

  return LFC_SUCCESS;
}	/* LFC_argvLen */

int
LFC_argvPrint(char **argv) {
  int i;

  if (! argv) return -1;

  for (i = 0; argv[i] && argv[i] != argvSentinel; i++) {
    if (i) printf( " " );
    printf( "`%s'", argv[i] );
  }
  printf( "\n" );

  return 0;
}	/* LFC_argvPrint */

int
LFC_argvDelete(char ***uargv) {
  char **argv; int i;

  if (uargv) argv = *uargv;
  else return -1;

  for (i = 0; argv[i] != argvSentinel; i++)
    if (argv[i]) LFC_FREE( argv[i] );

  LFC_FREE( argv );
  *uargv = NULL;

  return 0;
}	/* LFC_argvDelete */

char *
LFC_gopt(char *argv[], /*const*/ char *pfx, /*const*/ char *f, void *p) {
  int i, n;
  char *null = NULL;

  if (! argv || ! pfx) return null;
  n = strlen( pfx );
  for (i=0; argv[i]; i++)
    if (! strncmp( argv[i], pfx, n )) {
      if (f && p && strlen( f )) {
        if (sscanf( argv[i] + n, f, p ) == 1) return argv[i] + n;
        else return null;
      } else return argv[i] + n;
    }
  return null;
}	/* LFC_gopt */

int
LFC_argv_mpi(char tmat, char *matf, char trhs, char *rhsf, char tsol, char *solf,
  char tluf, char *luff, char *machinefile, int m, int n, int nrhs, int nb,
  int gp, int gq, int opcode, char **addargv, char ***uargv) {
  char **argv; int i, nproc = gp * gq, rv, failure;

  if (! uargv) return LFC_FAILURE;

  rv = LFC_argvNew( &argv, 50 );

  if (rv) return LFC_FAILURE;

  /* FIXME: what if MPI does not pass arguments? */

  failure = 0;
  if (! failure && LFC_argvAppend( &argv, "%s", "mpirun" )) failure = 1;
  if (! failure && machinefile) { /* it's MPICH */
    /* this doesn't work reliably with MPICH */
    /*
    if (! failure && LFC_argvAppend( &argv, "%s", "-np" ))  failure = 1;
    if (! failure && LFC_argvAppend( &argv, "%d", &nproc )) failure = 1;
    if (! failure && LFC_argvAppend( &argv, "%s", "-nolocal" ))    failure = 1;
    if (! failure && LFC_argvAppend( &argv, "%s", "-machinefile" ))failure = 1;
    if (! failure && LFC_argvAppend( &argv, "%s", machinefile ))   failure = 1;
    */
    if (! failure && LFC_argvAppend( &argv, "%s", "-p4pg" ))     failure = 1;
    if (! failure && LFC_argvAppend( &argv, "%s", machinefile )) failure = 1;
  }
  if (! failure && LFC_argvAppend( &argv, "%s", LFC_getPDSLVpath() )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "m=%d", &m ))      failure = 1;
  if (! failure && LFC_argvAppend( &argv, "n=%d", &n ))      failure = 1;
  if (! failure && LFC_argvAppend( &argv, "nrhs=%d", &nrhs ))failure = 1;
  if (! failure && LFC_argvAppend( &argv, "mb=%d", &nb ))    failure = 1;
  if (! failure && LFC_argvAppend( &argv, "nb=%d", &nb ))    failure = 1;
  if (! failure && LFC_argvAppend( &argv, "gp=%d", &gp ))    failure = 1;
  if (! failure && LFC_argvAppend( &argv, "gq=%d", &gq ))    failure = 1;
  if (! failure && LFC_argvAppend( &argv, "tmat=%c", &tmat )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "trhs=%c", &trhs )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "tsol=%c", &tsol )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "tluf=%c", &tluf )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "mat-fname=%s", matf )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "rhs-fname=%s", rhsf )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "sol-fname=%s", solf )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "luf-fname=%s", luff )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "opcode=%d", &opcode )) failure = 1;
  if (! failure && LFC_argvAppend( &argv, "verbose=1", "" )) failure = 1;

  if (addargv) {
    for (i = 0; addargv[i]; i++) {
      if (! failure && LFC_argvAppend( &argv, addargv[i], "" )) failure = 1;
      if (failure) break;
    }
  }

  if (failure) {
    *uargv = argv;
    LFC_argvDelete( uargv );
    return LFC_FAILURE;
  }

  LFC_argvPrint( argv );

  *uargv = argv;
  return LFC_SUCCESS;
}	/* LFC_argv_mpi */

LFC_END_C_DECLS
