/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


#ifndef CUBE_THREAD_H
#define CUBE_THREAD_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Thread
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;

#include <iostream>

#include <vector>
  using std::vector;

#include "Location.h"

class Process;

class Thread: public Location {
  
 public:

  Thread(int loc_id, int thread_id, string name, Process* proc):
    Location(loc_id), id(thread_id), name(name), proc(proc) {}
  
  const Process* get_proc()          { return proc; }
  int get_id()                       { return id; }
  string get_name()                  { return name; }

  const Vertex* get_child(int)         { return NULL; }
  int num_children()           { return 0; }

 private:
  
  int id;
  string name;
  Process* proc;
};

std::ostream& operator<<(std::ostream& out, Thread& thrd);

#endif


