/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/*******************************************
     Node.cpp

********************************************/

#include "Node.h"
#include "CUBException.h"

using namespace std;
const Process* Node::get_child(int i)     {
  if (i < 0 || i >= processv.size()) 
    throw CUBException("vector out of range");

  return processv[i]; 
}

ostream& operator <<(ostream& out, Node& node) {
  Process* p;
  int level;
  
  level = node.get_level();

  out << node.indent() << "<node id=\"" << node.get_id(); 
  out << "\" locId=\"" << node.get_locid()<< "\">\n";

  node.set_level(level+1);
  out << node.indent() << "<name>" << node.get_name() << "</name>\n";
  // out << node.indent() << "<cpuNum>" << node.get_cpu_num() << "</cpuNum>\n";
  
  for(int i = 0; i < node.num_children() ; i++) {
    p = (Process* ) node.get_child(i);
    p->set_level(level+1);
    out << *p;
  }

  node.set_level(level);
  out << node.indent() << "</node>\n";

  return out;
}
