/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _MODULE_H
#define _MODULE_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Module
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;

#include <vector>
  using std::vector;

#include "Vertex.h"
#include "Region.h" 

//class Region;

class Module: public Vertex {

 public:

  //constructor
  Module(int id, string name) : 
    Vertex(), id(id), name(name)             { };
  
  int    get_id()                            { return id; }
  string get_name()                          { return name; }
  // string get_path()                          { return path; }

  void   add_region(Region* region)          { regionv.push_back(region); }
  int    num_region()                        { return num_children(); }

  const Region* get_child(int i);
  int num_children()                   { return regionv.size(); }
  
 private:
  
  int id;
  // string path; /* might be empty */
  string name;
  vector<Region*> regionv;

};

std::ostream& operator <<(std::ostream& out, Module& module);

#endif
