/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/*******************************************
     Metric.cpp

********************************************/

#include "Metric.h"
#include "CUBException.h"
using namespace std;

const Metric* Metric::get_child(int i) { 
  if (i < 0 || i >= childv.size()) {
    throw CUBException("vector out of range");
  }
  
  return childv[i]; 
}

ostream& operator <<(ostream& out, Metric& met) {
  Metric* p;
  int level;
  
  level = met.get_level();

  out << met.indent() << "<metric id=\"" << met.get_id() 
      << "\">" << endl;
  met.set_level(level+1);
  out << met.indent() << "<name>" << met.get_name() << "</name>" << endl;
  out << met.indent() << "<uom>"  << met.get_uom() << "</uom>" << endl;
  out << met.indent() << "<descr>" << met.get_descr() 
      << "</descr>" << endl;

  for(int i = 0; i < met.num_children() ; i++) {
    p = (Metric* ) met.get_child(i);
    p->set_level(level+1);
    out << *p;
  }

  met.set_level(level);
  out << met.indent() << "</metric>" << endl;

  return out;
}
