/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/***************************************
					
       CnodeTree class
     
     
***************************************/


#ifndef _CUBE_CNODE_TREE_H
#define _CUBE_CNODE_TREE_H

#include <string>

#include "wx/wx.h"
#include "wx/treectrl.h"
#include "Tree.h"

class Cube;

class CnodeTree : public Tree {
 public:
  CnodeTree (wxWindow* parent); 
  ~CnodeTree() {}
  
  // resulted from a changing metric tree
  void refresh (int met_id, int met_mode);

  DECLARE_EVENT_TABLE()
    
 private: 
  /* context menu handler */
  void   OnDes               (wxCommandEvent& event);
  void   OnSourceCode        (wxCommandEvent& event);

  void   display_region_code (int begn_ln, int end_ln);

  void   cnode_descr_dlg     (int cnode_id);
  void   region_descr_dlg    (int regn_id);

  std::string get_line       (std::string pathname, std::string filename, int line);
  
  /* tree event */
  void OnExpanded    (wxTreeEvent& event);
  void OnCollapsed   (wxTreeEvent& event);
  void OnRightClick  (wxTreeEvent& event);
  void OnSelChanged  (wxTreeEvent& event);


  void traverse_calltree (wxTreeItemId root, Cube* cube);
  void traverse_functree (wxTreeItemId root, Cube* cube);
  void refresh_loc_tree4func (wxTreeItemId treeitem_id);
  void set_funcnode_label(wxTreeItemId cur, Cube* cube);

  int target_met_id, target_met_mode; // the corresponding 1st dimension id.

  std::string default_path; // default directory
  std::string successpath;  // correct path having passed get_line()

  wxTreeItemId old_sel; // last selected treeitem id
};

enum CnodePopMenu
  { /*Cnode_POP_ID_Item1,
    Cnode_POP_ID_Item2,
    Cnode_POP_ID_Item3,
    Cnode_POP_ID_Item4,
    Cnode_POP_ID_Item5,*/
    Cnode_POP_ID_Des,
    Cnode_POP_ID_Code
  };

#endif
