/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/*******************************************
     Callsite.cpp

********************************************/

#include "Callsite.h"
#include "Region.h"
#include "Cnode.h"
#include "CUBException.h"

using namespace std;

const Module* Callsite:: get_mod() { 
  if (caller != NULL) {
    return caller->get_mod();
  } else {
    return callee->get_mod();
  }
}

/* get the ith cnode pointing to this callsite */
const Cnode*  Callsite::get_cnode(int i) {
  if (i < 0 || i >= num_cnodes()) 
    throw CUBException("vector out of range");
  return cnodev[i]; 
}

ostream& operator <<(ostream& out, Callsite& csite) {
  int level;
  
  level = csite.get_level();

  out << csite.indent() << "<csite id=\"" << csite.get_id() 
      << "\">\n";
  csite.set_level(level+1);
  out << csite.indent() << "<line>" << csite.get_line() << "</line>\n";
  out << csite.indent() << "<callee>"  
      << ((Region*)csite.get_callee())->get_id() << "</callee>\n";

  csite.set_level(level);
  out << csite.indent() << "</csite>\n";

  return out;

}

