/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _REGION_H
#define _REGION_H

/*
 *----------------------------------------------------------------------------
 *
 * class Region
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;

#include <vector>
  using std::vector;

#include "Vertex.h"
#include "Callsite.h"

class Module;

class Region: public Vertex {
  
 public:

  Region(int id, string name, Module* mod, int begln, int endln, string descr):
    Vertex(), id(id), name(name), mod(mod), begln(begln), endln(endln)
    , descr(descr) {}
  
  int get_id()                       { return id; }
  string get_name()                  { return name; }
  string get_descr()                 { return descr; }

  const Module* get_mod()            { return mod; }

  void add_csite(Callsite* csite)    { csitev.push_back(csite); }
  int num_csite()                    { return num_children(); }


  const Callsite* get_child(int i);
  int num_children()           { return csitev.size(); }

  int get_begn_ln()                  { return begln; }
  int get_end_ln()                   { return endln; }

 private:

  int id;
  string name;
  int begln;
  int endln;
  string descr;

  Module* mod;
  vector<Callsite*> csitev;
  
};

std::ostream& operator <<(std::ostream& out, Region& reg);

#endif
