/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


#ifndef _METRIC_H
#define _METRIC_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Metric
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;
#include <vector>
  using std::vector;
#include <iostream>

#include "Vertex.h"

class Metric: public Vertex 
{
 public:

  /* constructor */
  Metric(int id, string name, string uom, string descr, Metric* parent): 
    Vertex(), id (id), name(name), uom(uom), descr(descr), parent(parent) {} 

  /* add a child metric */  
  void add_child(Metric* child)         { childv.push_back(child); }

  /* number of direct children */
  int num_children()              { return childv.size(); }
  const Metric* get_child(int i);

  const Metric* get_parent()            { return parent; }

  int get_id()                          { return id; }

  string get_name()                     { return name; }
  string get_uom()                      { return uom; }
  string get_descr()                    { return descr; }

 private:
  
  int id;
  string name;
  string uom;
  string descr; // metric description

  /* tree structure */
  vector<Metric* > childv;
  Metric* parent;
  

};

std::ostream& operator <<(std::ostream& out, Metric& metric);

#endif













































