/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***************************************
					
       Tree class
     
     an abstract class
***************************************/


#ifndef _CUBE_TREE_H
#define _CUBE_TREE_H

#include <string>
  using std::string;
#include "wx/wx.h"
#include "wx/treectrl.h"

/* each tree node is associated with a cube object id. */
class NodeData : public wxTreeItemData {
 public:
  NodeData(int id) : id(id) {} 
  int get_id()       { return id; }

 private:
  int id;

};

/* derived from the wxWindows tree class */
class Tree : public wxTreeCtrl {
 public:
  Tree               (wxWindow* parent);
  ~Tree();
  // index is the spectrum color order.
  wxTreeItemId AddRoot           (const string text, int index);
  wxTreeItemId AppendItem        (const wxTreeItemId& parent, const string text, int index, 
				  NodeData* data=NULL);
  void SetItemText      (const wxTreeItemId& item_id, const string text, int index);
  void SetItemData      (const wxTreeItemId& item_id, NodeData* data);
  NodeData* GetItemData (const wxTreeItemId& item_id);

  wxTreeItemId GetSelection ();
  wxTreeItemId GetRootItem()     { return real_root; }
  wxTreeItemId GetVRootItem()    { return virtual_root; }

  DECLARE_EVENT_TABLE()

  wxMenu*      popup_menu;
  wxTreeItemId right_click_item; 
  
 private:
  virtual void OnSelChanged  (wxTreeEvent& event) = 0;
          void OnSelChanging (wxTreeEvent& event);
  virtual void OnExpanded    (wxTreeEvent& event) = 0;
  virtual void OnCollapsed   (wxTreeEvent& event) = 0;
  virtual void OnRightClick  (wxTreeEvent& event) = 0;

  wxTreeItemId virtual_root;
  wxTreeItemId real_root; // last constructed sub root
};

#endif
