/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/*******************************
				
     Tree.cpp	
					
********************************/

#include <iostream>
#include "Tree.h"
#include "SpectrumPane.h"
#include "PresenterApp.h"
#include "PresenterFrame.h"

using namespace std;


BEGIN_EVENT_TABLE(Tree, wxTreeCtrl)
EVT_TREE_SEL_CHANGED      (-1, Tree::OnSelChanged)
EVT_TREE_SEL_CHANGING     (-1, Tree::OnSelChanging)
EVT_TREE_ITEM_EXPANDED    (-1, Tree::OnExpanded)
EVT_TREE_ITEM_COLLAPSED   (-1, Tree::OnCollapsed)
EVT_TREE_ITEM_RIGHT_CLICK (-1, Tree::OnRightClick)
END_EVENT_TABLE()



Tree::Tree(wxWindow* parent): 
  wxTreeCtrl(parent, -1, wxDefaultPosition, wxDefaultSize,
	     wxTR_DEFAULT_STYLE|wxSUNKEN_BORDER|wxTR_HIDE_ROOT|
	     wxTR_HAS_BUTTONS) {
  //AssignImageList(((PresenterApp*)wxTheApp)->get_image_list());
  SetImageList(((PresenterApp*)wxTheApp)->get_image_list());
  popup_menu = new wxMenu;
  wxTreeItemId id;
  // virtual invisible root.
  id = wxTreeCtrl::AddRoot(_T(""));
  SetItemData(id, new NodeData(-1)); // the virtual hidden root has id of -1
  virtual_root = id;
  // SetIndent(10);
}

Tree::~Tree() {

}

wxTreeItemId Tree::AddRoot(const string text, int index) {
  wxTreeItemId id;
  /*
  // virtual invisible root.
  id = wxTreeCtrl::AddRoot(wxString(text.c_str()));
  virtual_root = id;
  //SetItemImage(id, index);
  */
  // real root
  id = wxTreeCtrl::AppendItem(virtual_root, wxString(text.c_str()));
  SetItemImage(id, index);
  real_root = id;
  return id;
}

wxTreeItemId 
Tree::AppendItem(const wxTreeItemId& parent, const string text, int index, NodeData* data) {
  wxTreeItemId id;
  
  id = wxTreeCtrl::AppendItem(parent, wxString(text.c_str()), -1, -1, data);
  SetItemImage(id, index);
  return id;
}

void Tree::SetItemText(const wxTreeItemId& item_id, const string text, int index) {
  wxTreeCtrl::SetItemText(item_id, wxString(text.c_str()));
  SetItemImage(item_id, index);
}

void Tree::SetItemData(const wxTreeItemId& item_id, NodeData* data) {
  wxTreeCtrl::SetItemData(item_id, data);
}

NodeData* Tree::GetItemData(const wxTreeItemId& item_id) {
  return (NodeData*) wxTreeCtrl::GetItemData(item_id);
}

wxTreeItemId Tree::GetSelection() {
  return wxTreeCtrl::GetSelection();
}

void Tree::OnSelChanging(wxTreeEvent& event) {

}

