/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


#ifndef _CUBE__MATRIX_H
#define _CUBE__MATRIX_H   

/*
 *----------------------------------------------------------------------------
 *
 * class CubeMatrix (sparse matrix implemented with C++ map)
 *
 +
 *----------------------------------------------------------------------------
 */

#include <map>
  using std::map;
#include <iostream>

typedef map<int, map<int, double> > Map2D;

class CubeMatrix: public Map2D {

 public:
  
  CubeMatrix(): Map2D() { }
  CubeMatrix(const CubeMatrix& mat) : Map2D(mat) { }// copy constructor
  CubeMatrix(const Map2D& mat): Map2D(mat)       { }

  double sum();
  
  const static int MAX_COLS = 32767;
  const static int MAX_ROWS = 32767;

 private:


};


// matrix - operator
CubeMatrix operator-(CubeMatrix& mat1, CubeMatrix& mat2);
map<int, double> operator-(map<int, double>& map1, map<int, double>& map2);
map<int,double> operator-(map<int, double>& map1);

// matrix + operator
CubeMatrix operator+(CubeMatrix& mat1, CubeMatrix& mat2);
map<int, double> operator+(map<int, double>& map1, map<int, double>& map2);

// matrix / operator
CubeMatrix operator/(CubeMatrix& mat, double d);


// print out the matrix
std::ostream& operator<<(std::ostream& out, CubeMatrix& matrix);

#endif
