/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


#ifndef _PROCESS_H
#define _PROCESS_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Process
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;

#include <vector>
  using std::vector;

#include "Location.h"
#include "Thread.h"

class Node;

class Process: public Location {
  
 public:

  Process(int loc_id, int process_id, string name, Node* node):
    Location(loc_id), id(process_id), name(name), node(node) {}
  
  void add_thrd(Thread* thrd)        { threadv.push_back(thrd); }
  int num_thrd()                     { return num_children() ; }
  
  const Node* get_node()               { return node; }

  const Thread* get_child(int i); 
  int num_children()           { return threadv.size(); }

  int get_id()                       { return id; }
  string get_name()                  { return name; }

 private:
  
  int id;
  string name;
  Node* node;
  vector<Thread*> threadv;

};


std::ostream& operator <<(std::ostream& out, Process& process);

#endif
