/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _NODE_H
#define _NODE_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Node 
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;

#include <iostream>

#include <vector>
  using std::vector;

#include "Location.h"
#include "Process.h"

class Machine;

class Node: public Location {
  
 public:
  
  Node(int loc_id, int node_id, string name, Machine* mach):
    Location(loc_id), id(node_id), name(name), mach(mach) {}

  void add_proc(Process* process)    { processv.push_back(process); }
  int num_proc()                     { return num_children(); }

  const Machine* get_mach()          { return mach; }

  const Process* get_child(int i); 
  int num_children()           { return processv.size(); }

  int get_id()                       { return id; }
  string get_name()                  { return name; }
  
 private:
  
  int id;
  string name;
  Machine* mach;
  vector<Process* > processv;

};

std::ostream& operator <<(std::ostream& out, Node& node);

#endif
