/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _MACHINE_H
#define _MACHINE_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Machine
 *
 *----------------------------------------------------------------------------
 */
#include <iostream>
#include <string>
  using std::string;

#include <vector>
  using std::vector;

#include "Location.h"
#include "Node.h"

class Grid;

class Machine: public Location {
  
 public:
  
  Machine(int loc_id, int mach_id, string name, Grid* grid):
    Location(loc_id), id(mach_id), name(name), grid(grid) {}
  
  void add_node(Node* node)        { nodev.push_back(node); }
  int num_node()                 { return num_children(); }

  const Grid* get_grid()        { return grid; }

  const Node* get_child(int i);
  int num_children()      { return nodev.size(); }
  
  int get_id()                  { return id; }
  string get_name()             { return name; }


 private:
  
  int id; /* machine id */
  string name;
  Grid* grid; /* machine's parent is a Grid */
  vector<Node*> nodev;

};

std::ostream& operator <<(std::ostream& out, Machine& mach);

#endif
