/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/*******************************************
     Grid.cpp

********************************************/

#include "Grid.h"
#include "CUBException.h"
using namespace std;

const Machine* Grid::get_child(int i) {
  if (i < 0 || i >= machinev.size()) 
    throw CUBException("vector out of range");
  
  return machinev[i]; 

}

ostream& operator <<(ostream& out, Grid& grid) {
  Machine* m;
  int level;
  
  level = grid.get_level();

  out << grid.indent() << "<grid id=\"" << grid.get_id(); 
  out << "\" locId=\"" << grid.get_locid()<< "\">"<<endl;

  grid.set_level(level+1);
  out << grid.indent() << "<name>" << grid.get_name() << "</name>" << endl;

  for(int i = 0; i < grid.num_children() ; i++) {
    m = (Machine* ) grid.get_child(i);
    m->set_level(level+1);
    out << *m;
  }

  grid.set_level(level);
  out << grid.indent() << "</grid>" << endl;

  return out;
}
