/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***********************************

     SourceCodeDlg.cpp

************************************/
#include <iostream>
#include "SourceCodeDlg.h"
#include "PresenterFrame.h"
#include "PresenterApp.h"

using namespace std;

SourceCodeDlg::SourceCodeDlg(wxWindow* parent) : 
  wxDialog(parent, -1, "Source code viewer", wxDefaultPosition, wxSize(400, 300),
	   wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER) {
  sizer = new wxBoxSizer(wxVERTICAL);    // row by row
  gridsizer = new wxFlexGridSizer(2,2);  // 2 x 2 table
  // 2 rows of callsite info.
  name_label = new wxStaticText(this, -1, "                           ");
  line_label = new wxStaticText(this, -1, "                           ");
  gridsizer->Add(new wxStaticText(this, -1, "Module name: "));
  gridsizer->Add(name_label);
  gridsizer->Add(new wxStaticText(this, -1, "Line number: "));
  gridsizer->Add(line_label);
  // sourcode edit box
  text_area = new 
    wxTextCtrl(this, -1, "", wxDefaultPosition, wxSize(380, -1),
	       wxTE_MULTILINE|wxTE_READONLY);
  sizer->Add(gridsizer, 0, wxALL, 10); // no expand vertically
  sizer->Add(text_area, 1, wxEXPAND|wxALL, 10); // permit expand vertically and both
  sizer->Add(new wxButton(this, wxID_OK, _T("&Ok")), 0,
	    wxALIGN_CENTRE_HORIZONTAL|wxALL, 10);
  SetSizer(sizer);
  new_mod = true; // display for same module or not?
  old_modname = "";
  old_begn_pos = old_end_pos = 0;
}

SourceCodeDlg::~SourceCodeDlg() {
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  frame->set_source_dlg(NULL);
}

void SourceCodeDlg::show_module(string fname) {
  if (fname.compare(old_modname)!=0) {
    clear();
    text_area->LoadFile(fname.c_str());
    old_modname = fname;
    new_mod = true;
  }
  new_mod = false;
}

void SourceCodeDlg::clear()  {
  text_area->Clear(); 
}

// not used any more.
void SourceCodeDlg::add_line(string line, bool marked) {
  /*
  if (marked) {
    text_area->SetDefaultStyle(wxTextAttr(*wxWHITE,*wxBLUE));
  } else
    text_area->SetDefaultStyle(wxTextAttr(*wxBLACK, *wxWHITE));
  *text_area << wxString(line.c_str()) << "\n";
  */
}

void SourceCodeDlg::highlight  (int begin_line, int end_line) {
  if (!new_mod) {
    //  unmark previous highlighted area
    text_area->SetStyle(old_begn_pos, old_end_pos, wxTextAttr(*wxBLACK, *wxWHITE));
  }
  long beginP = text_area->XYToPosition(0, begin_line-1);
  long endP = text_area->XYToPosition(text_area->GetLineLength(end_line-1),
				      end_line-1);
  text_area->SetStyle(beginP, endP, wxTextAttr(*wxWHITE,*wxBLUE));
  old_begn_pos = beginP;
  old_end_pos = endP;
}
void SourceCodeDlg::show_line(int line) {
  if ((line = line - 4) < 0) line = 0; // there are 2 lines of slot
  long pos = text_area->XYToPosition(0, line);
  text_area->ShowPosition(pos);
}

void SourceCodeDlg::set_module(string name) {
  name_label->SetLabel(name.c_str());
}
void SourceCodeDlg::set_line  (int line) {
  wxString s;
  if (line > 0) {
    s.Printf("%d", line);
  } else {
    // the line number is not defined by users
    s = "line# undefined, callee is displayed";
  }
  line_label->SetLabel(s);
}
