/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/*******************************
				
    MetricTree.cpp	
					
********************************/

#include <iostream>
#include <strstream>

#include "Tree.h"
#include "MetricTree.h"
#include "CnodeTree.h"
#include "PresenterApp.h"
#include "PresenterFrame.h"
#include "Metric.h"


using namespace std;

BEGIN_EVENT_TABLE(MetricTree, Tree)
  // For menu items
  EVT_MENU               (Met_POP_ID_Des, MetricTree::OnDescr)
END_EVENT_TABLE()
/*
void MetricTree::OnId(wxCommandEvent& event) {
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  Cube& cube = frame->get_cube();
  wxTreeItemId sel = GetSelection();
  wxString text;
  int id = GetItemData(sel)->get_id();
  if (id >= 0) {
    //Metric* p = (Metric*) cube.get_met(id);
    text.Printf("Metric id: %d \n", id);
    wxMessageBox(text, _T(""), wxOK, this);
  }
}
*/
void MetricTree::OnDescr(wxCommandEvent& event) {
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  Cube* cube = frame->get_cube();
  wxTreeItemId sel = right_click_item; //GetSelection();
  wxString text;
  int id = GetItemData(sel)->get_id();
  if (id >= 0) {
    Metric* p = (Metric*) cube->get_met(id);
    string descr = p->get_descr();
    text.Printf("Description: %s \n", descr.c_str());
    wxMessageBox(text, _T("Metric description"), wxOK, this);
  }

}

MetricTree::MetricTree(wxWindow* parent) : Tree(parent) {
  // popup_menu->Append(Met_POP_ID_Item1, _T("Metric ID"));
  popup_menu->Append(Met_POP_ID_Des, _T("Description"));
}

void MetricTree::OnExpanded(wxTreeEvent& event) {
  wxTreeItemId id = event.GetItem();
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  int met_id = GetItemData(id)->get_id();
  int mode[] = {CUBE_EXCL, -1, -1};
  double sev = frame->get_cube()->
    get_vsev(mode, met_id, -1, -1, frame->is_calltree());

  string label = frame->get_cube()->
    gen_met_label(met_id, sev, frame->view_type(), 0, false);
  SetItemText(id, label, frame->get_cube()->index(sev, 0, 0, met_id));
  //if it's also the selected metric. 
  if (IsSelected(id)) 
    frame->get_cnode_tree()->refresh(met_id, CUBE_EXCL);
}

void MetricTree::OnCollapsed(wxTreeEvent& event) {
  wxTreeItemId id = event.GetItem();
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  int met_id = GetItemData(id)->get_id();
  int mode[] = {CUBE_INCL, -1, -1};
  double sev = frame->get_cube()->get_vsev(mode, met_id, -1, -1,
					  frame->is_calltree());
  string label = frame->get_cube()->
    gen_met_label(met_id, sev, frame->view_type(), 0, false);
  SetItemText(id, label,frame->get_cube()->index(sev, 0, 0, met_id));
  // if it's also the selected metric
  if (IsSelected(id))
    frame->get_cnode_tree()->refresh(met_id, CUBE_INCL);

}

void MetricTree::OnSelChanged(wxTreeEvent& event) {
  //int id = (int) event.GetItem();
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  wxTreeItemId id = GetSelection(); // newly selected node.
  int met_id = GetItemData(id)->get_id();
  int met_mode;

  frame->get_cube()->set_cur_met(met_id); // notify cube of the change
  if (IsExpanded(id)) met_mode = CUBE_EXCL;
  else met_mode = CUBE_INCL;
  frame->get_cnode_tree()->refresh(met_id, met_mode);
  // refresh spectrum pane's max values if metric tree changes
  Metric* cur = (Metric*) frame->get_cube()->get_met(met_id);
  Metric* parent = (Metric*) cur->get_parent();
  frame->get_spectrum_pane()->Refresh();
}

void MetricTree::OnRightClick(wxTreeEvent& event) {
  right_click_item = HitTest(event.GetPoint());
  PopupMenu(popup_menu, event.GetPoint());
}

void MetricTree::refresh () {
  // cout << "metric tree is updated." << endl;
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  wxTreeItemId id = GetSelection(); // newly selected node.
  int met_id = GetItemData(id)->get_id(); // useful for call tree
  int met_mode;
  if (IsExpanded(id)) met_mode = CUBE_EXCL;
  else met_mode = CUBE_INCL;
  Cube* cube = frame->get_cube();
  traverse(wxTreeCtrl::GetRootItem(), cube, frame->is_calltree());
  // also refresh cnode_tree
  frame->get_cnode_tree()->refresh(met_id, met_mode);
}

void MetricTree::traverse(wxTreeItemId root, Cube* cube, bool calltree) {
  long cookie;
  double sev;
  ostrstream out;
  out.precision(PRECISION);
  out.setf(ios::fixed);
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  // update the root's label.
  int mode = IsExpanded(root) ? CUBE_EXCL : CUBE_INCL;
  int id = GetItemData(root)->get_id();
  if (id >= 0) {
    int modeflags[3];
    modeflags[CUBE_MET] = mode;
    modeflags[CUBE_PROG] = -1;
    modeflags[CUBE_LOC] = -1;
    sev = cube->get_vsev(modeflags, 
			id, -1, -1, calltree);
    /*
    double shownsev = cube.sev4view(sev, frame->view_type(), 0, id);
    Metric* p = (Metric*)cube.get_met(id);
    out << shownsev<<" "<< p->get_name() << " ";
    *(out.str()+out.pcount()) = 0; // make the string end of '0'
    */
    string label = cube->gen_met_label(id, sev, frame->view_type(), 0, false);
    SetItemText(root, label, cube->index(sev, 0, 0, id));
  }
  if (GetChildrenCount(root) == 0) {
    return;
  }
  wxTreeItemId child = GetFirstChild(root, cookie); 
  traverse(child, cube, calltree);
  while (child = GetNextChild(root, cookie)) {
    traverse(child, cube, calltree);
  }
  return;
}
