/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/******************************
     testing the Cube class

*******************************/

#include <iostream>
#include <string>
#include <vector>
#include <fstream>

using namespace std;

#include "Cube.h"
#include "Metric.h"
#include "Cnode.h"
#include "Process.h"
#include "Node.h"
#include "Thread.h"



/* Debug: only used for Metric, Cnode */
template<class T>
void traverse_print(T root) {
  cout << root->get_id() << endl;
  for(int i = 0; i < root->num_children(); i++) {
    traverse_print<T>((T) root->get_child(i));
  }
}

int main(int argc, char* argv[]) {
  Cube cube;  
  int id0, id1, id2;
  // test metrics dimension 
  id0 = cube.def_met("Time", "sec", "root", -1);
  id1 = cube.def_met("User time", "sec", "2nd level", id0);
  id2 = cube.def_met("System time", "sec", "2nd level", id0);

  // test callnode dimension
  int id = cube.def_module("main.cpp");
  id0 = cube.def_region("main", 100, 200, "1st level", id);
  id1 = cube.def_region("foo", 20, 80, "2nd level", id);
  id2 = cube.def_region("bar", 200, 300, "3rd level", id);
  int id3 = cube.def_csite(id, 3, id0);
  int id4 = cube.def_csite(id, 150, id1);
  int id5 = cube.def_csite(id, 160, id2);
  id0 = cube.def_cnode(id3, -1);
  id1 = cube.def_cnode(id4,id0);
  cube.def_cnode(id5, id0);

  // test location dimension
  id0 = cube.def_grid("Grid in ICL");
  id0 = cube.def_mach("msc", id0);
  id0 = cube.def_node("athena",  id0);
  id0 = cube.def_proc("Process 0", id0);
  cube.def_thrd("Thread 0", id0);
  cube.def_thrd("Thread 1", id0);
  
  // test severity matrix
  cube.set_sev(0, 0, 0, 4);
  cube.set_sev(0, 0, 1, 4);
  cube.set_sev(0, 1, 0, 4);
  cube.add_sev(0, 1, 1, 4);
  cube.add_sev(0, 2, 0, 4);
  cube.add_sev(0, 2, 1, 4);
  cube.set_sev(1, 0, 0, 1);
  cube.set_sev(1, 0, 1, 1);
  cube.set_sev(1, 1, 0, 1);
  cube.add_sev(1, 1, 1, 1);
  cube.add_sev(1, 2, 0, 1);
  cube.add_sev(1, 2, 1, 1);
  cube.set_sev(2, 0, 0, 1);
  cube.set_sev(2, 0, 1, 1);
  cube.set_sev(2, 1, 0, 1);
  cube.add_sev(2, 1, 1, 1);
  cube.add_sev(2, 2, 0, 1);
  cube.add_sev(2, 2, 1, 1);

  // output to xml.
  ofstream out;
  out.open("a.xml");
  cout<<"Created a cube space in memory \n";
  out << cube;
  cout<<"Output it to XML doc: a.xml. \n\n";
  out.close();
 
  // read xml in.
  Cube cube2;
  ifstream in ("a.xml");
  if (!in) cout << "open a.xml Error \n";
  in >> cube2;
  in.close();
  // output to xml again
  out.open("b.xml");
  out << cube2;
  cout << "Read out a.xml, then write it as b.xml" << endl << endl;
  out.close();
  cout<<"\nCube success: hello, world! \n\n";
  
  /* cout << "*********TEST SPARSE CUBE MATRIX***************" << endl;
  CubeMatrix m1, m2;
  m1[0][0] = 2, m1[0][1] = 2;
  m2[1][0] = 1, m2[1][1] = 1;
  CubeMatrix m3 = m2 - m1;
  cout << m3; */

  cout << "********** testing CUBE performance algebra ******" <<endl;
  Cube cube3, cube4;
  in.open("/home/song/ICL/examples/sweep3d_mpi_150_16.cube");
  in >> cube3;
  in.close();
  in.open("/home/song/ICL/examples/sweep3d_mpi_50_16.cube");
  in >> cube4;
  in.close();
  cube3 -= cube4;
  out.open("diff.cube");
  out << cube3;
  out.close();
  cout << "performance algebra tesing done!" << endl;
  
}
