/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


#ifndef _VERTEX_H
#define _VERTEX_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Vertex 
 *
 *----------------------------------------------------------------------------
 */

#include <string>

#define INDENTSPACE 2

class Vertex 
{
 public:
  
  Vertex() {}

  void set_level(int level)      { this->level = level; }
  int  get_level()         { return level;  }

  std::string indent()           { return std::string(INDENTSPACE*level,' '); }

  virtual int   num_children()    = 0;
  virtual const Vertex* get_child(int i)  = 0;

 private:

  int level;

};

#endif
