/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/*******************************************
     Region.cpp

********************************************/

#include "Region.h"
#include "CUBException.h"
using namespace std;

const Callsite* Region::get_child(int i)   {
  if (i < 0 || i >= csitev.size()) 
    throw CUBException("vector out of range");
  return csitev[i]; 
}

ostream& operator <<(ostream& out, Region& reg) {
  Callsite* csite;
  int level;
  
  level = reg.get_level();

  out << reg.indent() << "<region id=\"" << reg.get_id() 
      << "\">" << endl;
  reg.set_level(level+1);
  out << reg.indent() << "<name>" << reg.get_name() << "</name>" << endl;
  out << reg.indent() << "<begin>" << reg.get_begn_ln()<< "</begin>" << endl;
  out << reg.indent() << "<end>" << reg.get_end_ln() << "</end>" << endl;
  out << reg.indent() << "<descr>" << reg.get_descr() 
      << "</descr>" << endl;

  for(int i = 0; i < reg.num_children() ; i++) {
    csite = (Callsite* ) reg.get_child(i);
    csite->set_level(level+1);
    out << *csite;
  }
  reg.set_level(level);
  out << reg.indent() << "</region>" << endl;

  return out;
}
