/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/*******************************************
     Process.cpp

********************************************/

#include "Process.h"
#include "CUBException.h"
using namespace std;

const Thread* Process::get_child(int i) {
  if (i < 0 || i >= threadv.size()) 
    throw CUBException("vector out of range");
  return threadv[i]; 
  
}

ostream& operator <<(ostream& out, Process& process) {
  Thread* thrd;
  int level;
  
  level = process.get_level();

  out << process.indent() << "<process id=\"" << process.get_id(); 
  out << "\" locId=\"" << process.get_locid()<< "\">"<<endl;

  process.set_level(level+1);
  out << process.indent() << "<name>" << process.get_name() << "</name>" << endl;

  for(int i = 0; i < process.num_children() ; i++) {
    thrd = (Thread* ) process.get_child(i);
    thrd->set_level(level+1);
    out << *thrd;
  }

  process.set_level(level);
  out << process.indent() << "</process>" << endl;

  return out;
}
