/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/*******************************************
     Module.cpp

********************************************/

#include "Module.h"
#include "CUBException.h"

using namespace std;


const Region* Module::get_child(int i)  { 
  if (i < 0 || i >= regionv.size()) 
      throw CUBException("vector out of range");
    return regionv[i]; 
}
  
ostream& operator <<(ostream& out, Module& mod) {
  Region* r;
  int level;
  
  level = mod.get_level();

  out << mod.indent() << "<module id=\"" << mod.get_id() 
      << "\">" << endl;
  mod.set_level(level+1);
  // out << mod.indent() << "<path>" << mod.get_path() << "</path>" << endl;
  out << mod.indent() << "<name>" << mod.get_name() << "</name>" << endl;

  for(int i = 0; i < mod.num_children() ; i++) {
    r = (Region* ) mod.get_child(i);
    r->set_level(level+1);
    out << *r;
  }

  mod.set_level(level);
  out << mod.indent() << "</module>" << endl;

  return out;
}
