/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/*******************************************
     Machine.cpp

********************************************/

#include "Machine.h"
#include "CUBException.h"
using namespace std;

const Node* Machine::get_child(int i)     { 
  if (i < 0 || i >= nodev.size()) 
    throw CUBException("vector out of range");
  
  return nodev[i]; 
}

ostream& operator <<(ostream& out, Machine& mach) {
  Node* node;
  int level;
  
  level = mach.get_level();

  out << mach.indent() << "<machine id=\"" << mach.get_id(); 
  out << "\" locId=\"" << mach.get_locid()<< "\">"<<endl;

  mach.set_level(level+1);
  out << mach.indent() << "<name>" << mach.get_name() << "</name>" << endl;

  for(int i = 0; i < mach.num_children() ; i++) {
    node = (Node* ) mach.get_child(i);
    node->set_level(level+1);
    out << *node;
  }

  mach.set_level(level);
  out << mach.indent() << "</machine>" << endl;

  return out;

}
