/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _GRID_H
#define _GRID_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Grid
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;

#include <vector>
  using std::vector;

#include "Location.h"
#include "Machine.h"


class Grid : public Location
{
 public:

  Grid(int loc_id, int grid_id, string name) : 
    Location(loc_id), id(grid_id), name(name) {}
  
  string get_name()                   { return name; }
  int get_id()                        { return id; }
 
  const Machine* get_child(int i); 
  int num_children()            { return machinev.size(); }

  int num_mach()                      { return num_children(); }
  void add_mach(Machine* mach)        { machinev.push_back(mach); }
  
 private:

  int id;
  string name;
  vector<Machine*> machinev;

};

std::ostream& operator <<(std::ostream& out, Grid& grid);

#endif

