/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***************************************
					
       SpectrumPane class
     
     
***************************************/


#ifndef _SPECTRUM_PANE_H
#define _SPECTRUM_PANE_H

#include "wx/wx.h"
#include "wx/laywin.h"
#include "wx/sashwin.h"

class SpectrumPane : public wxSashLayoutWindow {

 public:
  
  SpectrumPane                   (wxWindow* parent, int id=-1);  
  void OnPaint                   (wxPaintEvent& event);
  static wxColour hsi2rgb        (double H, double S=1.0, double I=1.0);
  static wxColour severity2color (double val, double min=0, double max=100);

  DECLARE_EVENT_TABLE()   

  
 private:
  
  void paint_spectrum(wxDC& dc);
  static double logconv(double x);

  // static const double PI = 3.1415926;
  // static const double TWOPI = 6.2831852;
  wxPen pen;
  wxBrush brush;
  wxFont font;    

};

#define  PI     3.1415926
#define  TWOPI  6.2831852

#endif
