/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***************************************
					
       SourceCodeDlg class
     
     
***************************************/


#ifndef _SOURCECODE_DLG_H
#define _SOURCECODE_DLG_H

#include <string>
#include "wx/wx.h"

class SourceCodeDlg : public wxDialog {
 public:
  SourceCodeDlg(wxWindow* parent);
  ~SourceCodeDlg();

  // update labels
  void set_module (std::string name);
  void set_line   (int line);
 
  // display source code
  void show_module(std::string fname);
  // highlight an area of code
  void highlight  (int begin_line, int end_line);
  // focus the highlighted line
  void show_line  (int line);
  void clear();

  // obsolete
  void add_line   (std::string line, bool marked = false);

 private:
  wxBoxSizer* sizer;
  wxFlexGridSizer* gridsizer; // for the first two rows
  wxTextCtrl* text_area;
  wxStaticText* name_label; // display module name
  wxStaticText* line_label; // display line number

  std::string old_modname;
  long old_begn_pos, old_end_pos;
  bool new_mod; // is it now a new module?
};


#endif
