/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***************************************
					
     PresenterFrame class
          
***************************************/


#ifndef _PRESENTER_FRAME_H
#define _PRESENTER_FRAME_H

#include "wx/wx.h"
#include "wx/mdi.h"
#include "wx/toolbar.h"
#include "wx/laywin.h"
#include "wx/sizer.h"
#include "wx/listctrl.h"
#include "wx/notebook.h"

#include "Tree.h"
#include "SpectrumPane.h"
#include "MetricTree.h"
#include "CnodeTree.h"
#include "LocationTree.h"

#include "Cube.h"

enum {
  // File Menu
  ID_Open_File = 1,
  ID_Close_File,
  // View Menu
  ID_Calltree_View,
  ID_Function_View,
  ID_Absolute_View, // absolute severity view
  ID_Percent_View,   // absolute percentage view
  ID_Relative_View, // relative percentage view
  // Others
  ID_Exit,
  ID_About
};

#define PRECISION 1

#define ID_Metric_Panel 1002
#define ID_Cnode_Panel    1003
#define ID_Location_Panel 1004

class SourceCodeDlg;

class PresenterFrame: public wxMDIParentFrame {

 public:
  
  PresenterFrame (wxWindow *parent, const wxWindowID id, const wxString& title
		  , const wxPoint& pos, const wxSize& size, const long style);
  ~PresenterFrame();

  SpectrumPane* get_spectrum_pane() { return spectrum_pane; }
  void build_met_tree();
  void build_cnode_tree();
  void build_loc_tree();
  
  void build_func_tree();//then cnode_tree could be either a callpath or a func tree.
  SourceCodeDlg* get_source_dlg()        { return dlg; }
  void set_source_dlg(SourceCodeDlg* d)  { dlg = d; }

  bool is_calltree()                   { return show_callpath; }
  /* 0=absolute, 1=percentage, 2=relative percentage */
  int  view_type()                     { return view_option; }

  /* Menu Event Handlers */
  void OnOpenFile      (wxCommandEvent& event);
  void OnCloseFile     (wxCommandEvent& event);
  void OnExit          (wxCommandEvent& event);
  void OnAbout         (wxCommandEvent& event);
  void OnFunctionView  (wxCommandEvent& event);
  void OnCalltreeView  (wxCommandEvent& event);
  void OnAbsoluteView  (wxCommandEvent& event);
  void OnRelativeView  (wxCommandEvent& event);
  void OnPercentageView(wxCommandEvent& event);

  /* GUI Event Handlers */
  void OnSize     (wxSizeEvent& event);
  void OnSashDrag (wxSashEvent& event);
  void OnPaint    (wxPaintEvent& event);

  void set_statusbar (); // to display n x m
  void refresh_label_mn();    // refresh mxn label on status bar.

  Cube*         get_cube()          { return cube; }
  void          set_cube(Cube* cb2) { cube = cb2; }
  LocationTree* get_loc_tree()      { return loc_tree; }
  MetricTree*   get_met_tree()      { return met_tree; }
  CnodeTree*    get_cnode_tree()    { return cnode_tree; }


  DECLARE_EVENT_TABLE()

 private:

  // private  methods
  wxPanel*                  create_3Dlabel (wxWindow* parent, wxString label);
  wxSashLayoutWindow* create_metric_pane (int default_width, int ID);
  wxSashLayoutWindow* create_callnode_pane (int default_width, int ID);
  wxSashLayoutWindow* create_location_pane (int default_width, int ID);
 
  SourceCodeDlg* dlg;
  wxBitmap* logo; // ICL logo .xpm

 /* data memebers */
  wxMenu* view_menu;
  SpectrumPane       *spectrum_pane;
  wxSashLayoutWindow *met_panel, *cnode_panel, *loc_panel;
  wxStaticText*       cnodelabel; // the title in the middle pane
  MetricTree*         met_tree;
  CnodeTree*          cnode_tree;
  LocationTree*       loc_tree;
  wxStatusBar*        status_bar;

  Cube* cube;
  bool show_callpath; // whether the callpath tree is shown or not.
  int view_option;    // one of {absolute, percentage, relative percentage}

  wxStaticText* label_mn; // mxn label on the left status bar
  static const int PADDING = 0;

};

string get_base(const string name);
string get_path(const string name);

#endif
