/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/***************************************
					
     PresenterApp class
     
     
***************************************/


#ifndef _PRESENTER_APP_H
#define _PRESENTER_APP_H

#include "wx/wx.h"
#include "wx/dcmemory.h"
#include "wx/imaglist.h"
#include <string>

class PresenterFrame;

class PresenterApp: public wxApp {

 public:
  
  PresenterApp() {}
  ~PresenterApp();
  PresenterFrame* get_frame()  { return main_frame; }
  wxImageList* get_image_list();
  std::string get_cur_file()  { return cur_file; }
  
  void set_proc_num(int n) { m_process = n; }
  int  get_proc_num()      { return m_process; }
  void set_thrd_num(int m) { m_thread  = m; }
  int  get_thrd_num()      { return m_thread; }

  wxColour bg_color; // default background color
  wxColour shadow_color, light_color;

 private:
  
  virtual bool OnInit();
  void create_image_list();
  void parse_command();

  /* date members: */
  PresenterFrame* main_frame;  

  int m_process; // how many processes
  int m_thread;  // max number of threads
  std::string cur_file;
  
  /* the pre-created colored squares in trees*/
  wxImageList* images;
  // static const int square_size = 14;
  static const int square_size = 12;

};


#endif
