/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***************************************
					
       MetricTree class
     
     
***************************************/


#ifndef _CUBE_METRIC_TREE_H
#define _CUBE_METRIC_TREE_H

#include <string>
  using std::string;
#include "wx/wx.h"
#include "wx/treectrl.h"
#include "Tree.h"

class Cube;

class MetricTree : public Tree {
 public:
  MetricTree    (wxWindow* parent); 
  ~MetricTree()   {}
  void refresh    ();

  DECLARE_EVENT_TABLE()
  
  //void OnId      (wxCommandEvent& event);
  void OnDescr   (wxCommandEvent& event);

 private:
  void OnExpanded    (wxTreeEvent& event);
  void OnCollapsed   (wxTreeEvent& event);
  void OnRightClick  (wxTreeEvent& event);
  void OnSelChanged  (wxTreeEvent& event);

  void traverse   (wxTreeItemId root, Cube* cube, bool calltree);

};

enum MetricPopMenu
  { 
    Met_POP_ID_Des
  };

#endif
