/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/


/***************************************
					
       LocationTree class
     
     
***************************************/


#ifndef _CUBE_LOCATION_TREE_H
#define _CUBE_LOCATION_TREE_H

#include <string>
  using std::string;
#include "wx/wx.h"
#include "wx/treectrl.h"
#include "Tree.h"

class Cube;

class LocationTree : public Tree {
 public:
  LocationTree (wxWindow* parent); 
  ~LocationTree() {}

  void refresh(int met_id, int met_mode, int cnode_id, int cnode_mode);
  void refresh4mod(int met_id, int met_mode, int mod_id, int mod_mode);
  void refresh4sub(int met_id, int met_mode, int reg_id);

  // DECLARE_EVENT_TABLE()
  
 private:
  void OnExpanded    (wxTreeEvent& event);
  void OnCollapsed   (wxTreeEvent& event);
  void OnRightClick  (wxTreeEvent& event);
  void OnSelChanged  (wxTreeEvent& event);

  void traverse(wxTreeItemId root, Cube* cube);

  
  int target_met_id;
  int target_met_mode;
  int target_cnode_id;
  int target_cnode_mode;
  bool target_is_mod;
  bool target_is_sub;
};

enum LocationPopMenu
  { Loc_POP_ID_Item1,
    Loc_POP_ID_Item2
  };

#endif
