/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/*******************************
				
    LocationTree.cpp	
					
********************************/

#include <iostream>
#include <strstream>

#include "Tree.h"
#include "LocationTree.h"
#include "MetricTree.h"
#include "CnodeTree.h"
#include "PresenterApp.h"
#include "PresenterFrame.h"
#include "Location.h"

using namespace std;


LocationTree::LocationTree(wxWindow* parent) : Tree(parent) {
  target_met_id    = 0;
  target_met_mode  = CUBE_INCL;
  target_cnode_id   = 0;
  target_cnode_mode = CUBE_INCL;

  target_is_mod = false;
  target_is_sub = false;
  popup_menu->Append(Loc_POP_ID_Item1, _T("No Menu Item"));

}

void LocationTree::OnExpanded(wxTreeEvent& event) {
  // printf("location tree: %d", event.GetItem()); printf(" expanded\n");
  int id = event.GetItem();
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  int loc_id;

  // get current location's id.
  loc_id = GetItemData(id)->get_id();
  int mode[3];
  mode[CUBE_MET] = target_met_mode;
  mode[CUBE_PROG] = target_cnode_mode;
  mode[CUBE_LOC] = CUBE_EXCL;
  double sev=frame->get_cube()->
    get_vsev(mode, target_met_id, target_cnode_id, loc_id,
	     frame->is_calltree(), target_is_mod, target_is_sub);
  mode[CUBE_LOC] = -1;
  double refsev=frame->get_cube()->
    get_vsev(mode, target_met_id,   target_cnode_id,   -1,
	     frame->is_calltree(),target_is_mod, target_is_sub);
  string label = frame->get_cube()->
    gen_loc_label(target_met_id, loc_id, sev,
		  frame->view_type(), refsev);
  SetItemText(id, label, frame->get_cube()->index(sev,frame->view_type(),refsev));
  
}

void LocationTree::OnCollapsed(wxTreeEvent& event) {
  // printf("location tree: %d", event.GetItem()); printf(" collapsed\n");
  int id = (int) event.GetItem();
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  int loc_id;

  // get current location's id.
  loc_id = GetItemData((int)id)->get_id();
  int mode[3];
  mode[CUBE_MET] = target_met_mode;
  mode[CUBE_PROG] = target_cnode_mode;
  mode[CUBE_LOC] = CUBE_INCL;
  double sev = frame->get_cube()->
    get_vsev(mode, target_met_id, target_cnode_id, loc_id,
	     frame->is_calltree(), target_is_mod, target_is_sub);
  mode[CUBE_LOC] = -1;
  double refsev=frame->get_cube()->
    get_vsev(mode, target_met_id,   target_cnode_id, -1,
	     frame->is_calltree(), target_is_mod, target_is_sub);
  string label = frame->get_cube()->gen_loc_label(target_met_id, loc_id, sev,
						 frame->view_type(), refsev);
  SetItemText(id, label, 
	      frame->get_cube()->index(sev,frame->view_type(),refsev));
}

void LocationTree::OnSelChanged  (wxTreeEvent& event) {
  SelectItem(GetVRootItem());
} 

void LocationTree::refresh(int met_id, int met_mode, 
			   int cnode_id, int cnode_mode) {
  cout << "location tree is updated:" << met_id << " " << met_mode 
       << " " << cnode_id << " " << cnode_mode << endl;
  target_met_id    = met_id;
  target_met_mode  = met_mode;
  target_cnode_id   = cnode_id;
  target_cnode_mode = cnode_mode;
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  Cube* cube = frame->get_cube();

  target_is_mod = false;
  target_is_sub = false;

  traverse(wxTreeCtrl::GetRootItem(), cube);
}

void LocationTree::refresh4mod(int met_id, int met_mode, int mod_id, int mod_mode) {
  target_is_mod  = true;
  target_is_sub = false;
  cout << "location tree(mod) is updated:" << met_id << " " << met_mode 
       << " " << mod_id << " " << mod_mode << endl;
  target_met_id    = met_id;
  target_met_mode  = met_mode;
  target_cnode_id   = mod_id;
  target_cnode_mode = mod_mode;
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  Cube* cube = frame->get_cube();
  
  traverse(wxTreeCtrl::GetRootItem(), cube);
}

void LocationTree::refresh4sub(int met_id, int met_mode, int reg_id) {
  target_is_sub = true;
  target_is_mod = false;
  cout << "location tree(sub) is updated:" << met_id << " " << met_mode 
       << " " << reg_id << " " << CUBE_EXCL << endl;
  target_met_id    = met_id;
  target_met_mode  = met_mode;
  target_cnode_id   = reg_id;
  // target_cnode_mode = CUBE_EXCL; // not useful
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  Cube* cube = frame->get_cube();
  
  traverse(wxTreeCtrl::GetRootItem(), cube);
}

void LocationTree::traverse(wxTreeItemId root, Cube* cube) {
  long cookie;
  double sev, refsev;
  ostrstream out;
  PresenterFrame* frame = ((PresenterApp*)wxTheApp)->get_frame();
  bool is_calltree = frame->is_calltree();
  // update the root's label.
  int loc_id = GetItemData(root)->get_id();
  int loc_mode;
  out.precision(PRECISION);
  out.setf(ios::fixed);
  if (loc_id >= 0) {
    loc_mode = IsExpanded(root) ? CUBE_EXCL : CUBE_INCL;
    int mode[3];
    mode[CUBE_MET] = target_met_mode;
    mode[CUBE_PROG] = target_cnode_mode;
    mode[CUBE_LOC] = -1;
    refsev = cube->get_vsev(mode, target_met_id, target_cnode_id, -1,
			   is_calltree, target_is_mod, target_is_sub);
    mode[CUBE_LOC] = loc_mode;
    sev = cube->get_vsev(mode, target_met_id, target_cnode_id, loc_id,
			is_calltree, target_is_mod,  target_is_sub);
    string label = cube->
      gen_loc_label(target_met_id, loc_id, sev,
		    frame->view_type(), refsev);
    SetItemText(root, label, cube->index(sev, frame->view_type(),refsev));
  }

  if (GetChildrenCount(root) == 0) {
    return;
  }
  wxTreeItemId child = GetFirstChild(root, cookie); 
  traverse(child, cube);
  while (child = GetNextChild(root, cookie)) {
    traverse(child, cube);
  }
  return;
}


void LocationTree::OnRightClick(wxTreeEvent& event) {
  PopupMenu(popup_menu, event.GetPoint());
}
