/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _CNODE_H
#define _CNODE_H   

/*
 *----------------------------------------------------------------------------
 *
 * class Cnode
 *
 *----------------------------------------------------------------------------
 */

#include <string>
  using std::string;
#include <iostream>
#include <vector>
  using std::vector;

#include "Vertex.h"

class Callsite;

class Cnode: public Vertex {
  
 public:
  
  Cnode(int id, Callsite* csite, Cnode* parent): 
    Vertex(), id(id), csite(csite), parent(parent) { }

  void add_child(Cnode* child)      { childv.push_back(child); }

  int get_id()                      { return id; }

  int num_children()          { return childv.size(); }
  const Cnode* get_child(int i);
  
  const Cnode* get_parent()         { return parent; }

  Callsite* get_csite()             { return csite; }

 private:

  int id; /* call-tree node id */
  Callsite* csite;  
  
  /* tree structure */
  vector<Cnode*> childv;
  Cnode* parent;
  
};

std::ostream& operator <<(std::ostream& out, Cnode& cnode);

#endif
