/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/*******************************************
     Cnode.cpp

********************************************/

#include "Cnode.h"
#include "CUBException.h"
#include "Callsite.h"
using namespace std;
const Cnode* Cnode::get_child(int i) {
  if (i < 0 || i >= childv.size()) 
    throw CUBException("vector out of range");
  return childv[i]; 
}

ostream& operator <<(ostream& out, Cnode& cnode) {
  Cnode* cn;
  int level;
  
  level = cnode.get_level();

  out << cnode.indent() << "<cnode id=\"" << cnode.get_id(); 
  out << "\" csiteId=\"" << cnode.get_csite()->get_id()<< "\">\n";

  for(int i = 0; i < cnode.num_children() ; i++) {
    cn = (Cnode* ) cnode.get_child(i);
    cn->set_level(level+1);
    out << *cn;
  }

  cnode.set_level(level);
  out << cnode.indent() << "</cnode>\n";

  return out;
}
