/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _CALLSITE_H
#define _CALLSITE_H

/*
 *----------------------------------------------------------------------------
 *
 * class Callsite
 *
 *----------------------------------------------------------------------------
 */

#include <string>
#include <iostream>
#include <vector>

#include "Vertex.h"

class Module;
class Region;
class Cnode;

class Callsite: public Vertex {

 public:

  Callsite(int id, int line, Region* reg, Region* callee):
    Vertex(), id(id), line(line), caller(reg), callee(callee) {}

  int get_id()                 { return id; }
  int get_line()               { return line; }
  
  const Module* get_mod();

  const Region* get_caller()   { return caller; }
  const Region* get_callee()   { return callee; }
  
  int num_children()     { return 0; }
  const Vertex* get_child(int) { return NULL; }
  
  // a callsite may point to several cnodes.
  void add_cnode(Cnode* cnode) { cnodev.push_back(cnode); }
  const Cnode*  get_cnode(int);
  int     num_cnodes()   { return cnodev.size(); }
  
  void set_callee(Region* r)   { callee = r; }
  void set_caller(Region* r)   { caller = r; }

 private:
  
  int id; /* csite id */
  int line; /* line number in its module */
  
  Region* caller; /* caller region, it's computed by program */
  Region* callee;

  /* support for function profile tree @ Sep. 2, 2003*/
  std::vector<Cnode*> cnodev;
 };

std::ostream& operator <<(std::ostream& out, Callsite& csite);

#endif
