/****************************************************************************
**  Copyright (C) 2004                                                     **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _CUBEXCEPTION_H
#define _CUBEXCEPTION_H   

/*
 *----------------------------------------------------------------------------
 *
 * class CUBException
 *
 *----------------------------------------------------------------------------
 */

#include <string>
#include <iostream>
#include <exception>


class CUBException: public std::exception {

 private:
    std::string error_msg;
    
 public:
    
    CUBException  (std::string msg): std::exception(), error_msg(msg) {}
    ~CUBException () throw()     {}

    std::string   get_msg()       { return error_msg; }

};

std::ostream& operator <<(std::ostream& out, CUBException& exception);

#endif
