/*   LAPACK C Wrapper Header File
 *   included by all the lapack wrapper functions lapack_*.c
 *   Written by Remi Delmas
 */

#ifndef LAPACK_H
#define LAPACK_H

#include "lapack_enum.h" 

void lapack_cbdsqr(const enum lapack_uplo_type uplo, const int n, const int ncvt, const int nru, const int ncc, float * d, float * e, void * vt, const int ldvt, void * u, const int ldu, void * c, const int ldc, float * rwork, int * info );
void lapack_cgbbrd(const enum lapack_form_matrices_type vect, const int m, const int n, const int ncc, const int kl, const int ku, void * ab, const int ldab, float * d, float * e, void * q, const int ldq, void * pt, const int ldpt, void * c, const int ldc, void * work, float * rwork, int * info );
void lapack_cgbcon(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const void * ab, const int ldab, const int * ipiv, const float anorm, float * rcond, void * work, float * rwork, int * info );
void lapack_cgbequ(const int m, const int n, const int kl, const int ku, const void * ab, const int ldab, float * r, float * c, float * rowcnd, float * colcnd, float * amax, int * info );
void lapack_cgbrfs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const void * ab, const int ldab, const void * afb, const int ldafb, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cgbsv(const int n, const int kl, const int ku, const int nrhs, void * ab, const int ldab, int * ipiv, void * b, const int ldb, int * info );
void lapack_cgbsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, void * ab, const int ldab, void * afb, const int ldafb, int * ipiv, char * equed, float * r, float * c, void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cgbtf2(const int m, const int n, const int kl, const int ku, void * ab, const int ldab, int * ipiv, int * info );
void lapack_cgbtrf(const int m, const int n, const int kl, const int ku, void * ab, const int ldab, int * ipiv, int * info );
void lapack_cgbtrs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const void * ab, const int ldab, const int * ipiv, void * b, const int ldb, int * info );
void lapack_cgebak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const float * scale, const int m, void * v, const int ldv, int * info );
void lapack_cgebal(const enum lapack_balance_type job, const int n, void * a, const int lda, int * ilo, int * ihi, float * scale, int * info );
void lapack_cgebd2(const int m, const int n, void * a, const int lda, float * d, float * e, void * tauq, void * taup, void * work, int * info );
void lapack_cgebrd(const int m, const int n, void * a, const int lda, float * d, float * e, void * tauq, void * taup, void * work, const int lwork, int * info );
void lapack_cgecon(const enum lapack_norm_type norm, const int n, const void * a, const int lda, const float anorm, float * rcond, void * work, float * rwork, int * info );
void lapack_cgeequ(const int m, const int n, const void * a, const int lda, float * r, float * c, float * rowcnd, float * colcnd, float * amax, int * info );
void lapack_cgees(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (void*), const int n, void * a, const int lda, int * sdim, void * w, void * vs, const int ldvs, void * work, const int lwork, float * rwork, long int * bwork, int * info );
void lapack_cgeesx(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (void*), const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, int * sdim, void * w, void * vs, const int ldvs, float * rconde, float * rcondv, void * work, const int lwork, float * rwork, long int * bwork, int * info );
void lapack_cgeev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, void * a, const int lda, void * w, void * vl, const int ldvl, void * vr, const int ldvr, void * work, const int lwork, float * rwork, int * info );
void lapack_cgeevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, void * w, void * vl, const int ldvl, void * vr, const int ldvr, int * ilo, int * ihi, float * scale, float * abnrm, float * rconde, float * rcondv, void * work, const int lwork, float * rwork, int * info );
void lapack_cgegs(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vsl, const int ldvsl, void * vsr, const int ldvsr, void * work, const int lwork, float * rwork, int * info );
void lapack_cgegv(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vl, const int ldvl, void * vr, const int ldvr, void * work, const int lwork, float * rwork, int * info );
void lapack_cgehd2(const int n, const int ilo, const int ihi, void * a, const int lda, void * tau, void * work, int * info );
void lapack_cgehrd(const int n, const int ilo, const int ihi, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_cgelq2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_cgelqf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_cgels(const enum lapack_trans_type trans, const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, void * work, const int lwork, int * info );
void lapack_cgelsd(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, float * s, const float rcond, int * rank, void * work, const int lwork, float * rwork, int * iwork, int * info );
void lapack_cgelss(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, float * s, const float rcond, int * rank, void * work, const int lwork, float * rwork, int * info );
void lapack_cgelsx(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, int * jpvt, const float rcond, int * rank, void * work, float * rwork, int * info );
void lapack_cgelsy(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, int * jpvt, const float rcond, int * rank, void * work, const int lwork, float * rwork, int * info );
void lapack_cgeql2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_cgeqlf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_cgeqp3(const int m, const int n, void * a, const int lda, int * jpvt, void * tau, void * work, const int lwork, float * rwork, int * info );
void lapack_cgeqpf(const int m, const int n, void * a, const int lda, int * jpvt, void * tau, void * work, float * rwork, int * info );
void lapack_cgeqr2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_cgeqrf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_cgerfs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cgerq2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_cgerqf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_cgesc2(const int n, const void * a, const int lda, void * rhs, const int * ipiv, const int * jpiv, float * scale );
void lapack_cgesdd(const enum lapack_compute_svd_type jobz, const int m, const int n, void * a, const int lda, float * s, void * u, const int ldu, void * vt, const int ldvt, void * work, const int lwork, float * rwork, int * iwork, int * info );
void lapack_cgesv(const int n, const int nrhs, void * a, const int lda, int * ipiv, void * b, const int ldb, int * info );
void lapack_cgesvd(const enum lapack_compute_svd_type jobu, const enum lapack_compute_svd_type jobvt, const int m, const int n, void * a, const int lda, float * s, void * u, const int ldu, void * vt, const int ldvt, void * work, const int lwork, float * rwork, int * info );
void lapack_cgesvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, void * a, const int lda, void * af, const int ldaf, int * ipiv, char * equed, float * r, float * c, void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cgetc2(const int n, void * a, const int lda, int * ipiv, int * jpiv, int * info );
void lapack_cgetf2(const int m, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_cgetrf(const int m, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_cgetri(const int n, void * a, const int lda, const int * ipiv, void * work, const int lwork, int * info );
void lapack_cgetrs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * a, const int lda, const int * ipiv, void * b, const int ldb, int * info );
void lapack_cggbak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const float * lscale, const float * rscale, const int m, void * v, const int ldv, int * info );
void lapack_cggbal(const enum lapack_balance_type job, const int n, void * a, const int lda, void * b, const int ldb, int * ilo, int * ihi, float * lscale, float * rscale, float * work, int * info );
void lapack_cgges(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (void*,void*), const int n, void * a, const int lda, void * b, const int ldb, int * sdim, void * alpha, void * beta, void * vsl, const int ldvsl, void * vsr, const int ldvsr, void * work, const int lwork, float * rwork, long int * bwork, int * info );
void lapack_cggesx(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (void*,void*), const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, void * b, const int ldb, int * sdim, void * alpha, void * beta, void * vsl, const int ldvsl, void * vsr, const int ldvsr, float * rconde, float * rcondv, void * work, const int lwork, float * rwork, int * iwork, const int liwork, long int * bwork, int * info );
void lapack_cggev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vl, const int ldvl, void * vr, const int ldvr, void * work, const int lwork, float * rwork, int * info );
void lapack_cggevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vl, const int ldvl, void * vr, const int ldvr, int * ilo, int * ihi, float * lscale, float * rscale, float * abnrm, float * bbnrm, float * rconde, float * rcondv, void * work, const int lwork, float * rwork, int * iwork, long int * bwork, int * info );
void lapack_cggglm(const int n, const int m, const int p, void * a, const int lda, void * b, const int ldb, void * d, void * x, void * y, void * work, const int lwork, int * info );
void lapack_cgghrd(const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, void * a, const int lda, void * b, const int ldb, void * q, const int ldq, void * z, const int ldz, int * info );
void lapack_cgglse(const int m, const int n, const int p, void * a, const int lda, void * b, const int ldb, void * c, void * d, void * x, void * work, const int lwork, int * info );
void lapack_cggqrf(const int n, const int m, const int p, void * a, const int lda, void * taua, void * b, const int ldb, void * taub, void * work, const int lwork, int * info );
void lapack_cggrqf(const int m, const int p, const int n, void * a, const int lda, void * taua, void * b, const int ldb, void * taub, void * work, const int lwork, int * info );
void lapack_cggsvd(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int n, const int p, int * k, int * l, void * a, const int lda, void * b, const int ldb, float * alpha, float * beta, void * u, const int ldu, void * v, const int ldv, void * q, const int ldq, void * work, float * rwork, int * iwork, int * info );
void lapack_cggsvp(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int p, const int n, void * a, const int lda, void * b, const int ldb, const float tola, const float tolb, int * k, int * l, void * u, const int ldu, void * v, const int ldv, void * q, const int ldq, int * iwork, float * rwork, void * tau, void * work, int * info );
void lapack_cgtcon(const enum lapack_norm_type norm, const int n, const void * dl, const void * d, const void * du, const void * du2, const int * ipiv, const float anorm, float * rcond, void * work, int * info );
void lapack_cgtrfs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * dl, const void * d, const void * du, const void * dlf, const void * df, const void * duf, const void * du2, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cgtsv(const int n, const int nrhs, void * dl, void * d, void * du, void * b, const int ldb, int * info );
void lapack_cgtsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, const void * dl, const void * d, const void * du, void * dlf, void * df, void * duf, void * du2, int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cgttrf(const int n, void * dl, void * d, void * du, void * du2, int * ipiv, int * info );
void lapack_cgttrs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * dl, const void * d, const void * du, const void * du2, const int * ipiv, void * b, const int ldb, int * info );
void lapack_cgtts2(const int itrans, const int n, const int nrhs, const void * dl, const void * d, const void * du, const void * du2, const int * ipiv, void * b, const int ldb );
void lapack_chbev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, float * w, void * z, const int ldz, void * work, float * rwork, int * info );
void lapack_chbevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, float * w, void * z, const int ldz, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_chbevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, void * q, const int ldq, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, void * work, float * rwork, int * iwork, int * ifail, int * info );
void lapack_chbgst(const enum lapack_form_x_type vect, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, const void * bb, const int ldbb, void * x, const int ldx, void * work, float * rwork, int * info );
void lapack_chbgv(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, void * bb, const int ldbb, float * w, void * z, const int ldz, void * work, float * rwork, int * info );
void lapack_chbgvd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, void * bb, const int ldbb, float * w, void * z, const int ldz, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_chbgvx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, void * bb, const int ldbb, void * q, const int ldq, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, void * work, float * rwork, int * iwork, int * ifail, int * info );
void lapack_chbtrd(const enum lapack_form_q_type vect, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, float * d, float * e, void * q, const int ldq, void * work, int * info );
void lapack_checon(const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, const int * ipiv, const float anorm, float * rcond, void * work, int * info );
void lapack_cheev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, float * w, void * work, const int lwork, float * rwork, int * info );
void lapack_cheevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, float * w, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_cheevr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, int * isuppz, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_cheevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, void * work, const int lwork, float * rwork, int * iwork, int * ifail, int * info );
void lapack_chegs2(const int itype, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const void * b, const int ldb, int * info );
void lapack_chegst(const int itype, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const void * b, const int ldb, int * info );
void lapack_chegv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, void * b, const int ldb, float * w, void * work, const int lwork, float * rwork, int * info );
void lapack_chegvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, void * b, const int ldb, float * w, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_chegvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, void * b, const int ldb, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, void * work, const int lwork, float * rwork, int * iwork, int * ifail, int * info );
void lapack_cherfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_chesv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, int * ipiv, void * b, const int ldb, void * work, const int lwork, int * info );
void lapack_chesvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, void * af, const int ldaf, int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, const int lwork, float * rwork, int * info );
void lapack_chetd2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, float * d, float * e, void * tau, int * info );
void lapack_chetf2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_chetrd(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, float * d, float * e, void * tau, void * work, const int lwork, int * info );
void lapack_chetrf(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, void * work, const int lwork, int * info );
void lapack_chetri(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const int * ipiv, void * work, int * info );
void lapack_chetrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const int * ipiv, void * b, const int ldb, int * info );
void lapack_chgeqz(const enum lapack_hseqr_type job, const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, void * h, const int ldh, void * t, const int ldt, void * alpha, void * beta, void * q, const int ldq, void * z, const int ldz, void * work, const int lwork, float * rwork, int * info );
void lapack_chpcon(const enum lapack_uplo_type uplo, const int n, const void * ap, const int * ipiv, const float anorm, float * rcond, void * work, int * info );
void lapack_chpev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, float * w, void * z, const int ldz, void * work, float * rwork, int * info );
void lapack_chpevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, float * w, void * z, const int ldz, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_chpevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * ap, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, void * work, float * rwork, int * iwork, int * ifail, int * info );
void lapack_chpgst(const int itype, const enum lapack_uplo_type uplo, const int n, void * ap, const void * bp, int * info );
void lapack_chpgv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, void * bp, float * w, void * z, const int ldz, void * work, float * rwork, int * info );
void lapack_chpgvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, void * bp, float * w, void * z, const int ldz, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_chpgvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * ap, void * bp, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, void * work, float * rwork, int * iwork, int * ifail, int * info );
void lapack_chprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const void * afp, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_chpsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, int * ipiv, void * b, const int ldb, int * info );
void lapack_chpsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, void * afp, int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_chptrd(const enum lapack_uplo_type uplo, const int n, void * ap, float * d, float * e, void * tau, int * info );
void lapack_chptrf(const enum lapack_uplo_type uplo, const int n, void * ap, int * ipiv, int * info );
void lapack_chptri(const enum lapack_uplo_type uplo, const int n, void * ap, const int * ipiv, void * work, int * info );
void lapack_chptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const int * ipiv, void * b, const int ldb, int * info );
void lapack_chsein(const enum lapack_side_type side, const enum lapack_eig_source_type eigsrc, const enum lapack_init_vector_type initv, const long int * select, const int n, const void * h, const int ldh, void * w, void * vl, const int ldvl, void * vr, const int ldvr, const int mm, int * m, void * work, float * rwork, int * ifaill, int * ifailr, int * info );
void lapack_chseqr(const enum lapack_hseqr_type job, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, void * h, const int ldh, void * w, void * z, const int ldz, void * work, const int lwork, int * info );
void lapack_clabrd(const int m, const int n, const int nb, void * a, const int lda, float * d, float * e, void * tauq, void * taup, void * x, const int ldx, void * y, const int ldy );
void lapack_clacgv(const int n, void * x, const int incx );
void lapack_clacn2(const int n, void * v, void * x, float * est, int * kase, int * isave );
void lapack_clacon(const int n, void * v, void * x, float * est, int * kase );
void lapack_clacp2(const enum lapack_uplo_type uplo, const int m, const int n, const float * a, const int lda, void * b, const int ldb );
void lapack_clacpy(const enum lapack_uplo_type uplo, const int m, const int n, const void * a, const int lda, void * b, const int ldb );
void lapack_clacrm(const int m, const int n, const void * a, const int lda, const float * b, const int ldb, const void * c, const int ldc, float * rwork );
void lapack_clacrt(const int n, void * cx, const int incx, void * cy, const int incy, const void * c, const void * s );
void* lapack_cladiv(const void * x, const void * y );
void lapack_claed0(const int qsiz, const int n, float * d, float * e, void * q, const int ldq, int * iwork, float * rwork, void * qstore, const int ldqs, int * info );
void lapack_claed7(const int n, const int cutpnt, const int qsiz, const int tlvls, const int curlvl, const int curpbm, float * d, void * q, const int ldq, const float rho, int * indxq, int * iwork, float * rwork, void * work, float * qstore, int * qptr, const int * prmptr, const int * perm, const int * givptr, const int * givcol, const float * givnum, int * info );
void lapack_claed8(int * k, const int n, const int qsiz, void * q, const int ldq, float * d, float * rho, const int cutpnt, const float * z, float * dlamda, void * q2, const int ldq2, float * w, int * indxp, int * indx, const int * indxq, int * perm, int * givptr, int * givcol, float * givnum, int * info );
void lapack_claein(const long int rightv, const long int noinit, const int n, const void * h, const int ldh, const void * w, void * v, void * b, const int ldb, float * rwork, const float eps3, const float smlnum, int * info );
void lapack_claesy(const void * a, const void * b, const void * c, void * rt1, void * rt2, void * evscal, void * cs1, void * sn1 );
void lapack_claev2(const void * a, const void * b, const void * c, float * rt1, float * rt2, float * cs1, void * sn1 );
void lapack_clags2(const long int upper, const float a1, const void * a2, const float a3, const float b1, const void * b2, const float b3, float * csu, void * snu, float * csv, void * snv, float * csq, void * snq );
void lapack_clagtm(const enum lapack_trans_type trans, const int n, const int nrhs, const float alpha, const void * dl, const void * d, const void * du, const void * x, const int ldx, const float beta, void * b, const int ldb );
void lapack_clahef(const enum lapack_uplo_type uplo, const int n, const int nb, int * kb, void * a, const int lda, int * ipiv, void * w, const int ldw, int * info );
void lapack_clahqr(const long int wantt, const long int wantz, const int n, const int ilo, const int ihi, void * h, const int ldh, void * w, const int iloz, const int ihiz, void * z, const int ldz, int * info );
void lapack_clahrd(const int n, const int k, const int nb, void * a, const int lda, void * tau, void * t, const int ldt, void * y, const int ldy );
void lapack_claic1(const int job, const int j, const void * x, const float sest, const void * w, const void * gamma, float * sestpr, void * s, void * c );
void lapack_clals0(const int icompq, const int nl, const int nr, const int sqre, const int nrhs, void * b, const int ldb, void * bx, const int ldbx, const int * perm, const int givptr, const int * givcol, const int ldgcol, const float * givnum, const int ldgnum, const float * poles, const float * difl, const float * difr, const float * z, const int k, const float c, const float s, float * rwork, int * info );
void lapack_clalsa(const int icompq, const int smlsiz, const int n, const int nrhs, void * b, const int ldb, void * bx, const int ldbx, const float * u, const int ldu, const float * vt, const int * k, const float * difl, const float * difr, const float * z, const float * poles, const int * givptr, const int * givcol, const int ldgcol, const int * perm, const float * givnum, const float * c, const float * s, float * rwork, int * iwork, int * info );
void lapack_clalsd(const enum lapack_uplo_type uplo, const int smlsiz, const int n, const int nrhs, float * d, float * e, void * b, const int ldb, const float rcond, int * rank, void * work, float * rwork, int * iwork, int * info );
float lapack_clangb(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const void * ab, const int ldab, float * work );
float lapack_clange(const enum lapack_norm_type norm, const int m, const int n, const void * a, const int lda, float * work );
float lapack_clangt(const enum lapack_norm_type norm, const int n, const void * dl, const void * d, const void * du );
float lapack_clanhb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const int k, const void * ab, const int ldab, float * work );
float lapack_clanhe(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, float * work );
float lapack_clanhp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * ap, float * work );
float lapack_clanhs(const enum lapack_norm_type norm, const int n, const void * a, const int lda, float * work );
float lapack_clanht(const enum lapack_norm_type norm, const int n, const float * d, const void * e );
float lapack_clansb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const int k, const void * ab, const int ldab, float * work );
float lapack_clansp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * ap, float * work );
float lapack_clansy(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, float * work );
float lapack_clantb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int k, const void * ab, const int ldab, float * work );
float lapack_clantp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const void * ap, float * work );
float lapack_clantr(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int m, const int n, const void * a, const int lda, float * work );
void lapack_clapll(const int n, void * x, const int incx, void * y, const int incy, float * ssmin );
void lapack_clapmt(const long int forwrd, const int m, const int n, void * x, const int ldx, int * k );
void lapack_claqgb(const int m, const int n, const int kl, const int ku, void * ab, const int ldab, const float * r, const float * c, const float rowcnd, const float colcnd, const float amax, char * equed );
void lapack_claqge(const int m, const int n, void * a, const int lda, const float * r, const float * c, const float rowcnd, const float colcnd, const float amax, char * equed );
void lapack_claqhb(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, float * s, const float scond, const float amax, char * equed );
void lapack_claqhe(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const float * s, const float scond, const float amax, char * equed );
void lapack_claqhp(const enum lapack_uplo_type uplo, const int n, void * ap, const float * s, const float scond, const float amax, char * equed );
void lapack_claqp2(const int m, const int n, const int offset, void * a, const int lda, int * jpvt, void * tau, float * vn1, float * vn2, void * work );
void lapack_claqps(const int m, const int n, const int offset, const int nb, int * kb, void * a, const int lda, int * jpvt, void * tau, float * vn1, float * vn2, void * auxv, void * f, const int ldf );
void lapack_claqsb(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, const float * s, const float scond, const float amax, char * equed );
void lapack_claqsp(const enum lapack_uplo_type uplo, const int n, void * ap, const float * s, const float scond, const float amax, char * equed );
void lapack_claqsy(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const float * s, const float scond, const float amax, char * equed );
void lapack_clar1v(const int n, const int b1, const int bn, const float sigma, const float * l, const float * d, const float * ld, const float * lld, const float * gersch, void * z, float * ztz, float * mingma, int * r, int * isuppz, float * work );
void lapack_clar2v(const int n, void * x, void * y, void * z, const int incx, const float * c, const void * s, const int incc );
void lapack_clarcm(const int m, const int n, const float * a, const int lda, const float * b, const int ldb, const void * c, const int ldc, float * rwork );
void lapack_clarf(const enum lapack_side_type side, const int m, const int n, const void * v, const int incv, const void * tau, void * c, const int ldc, void * work );
void lapack_clarfb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const void * v, const int ldv, const void * t, const int ldt, void * c, const int ldc, void * work, const int ldwork );
void lapack_clarfg(const int n, void * alpha, void * x, const int incx, void * tau );
void lapack_clarft(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, void * v, const int ldv, const void * tau, void * t, const int ldt );
void lapack_clarfx(const enum lapack_side_type side, const int m, const int n, const void * v, const void * tau, void * c, const int ldc, void * work );
void lapack_clargv(const int n, void * x, const int incx, void * y, const int incy, float * c, const int incc );
void lapack_clarnv(const int idist, int * iseed, const int n, void * x );
void lapack_clarrv(const int n, float * d, float * l, const int * isplit, const int m, const float * w, const int * iblock, const float * gersch, const float tol, void * z, const int ldz, int * isuppz, float * work, int * iwork, int * info );
void lapack_clartg(const void * f, const void * g, float * cs, void * sn, void * r );
void lapack_clartv(const int n, void * x, const int incx, void * y, const int incy, const float * c, const void * s, const int incc );
void lapack_clarz(const enum lapack_side_type side, const int m, const int n, const int l, const void * v, const int incv, const void * tau, void * c, const int ldc, void * work );
void lapack_clarzb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const int l, const void * v, const int ldv, const void * t, const int ldt, void * c, const int ldc, void * work, const int ldwork );
void lapack_clarzt(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, void * v, const int ldv, const void * tau, void * t, const int ldt );
void lapack_clascl(const enum lapack_symmetry_type type, const int kl, const int ku, const float cfrom, const float cto, const int m, const int n, void * a, const int lda, int * info );
void lapack_claset(const enum lapack_uplo_type uplo, const int m, const int n, const void * alpha, const void * beta, void * a, const int lda );
void lapack_clasr(const enum lapack_side_type side, const enum lapack_pivot_type pivot, const enum lapack_direction_type direct, const int m, const int n, const float * c, const float * s, void * a, const int lda );
void lapack_classq(const int n, const void * x, const int incx, float * scale, float * sumsq );
void lapack_claswp(const int n, void * a, const int lda, const int k1, const int k2, const int * ipiv, const int incx );
void lapack_clasyf(const enum lapack_uplo_type uplo, const int n, const int nb, int * kb, void * a, const int lda, int * ipiv, void * w, const int ldw, int * info );
void lapack_clatbs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const int kd, const void * ab, const int ldab, void * x, float * scale, float * cnorm, int * info );
void lapack_clatdf(const int ijob, const int n, const float * z, const int ldz, float * rhs, float * rdsum, float * rdscal, const int * ipiv, const int * jpiv );
void lapack_clatps(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const void * ap, void * x, float * scale, float * cnorm, int * info );
void lapack_clatrd(const enum lapack_uplo_type uplo, const int n, const int nb, void * a, const int lda, float * e, void * tau, void * w, const int ldw );
void lapack_clatrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const void * a, const int lda, void * x, float * scale, float * cnorm, int * info );
void lapack_clatrz(const int m, const int n, const int l, void * a, const int lda, void * tau, void * work );
void lapack_clatzm(const enum lapack_side_type side, const int m, const int n, const void * v, const int incv, const void * tau, void * c1, void * c2, const int ldc, void * work );
void lapack_clauu2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_clauum(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_cpbcon(const enum lapack_uplo_type uplo, const int n, const int kd, const void * ab, const int ldab, const float anorm, float * rcond, void * work, float * rwork, int * info );
void lapack_cpbequ(const enum lapack_uplo_type uplo, const int n, const int kd, const void * ab, const int ldab, float * s, float * scond, float * amax, int * info );
void lapack_cpbrfs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const void * ab, const int ldab, const void * afb, const int ldafb, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cpbstf(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, int * info );
void lapack_cpbsv(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, void * ab, const int ldab, void * b, const int ldb, int * info );
void lapack_cpbsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, void * ab, const int ldab, void * afb, const int ldafb, char * equed, float * s, void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cpbtf2(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, int * info );
void lapack_cpbtrf(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, int * info );
void lapack_cpbtrs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const void * ab, const int ldab, void * b, const int ldb, int * info );
void lapack_cpocon(const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, const float anorm, float * rcond, void * work, float * rwork, int * info );
void lapack_cpoequ(const int n, const void * a, const int lda, float * s, float * scond, float * amax, int * info );
void lapack_cporfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cposv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, int * info );
void lapack_cposvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, void * af, const int ldaf, char * equed, float * s, void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cpotf2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_cpotrf(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_cpotri(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_cpotrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, void * b, const int ldb, int * info );
void lapack_cppcon(const enum lapack_uplo_type uplo, const int n, const void * ap, const float anorm, float * rcond, void * work, float * rwork, int * info );
void lapack_cppequ(const enum lapack_uplo_type uplo, const int n, const void * ap, float * s, float * scond, float * amax, int * info );
void lapack_cpprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const void * afp, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cppsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, void * b, const int ldb, int * info );
void lapack_cppsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, void * afp, char * equed, float * s, void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cpptrf(const enum lapack_uplo_type uplo, const int n, void * ap, int * info );
void lapack_cpptri(const enum lapack_uplo_type uplo, const int n, void * ap, int * info );
void lapack_cpptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, void * b, const int ldb, int * info );
void lapack_cptcon(const int n, const float * d, const void * e, const float anorm, float * rcond, float * rwork, int * info );
void lapack_cpteqr(const enum lapack_compute_type compz, const int n, float * d, float * e, void * z, const int ldz, float * work, int * info );
void lapack_cptrfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * d, const void * e, const float * df, const void * ef, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cptsv(const int n, const int nrhs, float * d, void * e, void * b, const int ldb, int * info );
void lapack_cptsvx(const enum lapack_fact_type fact, const int n, const int nrhs, const float * d, const void * e, float * df, void * ef, const void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cpttrf(const int n, float * d, void * e, int * info );
void lapack_cpttrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * d, const void * e, float * b, const int ldb, int * info );
void lapack_cptts2(const int iuplo, const int n, const int nrhs, const float * d, const void * e, float * b, const int ldb );
void lapack_crot(const int n, void * cx, const int incx, void * cy, const int incy, const float c, const void * s );
void lapack_cspcon(const enum lapack_uplo_type uplo, const int n, const void * ap, const int * ipiv, const float anorm, float * rcond, void * work, int * info );
void lapack_cspmv(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * ap, const void * x, const int incx, const void * beta, void * y, const int incy );
void lapack_cspr(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * x, const int incx, void * ap );
void lapack_csprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const void * afp, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_cspsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, int * ipiv, void * b, const int ldb, int * info );
void lapack_cspsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, void * afp, int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_csptrf(const enum lapack_uplo_type uplo, const int n, void * ap, int * ipiv, int * info );
void lapack_csptri(const enum lapack_uplo_type uplo, const int n, void * ap, const int * ipiv, void * work, int * info );
void lapack_csptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const int * ipiv, void * b, const int ldb, int * info );
void lapack_csrot(const int n, const void * cx, const int incx, const void * cy, const int incy, const float c, const float s );
void lapack_csrscl(const int n, const float sa, void * sx, const int incx );
void lapack_cstedc(const enum lapack_compute_type compz, const int n, float * d, float * e, void * z, const int ldz, void * work, const int lwork, float * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_cstegr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, float * d, float * e, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, void * z, const int ldz, int * isuppz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_cstein(const int n, const float * d, const float * e, const int m, const float * w, const int * iblock, const int * isplit, void * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_csteqr(const enum lapack_compute_type compz, const int n, float * d, float * e, void * z, const int ldz, float * work, int * info );
void lapack_csycon(const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, const int * ipiv, const float anorm, float * rcond, void * work, int * info );
void lapack_csymv(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * a, const int lda, const void * x, const int incx, const void * beta, void * y, const int incy );
void lapack_csyr(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * x, const int incx, void * a, const int lda );
void lapack_csyrfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_csysv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, int * ipiv, void * b, const int ldb, void * work, const int lwork, int * info );
void lapack_csysvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, void * af, const int ldaf, int * ipiv, const void * b, const int ldb, void * x, const int ldx, float * rcond, float * ferr, float * berr, void * work, const int lwork, float * rwork, int * info );
void lapack_csytf2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_csytrf(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, void * work, const int lwork, int * info );
void lapack_csytri(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const int * ipiv, void * work, int * info );
void lapack_csytrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const int * ipiv, void * b, const int ldb, int * info );
void lapack_ctbcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int kd, const void * ab, const int ldab, float * rcond, void * work, float * rwork, int * info );
void lapack_ctbrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const void * ab, const int ldab, const void * b, const int ldb, const void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_ctbtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const void * ab, const int ldab, void * b, const int ldb, int * info );
void lapack_ctgevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, const long int * select, const int n, const void * s, const int lds, const void * p, const int ldp, void * vl, const int ldvl, void * vr, const int ldvr, const int mm, int * m, void * work, float * rwork, int * info );
void lapack_ctgex2(const long int wantq, const long int wantz, const int n, void * a, const int lda, void * b, const int ldb, void * q, const int ldq, void * z, const int ldz, const int j1, int * info );
void lapack_ctgexc(const long int wantq, const long int wantz, const int n, void * a, const int lda, void * b, const int ldb, void * q, const int ldq, void * z, const int ldz, const int ifst, int * ilst, int * info );
void lapack_ctgsen(const int ijob, const long int wantq, const long int wantz, const long int * select, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * q, const int ldq, void * z, const int ldz, int * m, float * pl, float * pr, float * dif, void * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ctgsja(const enum lapack_compute_tgsj_type jobu, const enum lapack_compute_tgsj_type jobv, const enum lapack_compute_tgsj_type jobq, const int m, const int p, const int n, const int k, const int l, void * a, const int lda, void * b, const int ldb, const float tola, const float tolb, float * alpha, float * beta, void * u, const int ldu, void * v, const int ldv, void * q, const int ldq, void * work, int * ncycle, int * info );
void lapack_ctgsna(const enum lapack_balance_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const void * a, const int lda, const void * b, const int ldb, const void * vl, const int ldvl, const void * vr, const int ldvr, float * s, float * dif, const int mm, int * m, void * work, const int lwork, int * iwork, int * info );
void lapack_ctgsy2(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const void * a, const int lda, const void * b, const int ldb, void * c, const int ldc, const void * d, const int ldd, const void * e, const int lde, void * f, const int ldf, float * scale, float * rdsum, float * rdscal, int * info );
void lapack_ctgsyl(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const void * a, const int lda, const void * b, const int ldb, void * c, const int ldc, const void * d, const int ldd, const void * e, const int lde, void * f, const int ldf, float * dif, float * scale, void * work, const int lwork, int * iwork, int * info );
void lapack_ctpcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const void * ap, float * rcond, void * work, float * rwork, int * info );
void lapack_ctprfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * ap, const void * b, const int ldb, const void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_ctptri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, void * ap, int * info );
void lapack_ctptrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * ap, void * b, const int ldb, int * info );
void lapack_ctrcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const void * a, const int lda, float * rcond, void * work, float * rwork, int * info );
void lapack_ctrevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, const long int * select, const int n, void * t, const int ldt, void * vl, const int ldvl, void * vr, const int ldvr, const int mm, int * m, void * work, float * rwork, int * info );
void lapack_ctrexc(const enum lapack_compute_type compq, const int n, void * t, const int ldt, void * q, const int ldq, const int ifst, const int ilst, int * info );
void lapack_ctrrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * a, const int lda, const void * b, const int ldb, const void * x, const int ldx, float * ferr, float * berr, void * work, float * rwork, int * info );
void lapack_ctrsen(const enum lapack_compute_cond_type job, const enum lapack_compute_type compq, const long int * select, const int n, void * t, const int ldt, void * q, const int ldq, void * w, int * m, float * s, float * sep, void * work, const int lwork, int * info );
void lapack_ctrsna(const enum lapack_compute_cond_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const void * t, const int ldt, const void * vl, const int ldvl, const void * vr, const int ldvr, float * s, float * sep, const int mm, int * m, void * work, const int ldwork, float * rwork, int * info );
void lapack_ctrsyl(const enum lapack_trans_type trana, const enum lapack_trans_type tranb, const int isgn, const int m, const int n, const void * a, const int lda, const void * b, const int ldb, void * c, const int ldc, float * scale, int * info );
void lapack_ctrti2(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, void * a, const int lda, int * info );
void lapack_ctrtri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, void * a, const int lda, int * info );
void lapack_ctrtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * a, const int lda, void * b, const int ldb, int * info );
void lapack_ctzrqf(const int m, const int n, void * a, const int lda, void * tau, int * info );
void lapack_ctzrzf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_cung2l(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_cung2r(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_cungbr(const enum lapack_form_matrices_type vect, const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cunghr(const int n, const int ilo, const int ihi, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cungl2(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_cunglq(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cungql(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cungqr(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cungr2(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_cungrq(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cungtr(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_cunm2l(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_cunm2r(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_cunmbr(const enum lapack_form_matrices_type vect, const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunmhr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int ilo, const int ihi, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunml2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_cunmlq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunmql(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunmqr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunmr2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_cunmr3(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_cunmrq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunmrz(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cunmtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_cupgtr(const enum lapack_uplo_type uplo, const int n, const void * ap, const void * tau, void * q, const int ldq, void * work, int * info );
void lapack_cupmtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const void * ap, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_dbdsdc(const enum lapack_uplo_type uplo, const enum lapack_compute_type compq, const int n, double * d, double * e, double * u, const int ldu, double * vt, const int ldvt, double * q, int * iq, double * work, int * iwork, int * info );
void lapack_dbdsqr(const enum lapack_uplo_type uplo, const int n, const int ncvt, const int nru, const int ncc, double * d, double * e, double * vt, const int ldvt, double * u, const int ldu, double * c, const int ldc, double * work, int * info );
void lapack_ddisna(const enum lapack_balance_type job, const int m, const int n, const double * d, double * sep, int * info );
void lapack_dgbbrd(const enum lapack_form_matrices_type vect, const int m, const int n, const int ncc, const int kl, const int ku, double * ab, const int ldab, double * d, double * e, double * q, const int ldq, double * pt, const int ldpt, double * c, const int ldc, double * work, int * info );
void lapack_dgbcon(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const double * ab, const int ldab, const int * ipiv, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dgbequ(const int m, const int n, const int kl, const int ku, const double * ab, const int ldab, double * r, double * c, double * rowcnd, double * colcnd, double * amax, int * info );
void lapack_dgbrfs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const double * ab, const int ldab, const double * afb, const int ldafb, const int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dgbsv(const int n, const int kl, const int ku, const int nrhs, double * ab, const int ldab, int * ipiv, double * b, const int ldb, int * info );
void lapack_dgbsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, double * ab, const int ldab, double * afb, const int ldafb, int * ipiv, char * equed, double * r, double * c, double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dgbtf2(const int m, const int n, const int kl, const int ku, double * ab, const int ldab, int * ipiv, int * info );
void lapack_dgbtrf(const int m, const int n, const int kl, const int ku, double * ab, const int ldab, int * ipiv, int * info );
void lapack_dgbtrs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const double * ab, const int ldab, const int * ipiv, double * b, const int ldb, int * info );
void lapack_dgebak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const double * scale, const int m, double * v, const int ldv, int * info );
void lapack_dgebal(const enum lapack_balance_type job, const int n, double * a, const int lda, int * ilo, int * ihi, double * scale, int * info );
void lapack_dgebd2(const int m, const int n, double * a, const int lda, double * d, double * e, double * tauq, double * taup, double * work, int * info );
void lapack_dgebrd(const int m, const int n, double * a, const int lda, double * d, double * e, double * tauq, double * taup, double * work, const int lwork, int * info );
void lapack_dgecon(const enum lapack_norm_type norm, const int n, const double * a, const int lda, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dgeequ(const int m, const int n, const double * a, const int lda, double * r, double * c, double * rowcnd, double * colcnd, double * amax, int * info );
void lapack_dgees(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (double*,double*), const int n, double * a, const int lda, int * sdim, double * wr, double * wi, double * vs, const int ldvs, double * work, const int lwork, long int * bwork, int * info );
void lapack_dgeesx(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (double*,double*), const enum lapack_reciprocal_condition_type sense, const int n, double * a, const int lda, int * sdim, double * wr, double * wi, double * vs, const int ldvs, double * rconde, double * rcondv, double * work, const int lwork, int * iwork, const int liwork, long int * bwork, int * info );
void lapack_dgeev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, double * a, const int lda, double * wr, double * wi, double * vl, const int ldvl, double * vr, const int ldvr, double * work, const int lwork, int * info );
void lapack_dgeevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, double * a, const int lda, double * wr, double * wi, double * vl, const int ldvl, double * vr, const int ldvr, int * ilo, int * ihi, double * scale, double * abnrm, double * rconde, double * rcondv, double * work, const int lwork, int * iwork, int * info );
void lapack_dgegs(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const int n, double * a, const int lda, double * b, const int ldb, double * alphar, double * alphai, double * beta, double * vsl, const int ldvsl, double * vsr, const int ldvsr, double * work, const int lwork, int * info );
void lapack_dgegv(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, double * a, const int lda, double * b, const int ldb, double * alphar, double * alphai, double * beta, double * vl, const int ldvl, double * vr, const int ldvr, double * work, const int lwork, int * info );
void lapack_dgehd2(const int n, const int ilo, const int ihi, double * a, const int lda, double * tau, double * work, int * info );
void lapack_dgehrd(const int n, const int ilo, const int ihi, double * a, const int lda, double * tau, double * work, const int lwork, int * info );
void lapack_dgelq2(const int m, const int n, double * a, const int lda, double * tau, double * work, int * info );
void lapack_dgelqf(const int m, const int n, double * a, const int lda, double * tau, double * work, const int lwork, int * info );
void lapack_dgels(const enum lapack_trans_type trans, const int m, const int n, const int nrhs, double * a, const int lda, double * b, const int ldb, double * work, const int lwork, int * info );
void lapack_dgelsd(const int m, const int n, const int nrhs, const double * a, const int lda, double * b, const int ldb, double * s, const double rcond, int * rank, double * work, const int lwork, int * iwork, int * info );
void lapack_dgelss(const int m, const int n, const int nrhs, double * a, const int lda, double * b, const int ldb, double * s, const double rcond, int * rank, double * work, const int lwork, int * info );
void lapack_dgelsx(const int m, const int n, const int nrhs, double * a, const int lda, double * b, const int ldb, int * jpvt, const double rcond, int * rank, double * work, int * info );
void lapack_dgelsy(const int m, const int n, const int nrhs, double * a, const int lda, double * b, const int ldb, int * jpvt, const double rcond, int * rank, double * work, const int lwork, int * info );
void lapack_dgeql2(const int m, const int n, double * a, const int lda, double * tau, double * work, int * info );
void lapack_dgeqlf(const int m, const int n, double * a, const int lda, double * tau, double * work, const int lwork, int * info );
void lapack_dgeqp3(const int m, const int n, double * a, const int lda, int * jpvt, double * tau, double * work, const int lwork, int * info );
void lapack_dgeqpf(const int m, const int n, double * a, const int lda, int * jpvt, double * tau, double * work, int * info );
void lapack_dgeqr2(const int m, const int n, double * a, const int lda, double * tau, double * work, int * info );
void lapack_dgeqrf(const int m, const int n, double * a, const int lda, double * tau, double * work, const int lwork, int * info );
void lapack_dgerfs(const enum lapack_trans_type trans, const int n, const int nrhs, const double * a, const int lda, const double * af, const int ldaf, const int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dgerq2(const int m, const int n, double * a, const int lda, double * tau, double * work, int * info );
void lapack_dgerqf(const int m, const int n, double * a, const int lda, double * tau, double * work, const int lwork, int * info );
void lapack_dgesc2(const int n, const double * a, const int lda, double * rhs, const int * ipiv, const int * jpiv, double * scale );
void lapack_dgesdd(const enum lapack_compute_svd_type jobz, const int m, const int n, double * a, const int lda, double * s, double * u, const int ldu, double * vt, const int ldvt, double * work, const int lwork, int * iwork, int * info );
void lapack_dgesv(const int n, const int nrhs, double * a, const int lda, int * ipiv, double * b, const int ldb, int * info );
void lapack_dgesvd(const enum lapack_compute_svd_type jobu, const enum lapack_compute_svd_type jobvt, const int m, const int n, double * a, const int lda, double * s, double * u, const int ldu, double * vt, const int ldvt, double * work, const int lwork, int * info );
void lapack_dgesvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, double * a, const int lda, double * af, const int ldaf, int * ipiv, char * equed, double * r, double * c, double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dgetc2(const int n, double * a, const int lda, int * ipiv, int * jpiv, int * info );
void lapack_dgetf2(const int m, const int n, double * a, const int lda, int * ipiv, int * info );
void lapack_dgetrf(const int m, const int n, double * a, const int lda, int * ipiv, int * info );
void lapack_dgetri(const int n, double * a, const int lda, const int * ipiv, double * work, const int lwork, int * info );
void lapack_dgetrs(const enum lapack_trans_type trans, const int n, const int nrhs, const double * a, const int lda, const int * ipiv, double * b, const int ldb, int * info );
void lapack_dggbak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const double * lscale, const double * rscale, const int m, double * v, const int ldv, int * info );
void lapack_dggbal(const enum lapack_balance_type job, const int n, double * a, const int lda, double * b, const int ldb, int * ilo, int * ihi, double * lscale, double * rscale, float * work, int * info );
void lapack_dgges(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (double*,double*,double*), const int n, double * a, const int lda, double * b, const int ldb, int * sdim, double * alphar, double * alphai, double * beta, double * vsl, const int ldvsl, double * vsr, const int ldvsr, double * work, const int lwork, long int * bwork, int * info );
void lapack_dggesx(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (double*,double*,double*), const enum lapack_reciprocal_condition_type sense, const int n, double * a, const int lda, double * b, const int ldb, int * sdim, double * alphar, double * alphai, double * beta, double * vsl, const int ldvsl, double * vsr, const int ldvsr, double * rconde, double * rcondv, double * work, const int lwork, int * iwork, const int liwork, long int * bwork, int * info );
void lapack_dggev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, double * a, const int lda, double * b, const int ldb, double * alphar, double * alphai, double * beta, double * vl, const int ldvl, double * vr, const int ldvr, double * work, const int lwork, int * info );
void lapack_dggevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, double * a, const int lda, double * b, const int ldb, double * alphar, double * alphai, double * beta, double * vl, const int ldvl, double * vr, const int ldvr, int * ilo, int * ihi, double * lscale, double * rscale, double * abnrm, double * bbnrm, double * rconde, double * rcondv, double * work, const int lwork, int * iwork, long int * bwork, int * info );
void lapack_dggglm(const int n, const int m, const int p, double * a, const int lda, double * b, const int ldb, double * d, double * x, double * y, double * work, const int lwork, int * info );
void lapack_dgghrd(const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, double * a, const int lda, double * b, const int ldb, double * q, const int ldq, double * z, const int ldz, int * info );
void lapack_dgglse(const int m, const int n, const int p, double * a, const int lda, double * b, const int ldb, double * c, double * d, double * x, double * work, const int lwork, int * info );
void lapack_dggqrf(const int n, const int m, const int p, double * a, const int lda, double * taua, double * b, const int ldb, double * taub, double * work, const int lwork, int * info );
void lapack_dggrqf(const int m, const int p, const int n, double * a, const int lda, double * taua, double * b, const int ldb, double * taub, double * work, const int lwork, int * info );
void lapack_dggsvd(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int n, const int p, int * k, int * l, double * a, const int lda, double * b, const int ldb, double * alpha, double * beta, double * u, const int ldu, double * v, const int ldv, double * q, const int ldq, double * work, int * iwork, int * info );
void lapack_dggsvp(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int p, const int n, double * a, const int lda, double * b, const int ldb, const double tola, const double tolb, int * k, int * l, double * u, const int ldu, double * v, const int ldv, double * q, const int ldq, int * iwork, double * tau, double * work, int * info );
void lapack_dgtcon(const enum lapack_norm_type norm, const int n, const double * dl, const double * d, const double * du, const double * du2, const int * ipiv, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dgtrfs(const enum lapack_trans_type trans, const int n, const int nrhs, const double * dl, const double * d, const double * du, const double * dlf, const double * df, const double * duf, const double * du2, const int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dgtsv(const int n, const int nrhs, double * dl, double * d, double * du, double * b, const int ldb, int * info );
void lapack_dgtsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, const double * dl, const double * d, const double * du, double * dlf, double * df, double * duf, double * du2, int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dgttrf(const int n, double * dl, double * d, double * du, double * du2, int * ipiv, int * info );
void lapack_dgttrs(const enum lapack_trans_type trans, const int n, const int nrhs, const double * dl, const double * d, const double * du, const double * du2, const int * ipiv, double * b, const int ldb, int * info );
void lapack_dgtts2(const int itrans, const int n, const int nrhs, const double * dl, const double * d, const double * du, const double * du2, const int * ipiv, double * b, const int ldb );
void lapack_dhgeqz(const enum lapack_hseqr_type job, const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, double * h, const int ldh, double * t, const int ldt, double * alphar, double * alphai, double * beta, double * q, const int ldq, double * z, const int ldz, double * work, const int lwork, int * info );
void lapack_dhsein(const enum lapack_side_type side, const enum lapack_eig_source_type eigsrc, const enum lapack_init_vector_type initv, long int * select, const int n, const double * h, const int ldh, double * wr, const double * wi, double * vl, const int ldvl, double * vr, const int ldvr, const int mm, int * m, double * work, int * ifaill, int * ifailr, int * info );
void lapack_dhseqr(const enum lapack_hseqr_type job, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, double * h, const int ldh, double * wr, double * wi, double * z, const int ldz, double * work, const int lwork, int * info );
void lapack_dlabad(double * small, double * large );
void lapack_dlabrd(const int m, const int n, const int nb, double * a, const int lda, double * d, double * e, double * tauq, double * taup, double * x, const int ldx, double * y, const int ldy );
void lapack_dlacn2(const int n, double * v, double * x, int * isgn, double * est, int * kase, int * isave );
void lapack_dlacon(const int n, double * v, double * x, int * isgn, double * est, int * kase );
void lapack_dlacpy(const enum lapack_uplo_type uplo, const int m, const int n, const double * a, const int lda, double * b, const int ldb );
void lapack_dladiv(const double a, const double b, const double c, const double d, double * p, double * q );
void lapack_dlae2(const double a, const double b, const double c, double * rt1, double * rt2 );
void lapack_dlaebz(const int ijob, const int nitmax, const int n, const int mmax, const int minp, const int nbmin, const double abstol, const double reltol, const double pivmin, const double * d, const double * e, const double * e2, int * nval, double * ab, double * c, int * mout, int * nab, double * work, int * iwork, int * info );
void lapack_dlaed0(const int icompq, const int qsiz, const int n, double * d, const double * e, double * q, const int ldq, double * qstore, const int ldqs, double * work, int * iwork, int * info );
void lapack_dlaed1(const int n, double * d, double * q, const int ldq, int * indxq, const double rho, const int cutpnt, double * work, int * iwork, int * info );
void lapack_dlaed2(int * k, const int n, const int n1, double * d, double * q, const int ldq, int * indxq, double * rho, const double * z, double * dlamda, double * w, double * q2, int * indx, int * indxc, int * indxp, int * coltyp, int * info );
void lapack_dlaed3(const int k, const int n, const int n1, double * d, double * q, const int ldq, const double rho, double * dlamda, const double * q2, const int * indx, const int * ctot, double * w, double * s, const int lds, int * info );
void lapack_dlaed4(const int n, const int i, const double * d, const double * z, double * delta, const double rho, double * dlam, int * info );
void lapack_dlaed5(const int i, const double * d, const double * z, double * delta, const double rho, double * dlam );
void lapack_dlaed6(const int kniter, const long int orgati, const double rho, const double * d, const double * z, const double finit, double * tau, int * info );
void lapack_dlaed7(const int icompq, const int n, const int qsiz, const int tlvls, const int curlvl, const int curpbm, double * d, double * q, const int ldq, int * indxq, const double rho, const int cutpnt, double * qstore, int * qptr, const int * prmptr, const int * perm, const int * givptr, const int * givcol, const double * givnum, double * work, int * iwork, int * info );
void lapack_dlaed8(const int icompq, int * k, const int n, const int qsiz, double * d, double * q, const int ldq, const int * indxq, double * rho, const int cutpnt, const double * z, double * dlamda, double * q2, const int ldq2, double * w, int * perm, int * givptr, int * givcol, double * givnum, int * indxp, int * indx, int * info );
void lapack_dlaed9(const int k, const int kstart, const int kstop, const int n, double * d, double * q, const int ldq, const double rho, const double * dlamda, const double * w, double * s, const int lds, int * info );
void lapack_dlaeda(const int n, const int tlvls, const int curlvl, const int curpbm, const int * prmptr, const int * perm, const int * givptr, const int * givcol, const double * givnum, const double * q, const int * qptr, double * z, double * ztemp, int * info );
void lapack_dlaein(const long int rightv, const long int noinit, const int n, const double * h, const int ldh, const double wr, const double wi, double * vr, double * vi, double * b, const int ldb, double * work, const double eps3, const double smlnum, const double bignum, int * info );
void lapack_dlaev2(const double a, const double b, const double c, double * rt1, double * rt2, double * cs1, double * sn1 );
void lapack_dlaexc(const long int wantq, const int n, double * t, const int ldt, double * q, const int ldq, const int j1, const int n1, const int n2, double * work, int * info );
void lapack_dlag2(const double * a, const int lda, const double * b, const int ldb, const double safmin, double * scale1, double * scale2, double * wr1, double * wr2, double * wi );
void lapack_dlags2(const long int upper, const double a1, const double a2, const double a3, const double b1, const double b2, const double b3, double * csu, double * snu, double * csv, double * snv, double * csq, double * snq );
void lapack_dlagtf(const int n, double * a, const double lambda, double * b, double * c, const double tol, double * d, const int * in, int * info );
void lapack_dlagtm(const enum lapack_trans_type trans, const int n, const int nrhs, const double alpha, const double * dl, const double * d, const double * du, const double * x, const int ldx, const double beta, double * b, const int ldb );
void lapack_dlagts(const int job, const int n, const double * a, const double * b, const double * c, const double * d, const int * in, double * y, double * tol, int * info );
void lapack_dlagv2(double * a, const int lda, double * b, const int ldb, double * alphar, double * alphai, double * beta, double * csl, double * snl, double * csr, double * snr );
void lapack_dlahqr(const long int wantt, const long int wantz, const int n, const int ilo, const int ihi, double * h, const int ldh, double * wr, double * wi, const int iloz, const int ihiz, double * z, const int ldz, int * info );
void lapack_dlahrd(const int n, const int k, const int nb, double * a, const int lda, double * tau, double * t, const int ldt, double * y, const int ldy );
void lapack_dlaic1(const int job, const int j, const double * x, const double sest, const double * w, const double gamma, double * sestpr, double * s, double * c );
void lapack_dlaln2(const long int ltrans, const int na, const int nw, const double smin, const double ca, const double * a, const int lda, const double d1, const double d2, const double * b, const int ldb, const double wr, const double wi, double * x, const int ldx, double * scale, double * xnorm, int * info );
void lapack_dlals0(const int icompq, const int nl, const int nr, const int sqre, const int nrhs, double * b, const int ldb, double * bx, const int ldbx, const int * perm, const int givptr, const int * givcol, const int ldgcol, const double * givnum, const int ldgnum, const double * poles, const double * difl, const double * difr, const double * z, const int k, const double c, const double s, double * work, int * info );
void lapack_dlalsa(const int icompq, const int smlsiz, const int n, const int nrhs, double * b, const int ldb, double * bx, const int ldbx, const double * u, const int ldu, const double * vt, const int * k, const double * difl, const double * difr, const double * z, const double * poles, const int * givptr, const int * givcol, const int ldgcol, const int * perm, const double * givnum, const double * c, const double * s, double * work, int * iwork, int * info );
void lapack_dlalsd(const enum lapack_uplo_type uplo, const int smlsiz, const int n, const int nrhs, double * d, double * e, double * b, const int ldb, const double rcond, int * rank, double * work, int * iwork, int * info );
double lapack_dlamch(const enum lapack_cmach_type cmach );
void lapack_dlamc1(int * beta, int * t, long int * rnd, long int * ieee1 );
void lapack_dlamc2(int * beta, int * t, long int * rnd, double * eps, int * emin, double * rmin, int * emax, double * rmax );
double lapack_dlamc3(const double a, const double b );
void lapack_dlamc4(int * emin, const double start, const int base );
void lapack_dlamc5(const int beta, const int p, const int emin, const long int ieee, int * emax, double * rmax );
void lapack_dlamrg(const int n1, const int n2, const double * a, const int dtrd1, const int dtrd2, int * index );
double lapack_dlangb(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const double * ab, const int ldab, double * work );
double lapack_dlange(const enum lapack_norm_type norm, const int m, const int n, const double * a, const int lda, double * work );
double lapack_dlangt(const enum lapack_norm_type norm, const int n, const double * dl, const double * d, const double * du );
double lapack_dlanhs(const enum lapack_norm_type norm, const int n, const double * a, const int lda, double * work );
double lapack_dlansb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const int k, const double * ab, const int ldab, double * work );
double lapack_dlansp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const double * ap, double * work );
double lapack_dlanst(const enum lapack_norm_type norm, const int n, const double * d, const double * e );
double lapack_dlansy(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const double * a, const int lda, double * work );
double lapack_dlantb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int k, const double * ab, const int ldab, double * work );
double lapack_dlantp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const double * ap, double * work );
double lapack_dlantr(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int m, const int n, const double * a, const int lda, double * work );
void lapack_dlanv2(double * a, double * b, double * c, double * d, double * rt1r, double * rt1i, double * rt2r, double * rt2i, double * cs, double * sn );
void lapack_dlapll(const int n, double * x, const int incx, double * y, const int incy, double * ssmin );
void lapack_dlapmt(const long int forwrd, const int m, const int n, double * x, const int ldx, int * k );
double lapack_dlapy2(const double x, const double y );
double lapack_dlapy3(const double x, const double y, const double z );
void lapack_dlaqgb(const int m, const int n, const int kl, const int ku, double * ab, const int ldab, const double * r, const double * c, const double rowcnd, const double colcnd, const double amax, char * equed );
void lapack_dlaqge(const int m, const int n, double * a, const int lda, const double * r, const double * c, const double rowcnd, const double colcnd, const double amax, char * equed );
void lapack_dlaqp2(const int m, const int n, const int offset, double * a, const int lda, int * jpvt, double * tau, double * vn1, double * vn2, double * work );
void lapack_dlaqps(const int m, const int n, const int offset, const int nb, int * kb, double * a, const int lda, int * jpvt, double * tau, double * vn1, double * vn2, double * auxv, double * f, const int ldf );
void lapack_dlaqsb(const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, const double * s, const double scond, const double amax, char * equed );
void lapack_dlaqsp(const enum lapack_uplo_type uplo, const int n, double * ap, const double * s, const double scond, const double amax, char * equed );
void lapack_dlaqsy(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const double * s, const double scond, const double amax, char * equed );
void lapack_dlaqtr(const long int ltran, const long int lreal, const int n, const double * t, const int ldt, const double * b, const double w, double * scale, double * x, double * work, int * info );
void lapack_dlar1v(const int n, const int b1, const int bn, const double sigma, const double * l, const double * d, const double * ld, const double * lld, const double * gersch, double * z, double * ztz, double * mingma, int * r, int * isuppz, double * work );
void lapack_dlar2v(const int n, double * x, double * y, double * z, const int incx, const double * c, const double * s, const int incc );
void lapack_dlarf(const enum lapack_side_type side, const int m, const int n, const double * v, const int incv, const double tau, double * c, const int ldc, double * work );
void lapack_dlarfb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const double * v, const int ldv, const double * t, const int ldt, double * c, const int ldc, double * work, const int ldwork );
void lapack_dlarfg(const int n, double * alpha, double * x, const int incx, double * tau );
void lapack_dlarft(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, double * v, const int ldv, const double * tau, double * t, const int ldt );
void lapack_dlarfx(const enum lapack_side_type side, const int m, const int n, const double * v, const double tau, double * c, const int ldc, double * work );
void lapack_dlargv(const int n, double * x, const int incx, double * y, const int incy, double * c, const int incc );
void lapack_dlarnv(const int idist, int * iseed, const int n, double * x );
void lapack_dlarrb(const int n, const double * d, const double * l, const double * ld, const double * lld, const int ifirst, const int ilast, const double sigma, const double reltol, double * w, double * wgap, double * werr, const double * work, const int * iwork, int * info );
void lapack_dlarre(const int n, double * d, double * e, const double tol, int * nsplit, int * isplit, int * m, double * w, double * woff, double * gersch, const double * work, int * info );
void lapack_dlarrf(const int n, const double * d, const double * l, const double * ld, const double * lld, const int ifirst, const int ilast, double * w, const double sigma, double * dplus, double * lplus, double * work, int * iwork, int * info );
void lapack_dlarrv(const int n, double * d, double * l, const int * isplit, const int m, const double * w, const int * iblock, const double * gersch, const double tol, double * z, const int ldz, int * isuppz, double * work, int * iwork, int * info );
void lapack_dlartg(const double f, const double g, double * cs, double * sn, double * r );
void lapack_dlartv(const int n, double * x, const int incx, double * y, const int incy, const double * c, const double * s, const int incc );
void lapack_dlaruv(int * iseed, const int n, double * x );
void lapack_dlarz(const enum lapack_side_type side, const int m, const int n, const int l, const double * v, const int incv, const double tau, double * c, const int ldc, double * work );
void lapack_dlarzb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const int l, const double * v, const int ldv, const double * t, const int ldt, double * c, const int ldc, double * work, const int ldwork );
void lapack_dlarzt(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, double * v, const int ldv, const double * tau, double * t, const int ldt );
void lapack_dlas2(const double f, const double g, const double h, double * ssmin, double * ssmax );
void lapack_dlascl(const enum lapack_symmetry_type type, const int kl, const int ku, const double cfrom, const double cto, const int m, const int n, double * a, const int lda, int * info );
void lapack_dlasd0(const int n, const int sqre, double * d, const double * e, double * u, const int ldu, double * vt, const int ldvt, const int smlsiz, int * iwork, double * work, int * info );
void lapack_dlasd1(const int nl, const int nr, const int sqre, double * d, double * alpha, double * beta, double * u, const int ldu, double * vt, const int ldvt, int * idxq, int * iwork, double * work, int * info );
void lapack_dlasd2(const int nl, const int nr, const int sqre, int * k, double * d, double * z, const double alpha, const double beta, double * u, const int ldu, double * vt, const int ldvt, double * dsigma, double * u2, const int ldu2, double * vt2, const int ldvt2, int * idxp, int * idx, int * idxc, int * idxq, int * coltyp, int * info );
void lapack_dlasd3(const int nl, const int nr, const int sqre, const int k, double * d, double * q, const int ldq, const double * dsigma, double * u, const int ldu, double * u2, const int ldu2, double * vt, const int ldvt, double * vt2, const int ldvt2, const int * idxc, const int * ctot, const double * z, int * info );
void lapack_dlasd4(const int n, const int i, const double * d, const double * z, double * delta, const double rho, double * sigma, double * work, int * info );
void lapack_dlasd5(const int i, const double * d, const double * z, double * delta, const double rho, double * dsigma, double * work );
void lapack_dlasd6(const int icompq, const int nl, const int nr, const int sqre, double * d, double * vf, double * vl, double * alpha, double * beta, int * idxq, int * perm, int * givptr, int * givcol, const int ldgcol, double * givnum, const int ldgnum, double * poles, double * difl, double * difr, double * z, int * k, double * c, double * s, double * work, int * iwork, int * info );
void lapack_dlasd7(const int icompq, const int nl, const int nr, const int sqre, int * k, double * d, double * z, double * zw, double * vf, double * vfw, double * vl, double * vlw, const double alpha, const double beta, double * dsigma, int * idx, int * idxp, const int * idxq, int * perm, int * givptr, int * givcol, const int ldgcol, double * givnum, const int ldgnum, double * c, double * s, int * info );
void lapack_dlasd8(const int icompq, const int k, double * d, const double * z, double * vf, double * vl, double * difl, double * difr, const int lddifr, const double * dsigma, double * work, int * info );
void lapack_dlasda(const int icompq, const int smlsiz, const int n, const int sqre, double * d, const double * e, double * u, const int ldu, double * vt, int * k, double * difl, double * difr, double * z, double * poles, int * givptr, int * givcol, const int ldgcol, int * perm, double * givnum, double * c, double * s, double * work, int * iwork, int * info );
void lapack_dlasdq(const enum lapack_uplo_type uplo, const int sqre, const int n, const int ncvt, const int nru, const int ncc, double * d, double * e, double * vt, const int ldvt, double * u, const int ldu, double * c, const int ldc, double * work, int * info );
void lapack_dlasdt(const int n, int * lvl, int * nd, int * inode, int * ndiml, int * ndimr, const int msub );
void lapack_dlaset(const enum lapack_uplo_type uplo, const int m, const int n, const double alpha, const double beta, double * a, const int lda );
void lapack_dlasq1(const int n, double * d, double * e, double * work, int * info );
void lapack_dlasq2(const int n, double * z, int * info );
void lapack_dlasq3(const int i0, const int n0, const double * z, const int pp, double * dmin, double * sigma, double * desig, const double qmax, int * nfail, int * iter, int * ndiv, int * ttype, const long int ieee );
void lapack_dlasq4(const int i0, const int n0, const double * z, const int pp, const int n0in, const double dmin, const double dmin1, const double dmin2, const double dn, const double dn1, const double dn2, double * tau, int * ttype );
void lapack_dlasq5(const int i0, const int n0, const double * z, const int pp, const double tau, double * dmin, double * dmin1, double * dmin2, double * dn, double * dnm1, double * dnm2, const long int ieee );
void lapack_dlasq6(const int i0, const int n0, const double * z, const int pp, double * dmin, double * dmin1, double * dmin2, double * dn, double * dnm1, double * dnm2 );
void lapack_dlasr(const enum lapack_side_type side, const enum lapack_pivot_type pivot, const enum lapack_direction_type direct, const int m, const int n, const double * c, const double * s, double * a, const int lda );
void lapack_dlasrt(const enum lapack_sort_type id, const int n, double * d, int * info );
void lapack_dlassq(const int n, const double * x, const int incx, double * scale, double * sumsq );
void lapack_dlasv2(const double f, const double g, const double h, double * ssmin, double * ssmax, double * snl, double * csl, double * snr, double * csr );
void lapack_dlaswp(const int n, double * a, const int lda, const int k1, const int k2, const int * ipiv, const int incx );
void lapack_dlasy2(const long int ltranl, const long int ltranr, const int isgn, const int n1, const int n2, const double * tl, const int ldtl, const double * tr, const int ldtr, const double * b, const int ldb, double * scale, double * x, const int ldx, double * xnorm, int * info );
void lapack_dlasyf(const enum lapack_uplo_type uplo, const int n, const int nb, int * kb, double * a, const int lda, int * ipiv, double * w, const int ldw, int * info );
void lapack_dlatbs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const int kd, const double * ab, const int ldab, double * x, double * scale, double * cnorm, int * info );
void lapack_dlatdf(const int ijob, const int n, const double * z, const int ldz, double * rhs, double * rdsum, double * rdscal, const int * ipiv, const int * jpiv );
void lapack_dlatps(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const double * ap, double * x, double * scale, double * cnorm, int * info );
void lapack_dlatrd(const enum lapack_uplo_type uplo, const int n, const int nb, double * a, const int lda, double * e, double * tau, double * w, const int ldw );
void lapack_dlatrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const double * a, const int lda, double * x, double * scale, double * cnorm, int * info );
void lapack_dlatrz(const int m, const int n, const int l, double * a, const int lda, double * tau, double * work );
void lapack_dlatzm(const enum lapack_side_type side, const int m, const int n, const double * v, const int incv, const double tau, double * c1, double * c2, const int ldc, double * work );
void lapack_dlauu2(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * info );
void lapack_dlauum(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * info );
void lapack_dlazq3(const int i0, const int n0, const double * z, const int pp, double * dmin, double * sigma, double * desig, const double qmax, int * nfail, int * iter, int * ndiv, const long int ieee, int * ttype, float * dmin1, float * dmin2, float * dn, float * dn1, float * dn2, float * tau );
void lapack_dlazq4(const int i0, const int n0, const double * z, const int pp, const int n0in, const double dmin, const double dmin1, const double dmin2, const double dn, const double dn1, const double dn2, double * tau, int * ttype, double * g );
void lapack_dopgtr(const enum lapack_uplo_type uplo, const int n, const double * ap, const double * tau, double * q, const int ldq, double * work, int * info );
void lapack_dopmtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const double * ap, const double * tau, double * c, const int ldc, double * work, int * info );
void lapack_dorg2l(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, int * info );
void lapack_dorg2r(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, int * info );
void lapack_dorgbr(const enum lapack_form_matrices_type vect, const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorghr(const int n, const int ilo, const int ihi, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorgl2(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, int * info );
void lapack_dorglq(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorgql(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorgqr(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorgr2(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, int * info );
void lapack_dorgrq(const int m, const int n, const int k, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorgtr(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const double * tau, double * work, const int lwork, int * info );
void lapack_dorm2l(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, int * info );
void lapack_dorm2r(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, int * info );
void lapack_dormbr(const enum lapack_form_matrices_type vect, const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dormhr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int ilo, const int ihi, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dorml2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, int * info );
void lapack_dormlq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dormql(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dormqr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dormr2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, int * info );
void lapack_dormr3(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, int * info );
void lapack_dormrq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dormrz(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dormtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const double * a, const int lda, const double * tau, double * c, const int ldc, double * work, const int lwork, int * info );
void lapack_dpbcon(const enum lapack_uplo_type uplo, const int n, const int kd, const double * ab, const int ldab, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dpbequ(const enum lapack_uplo_type uplo, const int n, const int kd, const double * ab, const int ldab, double * s, double * scond, double * amax, int * info );
void lapack_dpbrfs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const double * ab, const int ldab, const double * afb, const int ldafb, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dpbstf(const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, int * info );
void lapack_dpbsv(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, double * ab, const int ldab, double * b, const int ldb, int * info );
void lapack_dpbsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, double * ab, const int ldab, double * afb, const int ldafb, char * equed, double * s, double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dpbtf2(const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, int * info );
void lapack_dpbtrf(const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, int * info );
void lapack_dpbtrs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const double * ab, const int ldab, double * b, const int ldb, int * info );
void lapack_dpocon(const enum lapack_uplo_type uplo, const int n, const double * a, const int lda, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dpoequ(const int n, const double * a, const int lda, double * s, double * scond, double * amax, int * info );
void lapack_dporfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * a, const int lda, const double * af, const int ldaf, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dposv(const enum lapack_uplo_type uplo, const int n, const int nrhs, double * a, const int lda, double * b, const int ldb, int * info );
void lapack_dposvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, double * a, const int lda, double * af, const int ldaf, char * equed, double * s, double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dpotf2(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * info );
void lapack_dpotrf(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * info );
void lapack_dpotri(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * info );
void lapack_dpotrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * a, const int lda, double * b, const int ldb, int * info );
void lapack_dppcon(const enum lapack_uplo_type uplo, const int n, const double * ap, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dppequ(const enum lapack_uplo_type uplo, const int n, const double * ap, double * s, double * scond, double * amax, int * info );
void lapack_dpprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * ap, const double * afp, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dppsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, double * ap, double * b, const int ldb, int * info );
void lapack_dppsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, double * ap, double * afp, char * equed, double * s, double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dpptrf(const enum lapack_uplo_type uplo, const int n, double * ap, int * info );
void lapack_dpptri(const enum lapack_uplo_type uplo, const int n, double * ap, int * info );
void lapack_dpptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * ap, double * b, const int ldb, int * info );
void lapack_dptcon(const int n, const double * d, const double * e, const double anorm, double * rcond, double * work, int * info );
void lapack_dpteqr(const enum lapack_compute_type compz, const int n, double * d, double * e, double * z, const int ldz, double * work, int * info );
void lapack_dptrfs(const int n, const int nrhs, const double * d, const double * e, const double * df, const double * ef, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * info );
void lapack_dptsv(const int n, const int nrhs, double * d, double * e, double * b, const int ldb, int * info );
void lapack_dptsvx(const enum lapack_fact_type fact, const int n, const int nrhs, const double * d, const double * e, double * df, double * ef, const double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * info );
void lapack_dpttrf(const int n, double * d, double * e, int * info );
void lapack_dpttrs(const int n, const int nrhs, const double * d, const double * e, double * b, const int ldb, int * info );
void lapack_dptts2(const int n, const int nrhs, const double * d, const double * e, double * b, const int ldb );
void lapack_drscl(const int n, const double sa, double * sx, const int incx );
void lapack_dsbev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, double * w, double * z, const int ldz, double * work, int * info );
void lapack_dsbevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, double * w, double * z, const int ldz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dsbevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, double * q, const int ldq, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_dsbgst(const enum lapack_form_x_type vect, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, double * ab, const int ldab, const double * bb, const int ldbb, double * x, const int ldx, double * work, int * info );
void lapack_dsbgv(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, double * ab, const int ldab, double * bb, const int ldbb, double * w, double * z, const int ldz, double * work, int * info );
void lapack_dsbgvd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, double * ab, const int ldab, double * bb, const int ldbb, double * w, double * z, const int ldz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dsbgvx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, double * ab, const int ldab, double * bb, const int ldbb, double * q, const int ldq, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_dsbtrd(const enum lapack_form_q_type vect, const enum lapack_uplo_type uplo, const int n, const int kd, double * ab, const int ldab, double * d, double * e, double * q, const int ldq, double * work, int * info );
double lapack_dsecnd( );
void lapack_dspcon(const enum lapack_uplo_type uplo, const int n, const double * ap, const int * ipiv, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dspev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * ap, double * w, double * z, const int ldz, double * work, int * info );
void lapack_dspevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * ap, double * w, double * z, const int ldz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dspevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, double * ap, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_dspgst(const int itype, const enum lapack_uplo_type uplo, const int n, double * ap, const double * bp, int * info );
void lapack_dspgv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * ap, double * bp, double * w, double * z, const int ldz, double * work, int * info );
void lapack_dspgvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * ap, double * bp, double * w, double * z, const int ldz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dspgvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, double * ap, double * bp, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_dsprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * ap, const double * afp, const int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dspsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, double * ap, int * ipiv, double * b, const int ldb, int * info );
void lapack_dspsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * ap, double * afp, int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dsptrd(const enum lapack_uplo_type uplo, const int n, double * ap, double * d, double * e, double * tau, int * info );
void lapack_dsptrf(const enum lapack_uplo_type uplo, const int n, double * ap, int * ipiv, int * info );
void lapack_dsptri(const enum lapack_uplo_type uplo, const int n, double * ap, const int * ipiv, double * work, int * info );
void lapack_dsptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * ap, const int * ipiv, double * b, const int ldb, int * info );
void lapack_dstebz(const enum lapack_range_type range, const enum lapack_order_block_type order, const int n, const double vl, const double vu, const int il, const int iu, const double abstol, const double * d, const double * e, int * m, int * nsplit, double * w, int * iblock, int * isplit, double * work, int * iwork, int * info );
void lapack_dstedc(const enum lapack_compute_type compz, const int n, double * d, double * e, double * z, const int ldz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dstegr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, double * d, double * e, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, int * isuppz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dstein(const int n, const double * d, const double * e, const int m, const double * w, const int * iblock, const int * isplit, double * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_dsteqr(const enum lapack_compute_type compz, const int n, double * d, double * e, double * z, const int ldz, double * work, int * info );
void lapack_dsterf(const int n, double * d, double * e, int * info );
void lapack_dstev(const enum lapack_compute_vectors_type jobz, const int n, double * d, double * e, double * z, const int ldz, double * work, int * info );
void lapack_dstevd(const enum lapack_compute_vectors_type jobz, const int n, double * d, double * e, double * z, const int ldz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dstevr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, double * d, double * e, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, int * isuppz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dstevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, double * d, double * e, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_dsycon(const enum lapack_uplo_type uplo, const int n, const double * a, const int lda, const int * ipiv, const double anorm, double * rcond, double * work, int * iwork, int * info );
void lapack_dsyev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * w, double * work, const int lwork, int * info );
void lapack_dsyevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * w, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dsyevr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, int * isuppz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dsyevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, const int lwork, int * iwork, int * ifail, int * info );
void lapack_dsygs2(const int itype, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const double * b, const int ldb, int * info );
void lapack_dsygst(const int itype, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const double * b, const int ldb, int * info );
void lapack_dsygv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * b, const int ldb, double * w, double * work, const int lwork, int * info );
void lapack_dsygvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * b, const int ldb, double * w, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dsygvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * b, const int ldb, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, double * z, const int ldz, double * work, const int lwork, int * iwork, int * ifail, int * info );
void lapack_dsyrfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * a, const int lda, const double * af, const int ldaf, const int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dsysv(const enum lapack_uplo_type uplo, const int n, const int nrhs, double * a, const int lda, int * ipiv, double * b, const int ldb, double * work, const int lwork, int * info );
void lapack_dsysvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * a, const int lda, double * af, const int ldaf, int * ipiv, const double * b, const int ldb, double * x, const int ldx, double * rcond, double * ferr, double * berr, double * work, const int lwork, int * iwork, int * info );
void lapack_dsytd2(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * d, double * e, double * tau, int * info );
void lapack_dsytf2(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * ipiv, int * info );
void lapack_dsytrd(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, double * d, double * e, double * tau, double * work, const int lwork, int * info );
void lapack_dsytrf(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, int * ipiv, double * work, const int lwork, int * info );
void lapack_dsytri(const enum lapack_uplo_type uplo, const int n, double * a, const int lda, const int * ipiv, double * work, int * info );
void lapack_dsytrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * a, const int lda, const int * ipiv, double * b, const int ldb, int * info );
void lapack_dtbcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int kd, const double * ab, const int ldab, double * rcond, double * work, int * iwork, int * info );
void lapack_dtbrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const double * ab, const int ldab, const double * b, const int ldb, const double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dtbtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const double * ab, const int ldab, double * b, const int ldb, int * info );
void lapack_dtgevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, const long int * select, const int n, const double * s, const int lds, const double * p, const int ldp, double * vl, const int ldvl, double * vr, const int ldvr, const int mm, int * m, double * work, int * info );
void lapack_dtgex2(const long int wantq, const long int wantz, const int n, double * a, const int lda, double * b, const int ldb, double * q, const int ldq, double * z, const int ldz, const int j1, const int n1, const int n2, double * work, const int lwork, int * info );
void lapack_dtgexc(const long int wantq, const long int wantz, const int n, double * a, const int lda, double * b, const int ldb, double * q, const int ldq, double * z, const int ldz, int * ifst, int * ilst, double * work, const int lwork, int * info );
void lapack_dtgsen(const int ijob, const long int wantq, const long int wantz, const long int * select, const int n, double * a, const int lda, double * b, const int ldb, double * alphar, double * alphai, double * beta, double * q, const int ldq, double * z, const int ldz, int * m, double * pl, double * pr, double * dif, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dtgsja(const enum lapack_compute_tgsj_type jobu, const enum lapack_compute_tgsj_type jobv, const enum lapack_compute_tgsj_type jobq, const int m, const int p, const int n, const int k, const int l, double * a, const int lda, double * b, const int ldb, const double tola, const double tolb, double * alpha, double * beta, double * u, const int ldu, double * v, const int ldv, double * q, const int ldq, double * work, int * ncycle, int * info );
void lapack_dtgsna(const enum lapack_balance_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const double * a, const int lda, const double * b, const int ldb, const double * vl, const int ldvl, const double * vr, const int ldvr, double * s, double * dif, const int mm, int * m, double * work, const int lwork, int * iwork, int * info );
void lapack_dtgsy2(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const double * a, const int lda, const double * b, const int ldb, double * c, const int ldc, const double * d, const int ldd, const double * e, const int lde, double * f, const int ldf, double * scale, double * rdsum, double * rdscal, int * iwork, int * pq, int * info );
void lapack_dtgsyl(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const double * a, const int lda, const double * b, const int ldb, double * c, const int ldc, const double * d, const int ldd, const double * e, const int lde, double * f, const int ldf, double * dif, double * scale, double * work, const int lwork, int * iwork, int * info );
void lapack_dtpcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const double * ap, double * rcond, double * work, int * iwork, int * info );
void lapack_dtprfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const double * ap, const double * b, const int ldb, const double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dtptri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, double * ap, int * info );
void lapack_dtptrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const double * ap, double * b, const int ldb, int * info );
void lapack_dtrcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const double * a, const int lda, double * rcond, double * work, int * iwork, int * info );
void lapack_dtrevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, long int * select, const int n, const double * t, const int ldt, double * vl, const int ldvl, double * vr, const int ldvr, const int mm, int * m, double * work, int * info );
void lapack_dtrexc(const enum lapack_compute_type compq, const int n, double * t, const int ldt, double * q, const int ldq, int * ifst, int * ilst, double * work, int * info );
void lapack_dtrrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const double * a, const int lda, const double * b, const int ldb, const double * x, const int ldx, double * ferr, double * berr, double * work, int * iwork, int * info );
void lapack_dtrsen(const enum lapack_compute_cond_type job, const enum lapack_compute_type compq, const long int * select, const int n, double * t, const int ldt, double * q, const int ldq, double * wr, double * wi, int * m, double * s, double * sep, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_dtrsna(const enum lapack_compute_cond_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const double * t, const int ldt, const double * vl, const int ldvl, const double * vr, const int ldvr, double * s, double * sep, const int mm, int * m, double * work, const int ldwork, int * iwork, int * info );
void lapack_dtrsyl(const enum lapack_trans_type trana, const enum lapack_trans_type tranb, const int isgn, const int m, const int n, const double * a, const int lda, const double * b, const int ldb, double * c, const int ldc, double * scale, int * info );
void lapack_dtrti2(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, double * a, const int lda, int * info );
void lapack_dtrtri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, double * a, const int lda, int * info );
void lapack_dtrtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const double * a, const int lda, double * b, const int ldb, int * info );
void lapack_dtzrqf(const int m, const int n, double * a, const int lda, double * tau, int * info );
void lapack_dtzrzf(const int m, const int n, double * a, const int lda, double * tau, double * work, const int lwork, int * info );
double lapack_dzsum1(const int n, const void * cx, const int incx );
int lapack_icmax1(const int n, const void * cx, const int incx );
int lapack_ieeeck(const int ispec, const float zero, const float one );
int lapack_ilaenv(const int ispec, const char * name, const char * opts, const int n1, const int n2, const int n3, const int n4 );
void lapack_ilaver(int * vers_major, int * vers_minor, int * vers_patch );
int lapack_izmax1(const int n, const void * cx, const int incx );
long int lapack_lsame(const char ca, const char cb );
long int lapack_lsamen(const int n, const char * ca, const char * cb );
void lapack_sbdsdc(const enum lapack_uplo_type uplo, const enum lapack_compute_type compq, const int n, float * d, float * e, float * u, const int ldu, float * vt, const int ldvt, float * q, int * iq, float * work, int * iwork, int * info );
void lapack_sbdsqr(const enum lapack_uplo_type uplo, const int n, const int ncvt, const int nru, const int ncc, float * d, float * e, float * vt, const int ldvt, float * u, const int ldu, float * c, const int ldc, float * work, int * info );
float lapack_scsum1(const int n, const void * cx, const int incx );
void lapack_sdisna(const enum lapack_balance_type job, const int m, const int n, const float * d, float * sep, int * info );
float lapack_second( );
void lapack_sgbbrd(const enum lapack_form_matrices_type vect, const int m, const int n, const int ncc, const int kl, const int ku, float * ab, const int ldab, float * d, float * e, float * q, const int ldq, float * pt, const int ldpt, float * c, const int ldc, float * work, int * info );
void lapack_sgbcon(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const float * ab, const int ldab, const int * ipiv, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_sgbequ(const int m, const int n, const int kl, const int ku, const float * ab, const int ldab, float * r, float * c, float * rowcnd, float * colcnd, float * amax, int * info );
void lapack_sgbrfs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const float * ab, const int ldab, const float * afb, const int ldafb, const int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sgbsv(const int n, const int kl, const int ku, const int nrhs, float * ab, const int ldab, int * ipiv, float * b, const int ldb, int * info );
void lapack_sgbsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, float * ab, const int ldab, float * afb, const int ldafb, int * ipiv, char * equed, float * r, float * c, float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sgbtf2(const int m, const int n, const int kl, const int ku, float * ab, const int ldab, int * ipiv, int * info );
void lapack_sgbtrf(const int m, const int n, const int kl, const int ku, float * ab, const int ldab, int * ipiv, int * info );
void lapack_sgbtrs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const float * ab, const int ldab, const int * ipiv, float * b, const int ldb, int * info );
void lapack_sgebak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const float * scale, const int m, float * v, const int ldv, int * info );
void lapack_sgebal(const enum lapack_balance_type job, const int n, float * a, const int lda, int * ilo, int * ihi, float * scale, int * info );
void lapack_sgebd2(const int m, const int n, float * a, const int lda, float * d, float * e, float * tauq, float * taup, float * work, int * info );
void lapack_sgebrd(const int m, const int n, float * a, const int lda, float * d, float * e, float * tauq, float * taup, float * work, const int lwork, int * info );
void lapack_sgecon(const enum lapack_norm_type norm, const int n, const float * a, const int lda, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_sgeequ(const int m, const int n, const float * a, const int lda, float * r, float * c, float * rowcnd, float * colcnd, float * amax, int * info );
void lapack_sgees(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (float*,float*), const int n, float * a, const int lda, int * sdim, float * wr, float * wi, float * vs, const int ldvs, float * work, const int lwork, long int * bwork, int * info );
void lapack_sgeesx(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (float*,float*), const enum lapack_reciprocal_condition_type sense, const int n, float * a, const int lda, int * sdim, float * wr, float * wi, float * vs, const int ldvs, float * rconde, float * rcondv, float * work, const int lwork, int * iwork, const int liwork, long int * bwork, int * info );
void lapack_sgeev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, float * a, const int lda, float * wr, float * wi, float * vl, const int ldvl, float * vr, const int ldvr, float * work, const int lwork, int * info );
void lapack_sgeevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, float * a, const int lda, float * wr, float * wi, float * vl, const int ldvl, float * vr, const int ldvr, int * ilo, int * ihi, float * scale, float * abnrm, float * rconde, float * rcondv, float * work, const int lwork, int * iwork, int * info );
void lapack_sgegs(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const int n, float * a, const int lda, float * b, const int ldb, float * alphar, float * alphai, float * beta, float * vsl, const int ldvsl, float * vsr, const int ldvsr, float * work, const int lwork, int * info );
void lapack_sgegv(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, float * a, const int lda, float * b, const int ldb, float * alphar, float * alphai, float * beta, float * vl, const int ldvl, float * vr, const int ldvr, float * work, const int lwork, int * info );
void lapack_sgehd2(const int n, const int ilo, const int ihi, float * a, const int lda, float * tau, float * work, int * info );
void lapack_sgehrd(const int n, const int ilo, const int ihi, float * a, const int lda, float * tau, float * work, const int lwork, int * info );
void lapack_sgelq2(const int m, const int n, float * a, const int lda, float * tau, float * work, int * info );
void lapack_sgelqf(const int m, const int n, float * a, const int lda, float * tau, float * work, const int lwork, int * info );
void lapack_sgels(const enum lapack_trans_type trans, const int m, const int n, const int nrhs, float * a, const int lda, float * b, const int ldb, float * work, const int lwork, int * info );
void lapack_sgelsd(const int m, const int n, const int nrhs, const float * a, const int lda, float * b, const int ldb, float * s, const float rcond, int * rank, float * work, const int lwork, int * iwork, int * info );
void lapack_sgelss(const int m, const int n, const int nrhs, float * a, const int lda, float * b, const int ldb, float * s, const float rcond, int * rank, float * work, const int lwork, int * info );
void lapack_sgelsx(const int m, const int n, const int nrhs, float * a, const int lda, float * b, const int ldb, int * jpvt, const float rcond, int * rank, float * work, int * info );
void lapack_sgelsy(const int m, const int n, const int nrhs, float * a, const int lda, float * b, const int ldb, int * jpvt, const float rcond, int * rank, float * work, const int lwork, int * info );
void lapack_sgeql2(const int m, const int n, float * a, const int lda, float * tau, float * work, int * info );
void lapack_sgeqlf(const int m, const int n, float * a, const int lda, float * tau, float * work, const int lwork, int * info );
void lapack_sgeqp3(const int m, const int n, float * a, const int lda, int * jpvt, float * tau, float * work, const int lwork, int * info );
void lapack_sgeqpf(const int m, const int n, float * a, const int lda, int * jpvt, float * tau, float * work, int * info );
void lapack_sgeqr2(const int m, const int n, float * a, const int lda, float * tau, float * work, int * info );
void lapack_sgeqrf(const int m, const int n, float * a, const int lda, float * tau, float * work, const int lwork, int * info );
void lapack_sgerfs(const enum lapack_trans_type trans, const int n, const int nrhs, const float * a, const int lda, const float * af, const int ldaf, const int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sgerq2(const int m, const int n, float * a, const int lda, float * tau, float * work, int * info );
void lapack_sgerqf(const int m, const int n, float * a, const int lda, float * tau, float * work, const int lwork, int * info );
void lapack_sgesc2(const int n, const float * a, const int lda, float * rhs, const int * ipiv, const int * jpiv, float * scale );
void lapack_sgesdd(const enum lapack_compute_svd_type jobz, const int m, const int n, float * a, const int lda, float * s, float * u, const int ldu, float * vt, const int ldvt, float * work, const int lwork, int * iwork, int * info );
void lapack_sgesv(const int n, const int nrhs, float * a, const int lda, int * ipiv, float * b, const int ldb, int * info );
void lapack_sgesvd(const enum lapack_compute_svd_type jobu, const enum lapack_compute_svd_type jobvt, const int m, const int n, float * a, const int lda, float * s, float * u, const int ldu, float * vt, const int ldvt, float * work, const int lwork, int * info );
void lapack_sgesvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, float * a, const int lda, float * af, const int ldaf, int * ipiv, char * equed, float * r, float * c, float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sgetc2(const int n, float * a, const int lda, int * ipiv, int * jpiv, int * info );
void lapack_sgetf2(const int m, const int n, float * a, const int lda, int * ipiv, int * info );
void lapack_sgetrf(const int m, const int n, float * a, const int lda, int * ipiv, int * info );
void lapack_sgetri(const int n, float * a, const int lda, const int * ipiv, float * work, const int lwork, int * info );
void lapack_sgetrs(const enum lapack_trans_type trans, const int n, const int nrhs, const float * a, const int lda, const int * ipiv, float * b, const int ldb, int * info );
void lapack_sggbak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const float * lscale, const float * rscale, const int m, float * v, const int ldv, int * info );
void lapack_sggbal(const enum lapack_balance_type job, const int n, float * a, const int lda, float * b, const int ldb, int * ilo, int * ihi, float * lscale, float * rscale, float * work, int * info );
void lapack_sgges(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (float*,float*,float*), const int n, float * a, const int lda, float * b, const int ldb, int * sdim, float * alphar, float * alphai, float * beta, float * vsl, const int ldvsl, float * vsr, const int ldvsr, float * work, const int lwork, long int * bwork, int * info );
void lapack_sggesx(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (float*,float*,float*), const enum lapack_reciprocal_condition_type sense, const int n, float * a, const int lda, float * b, const int ldb, int * sdim, float * alphar, float * alphai, float * beta, float * vsl, const int ldvsl, float * vsr, const int ldvsr, float * rconde, float * rcondv, float * work, const int lwork, int * iwork, const int liwork, long int * bwork, int * info );
void lapack_sggev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, float * a, const int lda, float * b, const int ldb, float * alphar, float * alphai, float * beta, float * vl, const int ldvl, float * vr, const int ldvr, float * work, const int lwork, int * info );
void lapack_sggevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, float * a, const int lda, float * b, const int ldb, float * alphar, float * alphai, float * beta, float * vl, const int ldvl, float * vr, const int ldvr, int * ilo, int * ihi, float * lscale, float * rscale, float * abnrm, float * bbnrm, float * rconde, float * rcondv, float * work, const int lwork, int * iwork, long int * bwork, int * info );
void lapack_sggglm(const int n, const int m, const int p, float * a, const int lda, float * b, const int ldb, float * d, float * x, float * y, float * work, const int lwork, int * info );
void lapack_sgghrd(const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, float * a, const int lda, float * b, const int ldb, float * q, const int ldq, float * z, const int ldz, int * info );
void lapack_sgglse(const int m, const int n, const int p, float * a, const int lda, float * b, const int ldb, float * c, float * d, float * x, float * work, const int lwork, int * info );
void lapack_sggqrf(const int n, const int m, const int p, float * a, const int lda, float * taua, float * b, const int ldb, float * taub, float * work, const int lwork, int * info );
void lapack_sggrqf(const int m, const int p, const int n, float * a, const int lda, float * taua, float * b, const int ldb, float * taub, float * work, const int lwork, int * info );
void lapack_sggsvd(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int n, const int p, int * k, int * l, float * a, const int lda, float * b, const int ldb, float * alpha, float * beta, float * u, const int ldu, float * v, const int ldv, float * q, const int ldq, float * work, int * iwork, int * info );
void lapack_sggsvp(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int p, const int n, float * a, const int lda, float * b, const int ldb, const float tola, const float tolb, int * k, int * l, float * u, const int ldu, float * v, const int ldv, float * q, const int ldq, int * iwork, float * tau, float * work, int * info );
void lapack_sgtcon(const enum lapack_norm_type norm, const int n, const float * dl, const float * d, const float * du, const float * du2, const int * ipiv, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_sgtrfs(const enum lapack_trans_type trans, const int n, const int nrhs, const float * dl, const float * d, const float * du, const float * dlf, const float * df, const float * duf, const float * du2, const int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sgtsv(const int n, const int nrhs, float * dl, float * d, float * du, float * b, const int ldb, int * info );
void lapack_sgtsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, const float * dl, const float * d, const float * du, float * dlf, float * df, float * duf, float * du2, int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sgttrf(const int n, float * dl, float * d, float * du, float * du2, int * ipiv, int * info );
void lapack_sgttrs(const enum lapack_trans_type trans, const int n, const int nrhs, const float * dl, const float * d, const float * du, const float * du2, const int * ipiv, float * b, const int ldb, int * info );
void lapack_sgtts2(const int itrans, const int n, const int nrhs, const float * dl, const float * d, const float * du, const float * du2, const int * ipiv, float * b, const int ldb );
void lapack_shgeqz(const enum lapack_hseqr_type job, const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, float * h, const int ldh, float * t, const int ldt, float * alphar, float * alphai, float * beta, float * q, const int ldq, float * z, const int ldz, float * work, const int lwork, int * info );
void lapack_shsein(const enum lapack_side_type side, const enum lapack_eig_source_type eigsrc, const enum lapack_init_vector_type initv, long int * select, const int n, const float * h, const int ldh, float * wr, const float * wi, float * vl, const int ldvl, float * vr, const int ldvr, const int mm, int * m, float * work, int * ifaill, int * ifailr, int * info );
void lapack_shseqr(const enum lapack_hseqr_type job, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, float * h, const int ldh, float * wr, float * wi, float * z, const int ldz, float * work, const int lwork, int * info );
void lapack_slabad(float * small, float * large );
void lapack_slabrd(const int m, const int n, const int nb, float * a, const int lda, float * d, float * e, float * tauq, float * taup, float * x, const int ldx, float * y, const int ldy );
void lapack_slacn2(const int n, float * v, float * x, int * isgn, float * est, int * kase, int * isave );
void lapack_slacon(const int n, float * v, float * x, int * isgn, float * est, int * kase );
void lapack_slacpy(const enum lapack_uplo_type uplo, const int m, const int n, const float * a, const int lda, float * b, const int ldb );
void lapack_sladiv(const float a, const float b, const float c, const float d, float * p, float * q );
void lapack_slae2(const float a, const float b, const float c, float * rt1, float * rt2 );
void lapack_slaebz(const int ijob, const int nitmax, const int n, const int mmax, const int minp, const int nbmin, const float abstol, const float reltol, const float pivmin, const float * d, const float * e, const float * e2, int * nval, float * ab, float * c, int * mout, int * nab, float * work, int * iwork, int * info );
void lapack_slaed0(const int icompq, const int qsiz, const int n, float * d, const float * e, float * q, const int ldq, float * qstore, const int ldqs, float * work, int * iwork, int * info );
void lapack_slaed1(const int n, float * d, float * q, const int ldq, int * indxq, const float rho, const int cutpnt, float * work, int * iwork, int * info );
void lapack_slaed2(int * k, const int n, const int n1, float * d, float * q, const int ldq, int * indxq, float * rho, const float * z, float * dlamda, float * w, float * q2, int * indx, int * indxc, int * indxp, int * coltyp, int * info );
void lapack_slaed3(const int k, const int n, const int n1, float * d, float * q, const int ldq, const float rho, float * dlamda, const float * q2, const int * indx, const int * ctot, float * w, float * s, const int lds, int * info );
void lapack_slaed4(const int n, const int i, const float * d, const float * z, float * delta, const float rho, float * dlam, int * info );
void lapack_slaed5(const int i, const float * d, const float * z, float * delta, const float rho, float * dlam );
void lapack_slaed6(const int kniter, const long int orgati, const float rho, const float * d, const float * z, const float finit, float * tau, int * info );
void lapack_slaed7(const int icompq, const int n, const int qsiz, const int tlvls, const int curlvl, const int curpbm, float * d, float * q, const int ldq, int * indxq, const float rho, const int cutpnt, float * qstore, int * qptr, const int * prmptr, const int * perm, const int * givptr, const int * givcol, const float * givnum, float * work, int * iwork, int * info );
void lapack_slaed8(const int icompq, int * k, const int n, const int qsiz, float * d, float * q, const int ldq, const int * indxq, float * rho, const int cutpnt, const float * z, float * dlamda, float * q2, const int ldq2, float * w, int * perm, int * givptr, int * givcol, float * givnum, int * indxp, int * indx, int * info );
void lapack_slaed9(const int k, const int kstart, const int kstop, const int n, float * d, float * q, const int ldq, const float rho, const float * dlamda, const float * w, float * s, const int lds, int * info );
void lapack_slaeda(const int n, const int tlvls, const int curlvl, const int curpbm, const int * prmptr, const int * perm, const int * givptr, const int * givcol, const float * givnum, const float * q, const int * qptr, float * z, float * ztemp, int * info );
void lapack_slaein(const long int rightv, const long int noinit, const int n, const float * h, const int ldh, const float wr, const float wi, float * vr, float * vi, float * b, const int ldb, float * work, const float eps3, const float smlnum, const float bignum, int * info );
void lapack_slaev2(const float a, const float b, const float c, float * rt1, float * rt2, float * cs1, float * sn1 );
void lapack_slaexc(const long int wantq, const int n, float * t, const int ldt, float * q, const int ldq, const int j1, const int n1, const int n2, float * work, int * info );
void lapack_slag2(const float * a, const int lda, const float * b, const int ldb, const float safmin, float * scale1, float * scale2, float * wr1, float * wr2, float * wi );
void lapack_slags2(const long int upper, const float a1, const float a2, const float a3, const float b1, const float b2, const float b3, float * csu, float * snu, float * csv, float * snv, float * csq, float * snq );
void lapack_slagtf(const int n, float * a, const float lambda, float * b, float * c, const float tol, float * d, const int * in, int * info );
void lapack_slagtm(const enum lapack_trans_type trans, const int n, const int nrhs, const float alpha, const float * dl, const float * d, const float * du, const float * x, const int ldx, const float beta, float * b, const int ldb );
void lapack_slagts(const int job, const int n, const float * a, const float * b, const float * c, const float * d, const int * in, float * y, float * tol, int * info );
void lapack_slagv2(float * a, const int lda, float * b, const int ldb, float * alphar, float * alphai, float * beta, float * csl, float * snl, float * csr, float * snr );
void lapack_slahqr(const long int wantt, const long int wantz, const int n, const int ilo, const int ihi, float * h, const int ldh, float * wr, float * wi, const int iloz, const int ihiz, float * z, const int ldz, int * info );
void lapack_slahrd(const int n, const int k, const int nb, float * a, const int lda, float * tau, float * t, const int ldt, float * y, const int ldy );
void lapack_slaic1(const int job, const int j, const float * x, const float sest, const float * w, const float gamma, float * sestpr, float * s, float * c );
void lapack_slaln2(const long int ltrans, const int na, const int nw, const float smin, const float ca, const float * a, const int lda, const float d1, const float d2, const float * b, const int ldb, const float wr, const float wi, float * x, const int ldx, float * scale, float * xnorm, int * info );
void lapack_slals0(const int icompq, const int nl, const int nr, const int sqre, const int nrhs, float * b, const int ldb, float * bx, const int ldbx, const int * perm, const int givptr, const int * givcol, const int ldgcol, const float * givnum, const int ldgnum, const float * poles, const float * difl, const float * difr, const float * z, const int k, const float c, const float s, float * work, int * info );
void lapack_slalsa(const int icompq, const int smlsiz, const int n, const int nrhs, float * b, const int ldb, float * bx, const int ldbx, const float * u, const int ldu, const float * vt, const int * k, const float * difl, const float * difr, const float * z, const float * poles, const int * givptr, const int * givcol, const int ldgcol, const int * perm, const float * givnum, const float * c, const float * s, float * work, int * iwork, int * info );
void lapack_slalsd(const enum lapack_uplo_type uplo, const int smlsiz, const int n, const int nrhs, float * d, float * e, float * b, const int ldb, const float rcond, int * rank, float * work, int * iwork, int * info );
float lapack_slamch(const enum lapack_cmach_type cmach );
void lapack_slamc1(int * beta, int * t, long int * rnd, long int * ieee1 );
void lapack_slamc2(int * beta, int * t, long int * rnd, float * eps, int * emin, float * rmin, int * emax, float * rmax );
float lapack_slamc3(const float a, const float b );
void lapack_slamc4(int * emin, const float start, const int base );
void lapack_slamc5(const int beta, const int p, const int emin, const long int ieee, int * emax, float * rmax );
void lapack_slamrg(const int n1, const int n2, const float * a, const int strd1, const int strd2, int * index );
float lapack_slangb(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const float * ab, const int ldab, float * work );
float lapack_slange(const enum lapack_norm_type norm, const int m, const int n, const float * a, const int lda, float * work );
float lapack_slangt(const enum lapack_norm_type norm, const int n, const float * dl, const float * d, const float * du );
float lapack_slanhs(const enum lapack_norm_type norm, const int n, const float * a, const int lda, float * work );
float lapack_slansb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const int k, const float * ab, const int ldab, float * work );
float lapack_slansp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const float * ap, float * work );
float lapack_slanst(const enum lapack_norm_type norm, const int n, const float * d, const float * e );
float lapack_slansy(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const float * a, const int lda, float * work );
float lapack_slantb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int k, const float * ab, const int ldab, float * work );
float lapack_slantp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const float * ap, float * work );
float lapack_slantr(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int m, const int n, const float * a, const int lda, float * work );
void lapack_slanv2(float * a, float * b, float * c, float * d, float * rt1r, float * rt1i, float * rt2r, float * rt2i, float * cs, float * sn );
void lapack_slapll(const int n, float * x, const int incx, float * y, const int incy, float * ssmin );
void lapack_slapmt(const long int forwrd, const int m, const int n, float * x, const int ldx, int * k );
float lapack_slapy2(const float x, const float y );
float lapack_slapy3(const float x, const float y, const float z );
void lapack_slaqgb(const int m, const int n, const int kl, const int ku, float * ab, const int ldab, const float * r, const float * c, const float rowcnd, const float colcnd, const float amax, char * equed );
void lapack_slaqge(const int m, const int n, float * a, const int lda, const float * r, const float * c, const float rowcnd, const float colcnd, const float amax, char * equed );
void lapack_slaqp2(const int m, const int n, const int offset, float * a, const int lda, int * jpvt, float * tau, float * vn1, float * vn2, float * work );
void lapack_slaqps(const int m, const int n, const int offset, const int nb, int * kb, float * a, const int lda, int * jpvt, float * tau, float * vn1, float * vn2, float * auxv, float * f, const int ldf );
void lapack_slaqsb(const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, const float * s, const float scond, const float amax, char * equed );
void lapack_slaqsp(const enum lapack_uplo_type uplo, const int n, float * ap, const float * s, const float scond, const float amax, char * equed );
void lapack_slaqsy(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const float * s, const float scond, const float amax, char * equed );
void lapack_slaqtr(const long int ltran, const long int lreal, const int n, const float * t, const int ldt, const float * b, const float w, float * scale, float * x, float * work, int * info );
void lapack_slar1v(const int n, const int b1, const int bn, const float sigma, const float * l, const float * d, const float * ld, const float * lld, const float * gersch, float * z, float * ztz, float * mingma, int * r, int * isuppz, float * work );
void lapack_slar2v(const int n, float * x, float * y, float * z, const int incx, const float * c, const float * s, const int incc );
void lapack_slarf(const enum lapack_side_type side, const int m, const int n, const float * v, const int incv, const float tau, float * c, const int ldc, float * work );
void lapack_slarfb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const float * v, const int ldv, const float * t, const int ldt, float * c, const int ldc, float * work, const int ldwork );
void lapack_slarfg(const int n, float * alpha, float * x, const int incx, float * tau );
void lapack_slarft(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, float * v, const int ldv, const float * tau, float * t, const int ldt );
void lapack_slarfx(const enum lapack_side_type side, const int m, const int n, const float * v, const float tau, float * c, const int ldc, float * work );
void lapack_slargv(const int n, float * x, const int incx, float * y, const int incy, float * c, const int incc );
void lapack_slarnv(const int idist, int * iseed, const int n, float * x );
void lapack_slarrb(const int n, const float * d, const float * l, const float * ld, const float * lld, const int ifirst, const int ilast, const float sigma, const float reltol, float * w, float * wgap, float * werr, const float * work, const int * iwork, int * info );
void lapack_slarre(const int n, float * d, float * e, const float tol, int * nsplit, int * isplit, int * m, float * w, float * woff, float * gersch, const float * work, int * info );
void lapack_slarrf(const int n, const float * d, const float * l, const float * ld, const float * lld, const int ifirst, const int ilast, float * w, const float sigma, float * dplus, float * lplus, double * work, int * iwork, int * info );
void lapack_slarrv(const int n, float * d, float * l, const int * isplit, const int m, const float * w, const int * iblock, const float * gersch, const float tol, float * z, const int ldz, int * isuppz, float * work, int * iwork, int * info );
void lapack_slartg(const float f, const float g, float * cs, float * sn, float * r );
void lapack_slartv(const int n, float * x, const int incx, float * y, const int incy, const float * c, const float * s, const int incc );
void lapack_slaruv(int * iseed, const int n, float * x );
void lapack_slarz(const enum lapack_side_type side, const int m, const int n, const int l, const float * v, const int incv, const float tau, float * c, const int ldc, float * work );
void lapack_slarzb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const int l, const float * v, const int ldv, const float * t, const int ldt, float * c, const int ldc, float * work, const int ldwork );
void lapack_slarzt(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, float * v, const int ldv, const float * tau, float * t, const int ldt );
void lapack_slas2(const float f, const float g, const float h, float * ssmin, float * ssmax );
void lapack_slascl(const enum lapack_symmetry_type type, const int kl, const int ku, const float cfrom, const float cto, const int m, const int n, float * a, const int lda, int * info );
void lapack_slasd0(const int n, const int sqre, float * d, const float * e, float * u, const int ldu, float * vt, const int ldvt, const int smlsiz, int * iwork, float * work, int * info );
void lapack_slasd1(const int nl, const int nr, const int sqre, float * d, float * alpha, float * beta, float * u, const int ldu, float * vt, const int ldvt, int * idxq, int * iwork, float * work, int * info );
void lapack_slasd2(const int nl, const int nr, const int sqre, int * k, float * d, float * z, const float alpha, const float beta, float * u, const int ldu, float * vt, const int ldvt, float * dsigma, float * u2, const int ldu2, float * vt2, const int ldvt2, int * idxp, int * idx, int * idxc, int * idxq, int * coltyp, int * info );
void lapack_slasd3(const int nl, const int nr, const int sqre, const int k, float * d, float * q, const int ldq, float * dsigma, float * u, const int ldu, const float * u2, const int ldu2, float * vt, const int ldvt, float * vt2, const int ldvt2, const int * idxc, const int * ctot, float * z, int * info );
void lapack_slasd4(const int n, const int i, const float * d, const float * z, float * delta, const float rho, float * sigma, float * work, int * info );
void lapack_slasd5(const int i, const float * d, const float * z, float * delta, const float rho, float * dsigma, float * work );
void lapack_slasd6(const int icompq, const int nl, const int nr, const int sqre, float * d, float * vf, float * vl, float * alpha, float * beta, int * idxq, int * perm, int * givptr, int * givcol, const int ldgcol, float * givnum, const int ldgnum, float * poles, float * difl, float * difr, float * z, int * k, float * c, float * s, float * work, int * iwork, int * info );
void lapack_slasd7(const int icompq, const int nl, const int nr, const int sqre, int * k, float * d, float * z, float * zw, float * vf, float * vfw, float * vl, float * vlw, const float alpha, const float beta, float * dsigma, int * idx, int * idxp, const int * idxq, int * perm, int * givptr, int * givcol, const int ldgcol, float * givnum, const int ldgnum, float * c, float * s, int * info );
void lapack_slasd8(const int icompq, const int k, float * d, const float * z, float * vf, float * vl, float * difl, float * difr, const int lddifr, const float * dsigma, float * work, int * info );
void lapack_slasda(const int icompq, const int smlsiz, const int n, const int sqre, float * d, const float * e, float * u, const int ldu, float * vt, int * k, float * difl, float * difr, float * z, float * poles, int * givptr, int * givcol, const int ldgcol, int * perm, float * givnum, float * c, float * s, float * work, int * iwork, int * info );
void lapack_slasdq(const enum lapack_uplo_type uplo, const int sqre, const int n, const int ncvt, const int nru, const int ncc, float * d, float * e, float * vt, const int ldvt, float * u, const int ldu, float * c, const int ldc, float * work, int * info );
void lapack_slasdt(const int n, int * lvl, int * nd, int * inode, int * ndiml, int * ndimr, const int msub );
void lapack_slaset(const enum lapack_uplo_type uplo, const int m, const int n, const float alpha, const float beta, float * a, const int lda );
void lapack_slasq1(const int n, float * d, float * e, float * work, int * info );
void lapack_slasq2(const int n, float * z, int * info );
void lapack_slasq3(const int i0, const int n0, const float * z, const int pp, float * dmin, float * sigma, float * desig, const float qmax, int * nfail, int * iter, int * ndiv, int * ttype, const long int ieee );
void lapack_slasq4(const int i0, const int n0, const float * z, const int pp, const int n0in, const float dmin, const float dmin1, const float dmin2, const float dn, const float dn1, const float dn2, float * tau, int * ttype );
void lapack_slasq5(const int i0, const int n0, const float * z, const int pp, const float tau, float * dmin, float * dmin1, float * dmin2, float * dn, float * dnm1, float * dnm2, const long int ieee );
void lapack_slasq6(const int i0, const int n0, const float * z, const int pp, float * dmin, float * dmin1, float * dmin2, float * dn, float * dnm1, float * dnm2 );
void lapack_slasr(const enum lapack_side_type side, const enum lapack_pivot_type pivot, const enum lapack_direction_type direct, const int m, const int n, const float * c, const float * s, float * a, const int lda );
void lapack_slasrt(const enum lapack_sort_type id, const int n, float * d, int * info );
void lapack_slassq(const int n, const float * x, const int incx, float * scale, float * sumsq );
void lapack_slasv2(const float f, const float g, const float h, float * ssmin, float * ssmax, float * snl, float * csl, float * snr, float * csr );
void lapack_slaswp(const int n, float * a, const int lda, const int k1, const int k2, const int * ipiv, const int incx );
void lapack_slasy2(const long int ltranl, const long int ltranr, const int isgn, const int n1, const int n2, const float * tl, const int ldtl, const float * tr, const int ldtr, const float * b, const int ldb, float * scale, float * x, const int ldx, float * xnorm, int * info );
void lapack_slasyf(const enum lapack_uplo_type uplo, const int n, const int nb, int * kb, float * a, const int lda, int * ipiv, float * w, const int ldw, int * info );
void lapack_slatbs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const int kd, const float * ab, const int ldab, float * x, float * scale, float * cnorm, int * info );
void lapack_slatdf(const int ijob, const int n, const float * z, const int ldz, float * rhs, float * rdsum, float * rdscal, const int * ipiv, const int * jpiv );
void lapack_slatps(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const float * ap, float * x, float * scale, float * cnorm, int * info );
void lapack_slatrd(const enum lapack_uplo_type uplo, const int n, const int nb, float * a, const int lda, float * e, float * tau, float * w, const int ldw );
void lapack_slatrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const float * a, const int lda, float * x, float * scale, float * cnorm, int * info );
void lapack_slatrz(const int m, const int n, const int l, float * a, const int lda, float * tau, float * work );
void lapack_slatzm(const enum lapack_side_type side, const int m, const int n, const float * v, const int incv, const float tau, float * c1, float * c2, const int ldc, float * work );
void lapack_slauu2(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * info );
void lapack_slauum(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * info );
void lapack_slazq3(const int i0, const int n0, const float * z, const int pp, float * dmin, float * sigma, float * desig, const float qmax, int * nfail, int * iter, int * ndiv, const long int ieee, int * ttype, float * dmin1, float * dmin2, float * dn, float * dn1, float * dn2, float * tau );
void lapack_slazq4(const int i0, const int n0, const float * z, const int pp, const int n0in, const float dmin, const float dmin1, const float dmin2, const float dn, const float dn1, const float dn2, float * tau, int * ttype, float * g );
void lapack_sopgtr(const enum lapack_uplo_type uplo, const int n, const float * ap, const float * tau, float * q, const int ldq, float * work, int * info );
void lapack_sopmtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const float * ap, const float * tau, float * c, const int ldc, float * work, int * info );
void lapack_sorg2l(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, int * info );
void lapack_sorg2r(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, int * info );
void lapack_sorgbr(const enum lapack_form_matrices_type vect, const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorghr(const int n, const int ilo, const int ihi, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorgl2(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, int * info );
void lapack_sorglq(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorgql(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorgqr(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorgr2(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, int * info );
void lapack_sorgrq(const int m, const int n, const int k, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorgtr(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const float * tau, float * work, const int lwork, int * info );
void lapack_sorm2l(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, int * info );
void lapack_sorm2r(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, int * info );
void lapack_sormbr(const enum lapack_form_matrices_type vect, const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sormhr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int ilo, const int ihi, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sorml2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, int * info );
void lapack_sormlq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sormql(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sormqr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sormr2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, int * info );
void lapack_sormr3(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, int * info );
void lapack_sormrq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sormrz(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_sormtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const float * a, const int lda, const float * tau, float * c, const int ldc, float * work, const int lwork, int * info );
void lapack_spbcon(const enum lapack_uplo_type uplo, const int n, const int kd, const float * ab, const int ldab, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_spbequ(const enum lapack_uplo_type uplo, const int n, const int kd, const float * ab, const int ldab, float * s, float * scond, float * amax, int * info );
void lapack_spbrfs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const float * ab, const int ldab, const float * afb, const int ldafb, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_spbstf(const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, int * info );
void lapack_spbsv(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, float * ab, const int ldab, float * b, const int ldb, int * info );
void lapack_spbsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, float * ab, const int ldab, float * afb, const int ldafb, char * equed, float * s, float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_spbtf2(const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, int * info );
void lapack_spbtrf(const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, int * info );
void lapack_spbtrs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const float * ab, const int ldab, float * b, const int ldb, int * info );
void lapack_spocon(const enum lapack_uplo_type uplo, const int n, const float * a, const int lda, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_spoequ(const int n, const float * a, const int lda, float * s, float * scond, float * amax, int * info );
void lapack_sporfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * a, const int lda, const float * af, const int ldaf, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sposv(const enum lapack_uplo_type uplo, const int n, const int nrhs, float * a, const int lda, float * b, const int ldb, int * info );
void lapack_sposvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, float * a, const int lda, float * af, const int ldaf, char * equed, float * s, float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_spotf2(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * info );
void lapack_spotrf(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * info );
void lapack_spotri(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * info );
void lapack_spotrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * a, const int lda, float * b, const int ldb, int * info );
void lapack_sppcon(const enum lapack_uplo_type uplo, const int n, const float * ap, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_sppequ(const enum lapack_uplo_type uplo, const int n, const float * ap, float * s, float * scond, float * amax, int * info );
void lapack_spprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * ap, const float * afp, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sppsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, float * ap, float * b, const int ldb, int * info );
void lapack_sppsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, float * ap, float * afp, char * equed, float * s, float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_spptrf(const enum lapack_uplo_type uplo, const int n, float * ap, int * info );
void lapack_spptri(const enum lapack_uplo_type uplo, const int n, float * ap, int * info );
void lapack_spptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * ap, float * b, const int ldb, int * info );
void lapack_sptcon(const int n, const float * d, const float * e, const float anorm, float * rcond, float * work, int * info );
void lapack_spteqr(const enum lapack_compute_type compz, const int n, float * d, float * e, float * z, const int ldz, float * work, int * info );
void lapack_sptrfs(const int n, const int nrhs, const float * d, const float * e, const float * df, const float * ef, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * info );
void lapack_sptsv(const int n, const int nrhs, float * d, float * e, float * b, const int ldb, int * info );
void lapack_sptsvx(const enum lapack_fact_type fact, const int n, const int nrhs, const float * d, const float * e, float * df, float * ef, const float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * info );
void lapack_spttrf(const int n, float * d, float * e, int * info );
void lapack_spttrs(const int n, const int nrhs, const float * d, const float * e, float * b, const int ldb, int * info );
void lapack_sptts2(const int n, const int nrhs, const float * d, const float * e, float * b, const int ldb );
void lapack_srscl(const int n, const float sa, float * sx, const int incx );
void lapack_ssbev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, float * w, float * z, const int ldz, float * work, int * info );
void lapack_ssbevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, float * w, float * z, const int ldz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ssbevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, float * q, const int ldq, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_ssbgst(const enum lapack_form_x_type vect, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, float * ab, const int ldab, const float * bb, const int ldbb, float * x, const int ldx, float * work, int * info );
void lapack_ssbgv(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, float * ab, const int ldab, float * bb, const int ldbb, float * w, float * z, const int ldz, float * work, int * info );
void lapack_ssbgvd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, float * ab, const int ldab, float * bb, const int ldbb, float * w, float * z, const int ldz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ssbgvx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, float * ab, const int ldab, float * bb, const int ldbb, float * q, const int ldq, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_ssbtrd(const enum lapack_form_q_type vect, const enum lapack_uplo_type uplo, const int n, const int kd, float * ab, const int ldab, float * d, float * e, float * q, const int ldq, float * work, int * info );
void lapack_sspcon(const enum lapack_uplo_type uplo, const int n, const float * ap, const int * ipiv, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_sspev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * ap, float * w, float * z, const int ldz, float * work, int * info );
void lapack_sspevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * ap, float * w, float * z, const int ldz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_sspevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, float * ap, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_sspgst(const int itype, const enum lapack_uplo_type uplo, const int n, float * ap, const float * bp, int * info );
void lapack_sspgv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * ap, float * bp, float * w, float * z, const int ldz, float * work, int * info );
void lapack_sspgvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * ap, float * bp, float * w, float * z, const int ldz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_sspgvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, float * ap, float * bp, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_ssprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * ap, const float * afp, const int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_sspsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, float * ap, int * ipiv, float * b, const int ldb, int * info );
void lapack_sspsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * ap, float * afp, int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_ssptrd(const enum lapack_uplo_type uplo, const int n, float * ap, float * d, float * e, float * tau, int * info );
void lapack_ssptrf(const enum lapack_uplo_type uplo, const int n, float * ap, int * ipiv, int * info );
void lapack_ssptri(const enum lapack_uplo_type uplo, const int n, float * ap, const int * ipiv, float * work, int * info );
void lapack_ssptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * ap, const int * ipiv, float * b, const int ldb, int * info );
void lapack_sstebz(const enum lapack_range_type range, const enum lapack_order_block_type order, const int n, const float vl, const float vu, const int il, const int iu, const float abstol, const float * d, const float * e, int * m, int * nsplit, float * w, int * iblock, int * isplit, float * work, int * iwork, int * info );
void lapack_sstedc(const enum lapack_compute_type compz, const int n, float * d, float * e, float * z, const int ldz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_sstegr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, float * d, float * e, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, int * isuppz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_sstein(const int n, const float * d, const float * e, const int m, const float * w, const int * iblock, const int * isplit, float * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_ssteqr(const enum lapack_compute_type compz, const int n, float * d, float * e, float * z, const int ldz, float * work, int * info );
void lapack_ssterf(const int n, float * d, float * e, int * info );
void lapack_sstev(const enum lapack_compute_vectors_type jobz, const int n, float * d, float * e, float * z, const int ldz, float * work, int * info );
void lapack_sstevd(const enum lapack_compute_vectors_type jobz, const int n, float * d, float * e, float * z, const int ldz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_sstevr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, float * d, float * e, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, int * isuppz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_sstevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, float * d, float * e, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, int * iwork, int * ifail, int * info );
void lapack_ssycon(const enum lapack_uplo_type uplo, const int n, const float * a, const int lda, const int * ipiv, const float anorm, float * rcond, float * work, int * iwork, int * info );
void lapack_ssyev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * w, float * work, const int lwork, int * info );
void lapack_ssyevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * w, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ssyevr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, int * isuppz, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ssyevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, const int lwork, int * iwork, int * ifail, int * info );
void lapack_ssygs2(const int itype, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const float * b, const int ldb, int * info );
void lapack_ssygst(const int itype, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const float * b, const int ldb, int * info );
void lapack_ssygv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * b, const int ldb, float * w, float * work, const int lwork, int * info );
void lapack_ssygvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * b, const int ldb, float * w, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ssygvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * b, const int ldb, const float vl, const float vu, const int il, const int iu, const float abstol, int * m, float * w, float * z, const int ldz, float * work, const int lwork, int * iwork, int * ifail, int * info );
void lapack_ssyrfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * a, const int lda, const float * af, const int ldaf, const int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_ssysv(const enum lapack_uplo_type uplo, const int n, const int nrhs, float * a, const int lda, int * ipiv, float * b, const int ldb, float * work, const int lwork, int * info );
void lapack_ssysvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * a, const int lda, float * af, const int ldaf, int * ipiv, const float * b, const int ldb, float * x, const int ldx, float * rcond, float * ferr, float * berr, float * work, const int lwork, int * iwork, int * info );
void lapack_ssytd2(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * d, float * e, float * tau, int * info );
void lapack_ssytf2(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * ipiv, int * info );
void lapack_ssytrd(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, float * d, float * e, float * tau, float * work, const int lwork, int * info );
void lapack_ssytrf(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, int * ipiv, float * work, const int lwork, int * info );
void lapack_ssytri(const enum lapack_uplo_type uplo, const int n, float * a, const int lda, const int * ipiv, float * work, int * info );
void lapack_ssytrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const float * a, const int lda, const int * ipiv, float * b, const int ldb, int * info );
void lapack_stbcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int kd, const float * ab, const int ldab, float * rcond, float * work, int * iwork, int * info );
void lapack_stbrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const float * ab, const int ldab, const float * b, const int ldb, const float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_stbtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const float * ab, const int ldab, float * b, const int ldb, int * info );
void lapack_stgevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, const long int * select, const int n, const float * s, const int lds, const float * p, const int ldp, float * vl, const int ldvl, float * vr, const int ldvr, const int mm, int * m, float * work, int * info );
void lapack_stgex2(const long int wantq, const long int wantz, const int n, float * a, const int lda, float * b, const int ldb, float * q, const int ldq, float * z, const int ldz, const int j1, const int n1, const int n2, float * work, const int lwork, int * info );
void lapack_stgexc(const long int wantq, const long int wantz, const int n, float * a, const int lda, float * b, const int ldb, float * q, const int ldq, float * z, const int ldz, int * ifst, int * ilst, float * work, const int lwork, int * info );
void lapack_stgsen(const int ijob, const long int wantq, const long int wantz, const long int * select, const int n, float * a, const int lda, float * b, const int ldb, float * alphar, float * alphai, float * beta, float * q, const int ldq, float * z, const int ldz, int * m, float * pl, float * pr, float * dif, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_stgsja(const enum lapack_compute_tgsj_type jobu, const enum lapack_compute_tgsj_type jobv, const enum lapack_compute_tgsj_type jobq, const int m, const int p, const int n, const int k, const int l, float * a, const int lda, float * b, const int ldb, const float tola, const float tolb, float * alpha, float * beta, float * u, const int ldu, float * v, const int ldv, float * q, const int ldq, float * work, int * ncycle, int * info );
void lapack_stgsna(const enum lapack_balance_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const float * a, const int lda, const float * b, const int ldb, const float * vl, const int ldvl, const float * vr, const int ldvr, float * s, float * dif, const int mm, int * m, float * work, const int lwork, int * iwork, int * info );
void lapack_stgsy2(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const float * a, const int lda, const float * b, const int ldb, float * c, const int ldc, const float * d, const int ldd, const float * e, const int lde, float * f, const int ldf, float * scale, float * rdsum, float * rdscal, int * iwork, int * pq, int * info );
void lapack_stgsyl(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const float * a, const int lda, const float * b, const int ldb, float * c, const int ldc, const float * d, const int ldd, const float * e, const int lde, float * f, const int ldf, float * dif, float * scale, float * work, const int lwork, int * iwork, int * info );
void lapack_stpcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const float * ap, float * rcond, float * work, int * iwork, int * info );
void lapack_stprfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const float * ap, const float * b, const int ldb, const float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_stptri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, float * ap, int * info );
void lapack_stptrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const float * ap, float * b, const int ldb, int * info );
void lapack_strcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const float * a, const int lda, float * rcond, float * work, int * iwork, int * info );
void lapack_strevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, long int * select, const int n, const float * t, const int ldt, float * vl, const int ldvl, float * vr, const int ldvr, const int mm, int * m, float * work, int * info );
void lapack_strexc(const enum lapack_compute_type compq, const int n, float * t, const int ldt, float * q, const int ldq, int * ifst, int * ilst, float * work, int * info );
void lapack_strrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const float * a, const int lda, const float * b, const int ldb, const float * x, const int ldx, float * ferr, float * berr, float * work, int * iwork, int * info );
void lapack_strsen(const enum lapack_compute_cond_type job, const enum lapack_compute_type compq, const long int * select, const int n, float * t, const int ldt, float * q, const int ldq, float * wr, float * wi, int * m, float * s, float * sep, float * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_strsna(const enum lapack_compute_cond_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const float * t, const int ldt, const float * vl, const int ldvl, const float * vr, const int ldvr, float * s, float * sep, const int mm, int * m, float * work, const int ldwork, int * iwork, int * info );
void lapack_strsyl(const enum lapack_trans_type trana, const enum lapack_trans_type tranb, const int isgn, const int m, const int n, const float * a, const int lda, const float * b, const int ldb, float * c, const int ldc, float * scale, int * info );
void lapack_strti2(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, float * a, const int lda, int * info );
void lapack_strtri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, float * a, const int lda, int * info );
void lapack_strtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const float * a, const int lda, float * b, const int ldb, int * info );
void lapack_stzrqf(const int m, const int n, float * a, const int lda, float * tau, int * info );
void lapack_stzrzf(const int m, const int n, float * a, const int lda, float * tau, float * work, const int lwork, int * info );
void lapack_xerbla(const char * srname, const int info );
void lapack_zbdsqr(const enum lapack_uplo_type uplo, const int n, const int ncvt, const int nru, const int ncc, double * d, double * e, void * vt, const int ldvt, void * u, const int ldu, void * c, const int ldc, double * rwork, int * info );
void lapack_zdrot(const int n, const void * cx, const int incx, const void * cy, const int incy, const double c, const double s );
void lapack_zdrscl(const int n, const double sa, void * sx, const int incx );
void lapack_zgbbrd(const enum lapack_form_matrices_type vect, const int m, const int n, const int ncc, const int kl, const int ku, void * ab, const int ldab, double * d, double * e, void * q, const int ldq, void * pt, const int ldpt, void * c, const int ldc, void * work, double * rwork, int * info );
void lapack_zgbcon(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const void * ab, const int ldab, const int * ipiv, const double anorm, double * rcond, void * work, double * rwork, int * info );
void lapack_zgbequ(const int m, const int n, const int kl, const int ku, const void * ab, const int ldab, double * r, double * c, double * rowcnd, double * colcnd, double * amax, int * info );
void lapack_zgbrfs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const void * ab, const int ldab, const void * afb, const int ldafb, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zgbsv(const int n, const int kl, const int ku, const int nrhs, void * ab, const int ldab, int * ipiv, void * b, const int ldb, int * info );
void lapack_zgbsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, void * ab, const int ldab, void * afb, const int ldafb, int * ipiv, char * equed, double * r, double * c, void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zgbtf2(const int m, const int n, const int kl, const int ku, void * ab, const int ldab, int * ipiv, int * info );
void lapack_zgbtrf(const int m, const int n, const int kl, const int ku, void * ab, const int ldab, int * ipiv, int * info );
void lapack_zgbtrs(const enum lapack_trans_type trans, const int n, const int kl, const int ku, const int nrhs, const void * ab, const int ldab, const int * ipiv, void * b, const int ldb, int * info );
void lapack_zgebak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const double * scale, const int m, void * v, const int ldv, int * info );
void lapack_zgebal(const enum lapack_balance_type job, const int n, void * a, const int lda, int * ilo, int * ihi, double * scale, int * info );
void lapack_zgebd2(const int m, const int n, void * a, const int lda, double * d, double * e, void * tauq, void * taup, void * work, int * info );
void lapack_zgebrd(const int m, const int n, void * a, const int lda, double * d, double * e, void * tauq, void * taup, void * work, const int lwork, int * info );
void lapack_zgecon(const enum lapack_norm_type norm, const int n, const void * a, const int lda, const double anorm, double * rcond, void * work, double * rwork, int * info );
void lapack_zgeequ(const int m, const int n, const void * a, const int lda, double * r, double * c, double * rowcnd, double * colcnd, double * amax, int * info );
void lapack_zgees(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (void*), const int n, void * a, const int lda, int * sdim, void * w, void * vs, const int ldvs, void * work, const int lwork, double * rwork, long int * bwork, int * info );
void lapack_zgeesx(const enum lapack_compute_vectors_type jobvs, const enum lapack_ordering_type sort, const long int (*select) (void*), const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, int * sdim, void * w, void * vs, const int ldvs, double * rconde, double * rcondv, void * work, const int lwork, double * rwork, long int * bwork, int * info );
void lapack_zgeev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, void * a, const int lda, void * w, void * vl, const int ldvl, void * vr, const int ldvr, void * work, const int lwork, double * rwork, int * info );
void lapack_zgeevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, void * w, void * vl, const int ldvl, void * vr, const int ldvr, int * ilo, int * ihi, double * scale, double * abnrm, double * rconde, double * rcondv, void * work, const int lwork, double * rwork, int * info );
void lapack_zgegs(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vsl, const int ldvsl, void * vsr, const int ldvsr, void * work, const int lwork, double * rwork, int * info );
void lapack_zgegv(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vl, const int ldvl, void * vr, const int ldvr, void * work, const int lwork, double * rwork, int * info );
void lapack_zgehd2(const int n, const int ilo, const int ihi, void * a, const int lda, void * tau, void * work, int * info );
void lapack_zgehrd(const int n, const int ilo, const int ihi, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_zgelq2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_zgelqf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_zgels(const enum lapack_trans_type trans, const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, void * work, const int lwork, int * info );
void lapack_zgelsd(const int m, const int n, const int nrhs, const void * a, const int lda, void * b, const int ldb, double * s, const double rcond, int * rank, void * work, const int lwork, double * rwork, int * iwork, int * info );
void lapack_zgelss(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, double * s, const double rcond, int * rank, void * work, const int lwork, double * rwork, int * info );
void lapack_zgelsx(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, int * jpvt, const double rcond, int * rank, void * work, double * rwork, int * info );
void lapack_zgelsy(const int m, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, int * jpvt, const double rcond, int * rank, void * work, const int lwork, double * rwork, int * info );
void lapack_zgeql2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_zgeqlf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_zgeqp3(const int m, const int n, void * a, const int lda, int * jpvt, void * tau, void * work, const int lwork, double * rwork, int * info );
void lapack_zgeqpf(const int m, const int n, void * a, const int lda, int * jpvt, void * tau, void * work, double * rwork, int * info );
void lapack_zgeqr2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_zgeqrf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_zgerfs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zgerq2(const int m, const int n, void * a, const int lda, void * tau, void * work, int * info );
void lapack_zgerqf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_zgesc2(const int n, const void * a, const int lda, void * rhs, const int * ipiv, const int * jpiv, double * scale );
void lapack_zgesdd(const enum lapack_compute_svd_type jobz, const int m, const int n, void * a, const int lda, double * s, void * u, const int ldu, void * vt, const int ldvt, void * work, const int lwork, double * rwork, int * iwork, int * info );
void lapack_zgesv(const int n, const int nrhs, void * a, const int lda, int * ipiv, void * b, const int ldb, int * info );
void lapack_zgesvd(const enum lapack_compute_svd_type jobu, const enum lapack_compute_svd_type jobvt, const int m, const int n, void * a, const int lda, double * s, void * u, const int ldu, void * vt, const int ldvt, void * work, const int lwork, double * rwork, int * info );
void lapack_zgesvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, void * a, const int lda, void * af, const int ldaf, int * ipiv, char * equed, double * r, double * c, void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zgetc2(const int n, void * a, const int lda, int * ipiv, int * jpiv, int * info );
void lapack_zgetf2(const int m, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_zgetrf(const int m, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_zgetri(const int n, void * a, const int lda, const int * ipiv, void * work, const int lwork, int * info );
void lapack_zgetrs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * a, const int lda, const int * ipiv, void * b, const int ldb, int * info );
void lapack_zggbak(const enum lapack_balance_type job, const enum lapack_side_type side, const int n, const int ilo, const int ihi, const double * lscale, const double * rscale, const int m, void * v, const int ldv, int * info );
void lapack_zggbal(const enum lapack_balance_type job, const int n, void * a, const int lda, void * b, const int ldb, int * ilo, int * ihi, double * lscale, double * rscale, float * work, int * info );
void lapack_zgges(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (void*,void*), const int n, void * a, const int lda, void * b, const int ldb, int * sdim, void * alpha, void * beta, void * vsl, const int ldvsl, void * vsr, const int ldvsr, void * work, const int lwork, double * rwork, long int * bwork, int * info );
void lapack_zggesx(const enum lapack_compute_vectors_type jobvsl, const enum lapack_compute_vectors_type jobvsr, const enum lapack_ordering_type sort, const long int (*selctg) (void*,void*), const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, void * b, const int ldb, int * sdim, void * alpha, void * beta, void * vsl, const int ldvsl, void * vsr, const int ldvsr, double * rconde, double * rcondv, void * work, const int lwork, double * rwork, int * iwork, const int liwork, long int * bwork, int * info );
void lapack_zggev(const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vl, const int ldvl, void * vr, const int ldvr, void * work, const int lwork, double * rwork, int * info );
void lapack_zggevx(const enum lapack_balance_type balanc, const enum lapack_compute_vectors_type jobvl, const enum lapack_compute_vectors_type jobvr, const enum lapack_reciprocal_condition_type sense, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * vl, const int ldvl, void * vr, const int ldvr, int * ilo, int * ihi, double * lscale, double * rscale, double * abnrm, double * bbnrm, double * rconde, double * rcondv, void * work, const int lwork, float * rwork, int * iwork, long int * bwork, int * info );
void lapack_zggglm(const int n, const int m, const int p, void * a, const int lda, void * b, const int ldb, void * d, void * x, void * y, void * work, const int lwork, int * info );
void lapack_zgghrd(const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, void * a, const int lda, void * b, const int ldb, void * q, const int ldq, void * z, const int ldz, int * info );
void lapack_zgglse(const int m, const int n, const int p, void * a, const int lda, void * b, const int ldb, void * c, void * d, void * x, void * work, const int lwork, int * info );
void lapack_zggqrf(const int n, const int m, const int p, void * a, const int lda, void * taua, void * b, const int ldb, void * taub, void * work, const int lwork, int * info );
void lapack_zggrqf(const int m, const int p, const int n, void * a, const int lda, void * taua, void * b, const int ldb, void * taub, void * work, const int lwork, int * info );
void lapack_zggsvd(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int n, const int p, int * k, int * l, void * a, const int lda, void * b, const int ldb, double * alpha, double * beta, void * u, const int ldu, void * v, const int ldv, void * q, const int ldq, void * work, double * rwork, int * iwork, int * info );
void lapack_zggsvp(const enum lapack_compute_ortho_type jobu, const enum lapack_compute_ortho_type jobv, const enum lapack_compute_ortho_type jobq, const int m, const int p, const int n, void * a, const int lda, void * b, const int ldb, const double tola, const double tolb, int * k, int * l, void * u, const int ldu, void * v, const int ldv, void * q, const int ldq, int * iwork, double * rwork, void * tau, void * work, int * info );
void lapack_zgtcon(const enum lapack_norm_type norm, const int n, const void * dl, const void * d, const void * du, const void * du2, const int * ipiv, const double anorm, double * rcond, void * work, int * info );
void lapack_zgtrfs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * dl, const void * d, const void * du, const void * dlf, const void * df, const void * duf, const void * du2, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zgtsv(const int n, const int nrhs, void * dl, void * d, void * du, void * b, const int ldb, int * info );
void lapack_zgtsvx(const enum lapack_fact_type fact, const enum lapack_trans_type trans, const int n, const int nrhs, const void * dl, const void * d, const void * du, void * dlf, void * df, void * duf, void * du2, int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zgttrf(const int n, void * dl, void * d, void * du, void * du2, int * ipiv, int * info );
void lapack_zgttrs(const enum lapack_trans_type trans, const int n, const int nrhs, const void * dl, const void * d, const void * du, const void * du2, const int * ipiv, void * b, const int ldb, int * info );
void lapack_zgtts2(const int itrans, const int n, const int nrhs, const void * dl, const void * d, const void * du, const void * du2, const int * ipiv, void * b, const int ldb );
void lapack_zhbev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, double * w, void * z, const int ldz, void * work, double * rwork, int * info );
void lapack_zhbevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, double * w, void * z, const int ldz, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zhbevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, void * q, const int ldq, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, void * work, double * rwork, int * iwork, int * ifail, int * info );
void lapack_zhbgst(const enum lapack_form_x_type vect, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, const void * bb, const int ldbb, void * x, const int ldx, void * work, double * rwork, int * info );
void lapack_zhbgv(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, void * bb, const int ldbb, double * w, void * z, const int ldz, void * work, double * rwork, int * info );
void lapack_zhbgvd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, void * bb, const int ldbb, double * w, void * z, const int ldz, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zhbgvx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, const int ka, const int kb, void * ab, const int ldab, void * bb, const int ldbb, void * q, const int ldq, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, void * work, double * rwork, int * iwork, int * ifail, int * info );
void lapack_zhbtrd(const enum lapack_form_q_type vect, const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, double * d, double * e, void * q, const int ldq, void * work, int * info );
void lapack_zhecon(const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, const int * ipiv, const double anorm, double * rcond, void * work, int * info );
void lapack_zheev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, double * w, void * work, const int lwork, double * rwork, int * info );
void lapack_zheevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, double * w, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zheevr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, int * isuppz, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zheevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, void * work, const int lwork, double * rwork, int * iwork, int * ifail, int * info );
void lapack_zhegs2(const int itype, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const void * b, const int ldb, int * info );
void lapack_zhegst(const int itype, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const void * b, const int ldb, int * info );
void lapack_zhegv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, void * b, const int ldb, double * w, void * work, const int lwork, double * rwork, int * info );
void lapack_zhegvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, void * b, const int ldb, double * w, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zhegvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * a, const int lda, void * b, const int ldb, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, void * work, const int lwork, double * rwork, int * iwork, int * ifail, int * info );
void lapack_zherfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zhesv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, int * ipiv, void * b, const int ldb, void * work, const int lwork, int * info );
void lapack_zhesvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, void * af, const int ldaf, int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, const int lwork, double * rwork, int * info );
void lapack_zhetd2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, double * d, double * e, void * tau, int * info );
void lapack_zhetf2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_zhetrd(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, double * d, double * e, void * tau, void * work, const int lwork, int * info );
void lapack_zhetrf(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, void * work, const int lwork, int * info );
void lapack_zhetri(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const int * ipiv, void * work, int * info );
void lapack_zhetrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const int * ipiv, void * b, const int ldb, int * info );
void lapack_zhgeqz(const enum lapack_hseqr_type job, const enum lapack_compute_type compq, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, void * h, const int ldh, void * t, const int ldt, void * alpha, void * beta, void * q, const int ldq, void * z, const int ldz, void * work, const int lwork, double * rwork, int * info );
void lapack_zhpcon(const enum lapack_uplo_type uplo, const int n, const void * ap, const int * ipiv, const double anorm, double * rcond, void * work, int * info );
void lapack_zhpev(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, double * w, void * z, const int ldz, void * work, double * rwork, int * info );
void lapack_zhpevd(const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, double * w, void * z, const int ldz, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zhpevx(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * ap, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, void * work, double * rwork, int * iwork, int * ifail, int * info );
void lapack_zhpgst(const int itype, const enum lapack_uplo_type uplo, const int n, void * ap, const void * bp, int * info );
void lapack_zhpgv(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, void * bp, double * w, void * z, const int ldz, void * work, double * rwork, int * info );
void lapack_zhpgvd(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_uplo_type uplo, const int n, void * ap, void * bp, double * w, void * z, const int ldz, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zhpgvx(const int itype, const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const enum lapack_uplo_type uplo, const int n, void * ap, void * bp, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, void * work, double * rwork, int * iwork, int * ifail, int * info );
void lapack_zhprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const void * afp, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zhpsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, int * ipiv, void * b, const int ldb, int * info );
void lapack_zhpsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, void * afp, int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zhptrd(const enum lapack_uplo_type uplo, const int n, void * ap, double * d, double * e, void * tau, int * info );
void lapack_zhptrf(const enum lapack_uplo_type uplo, const int n, void * ap, int * ipiv, int * info );
void lapack_zhptri(const enum lapack_uplo_type uplo, const int n, void * ap, const int * ipiv, void * work, int * info );
void lapack_zhptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const int * ipiv, void * b, const int ldb, int * info );
void lapack_zhsein(const enum lapack_side_type side, const enum lapack_eig_source_type eigsrc, const enum lapack_init_vector_type initv, const long int * select, const int n, const void * h, const int ldh, void * w, void * vl, const int ldvl, void * vr, const int ldvr, const int mm, int * m, void * work, double * rwork, int * ifaill, int * ifailr, int * info );
void lapack_zhseqr(const enum lapack_hseqr_type job, const enum lapack_compute_type compz, const int n, const int ilo, const int ihi, void * h, const int ldh, void * w, void * z, const int ldz, void * work, const int lwork, int * info );
void lapack_zlabrd(const int m, const int n, const int nb, void * a, const int lda, double * d, double * e, void * tauq, void * taup, void * x, const int ldx, void * y, const int ldy );
void lapack_zlacgv(const int n, void * x, const int incx );
void lapack_zlacn2(const int n, void * v, void * x, double * est, int * kase, int * isave );
void lapack_zlacon(const int n, void * v, void * x, double * est, int * kase );
void lapack_zlacp2(const enum lapack_uplo_type uplo, const int m, const int n, const double * a, const int lda, void * b, const int ldb );
void lapack_zlacpy(const enum lapack_uplo_type uplo, const int m, const int n, const void * a, const int lda, void * b, const int ldb );
void lapack_zlacrm(const int m, const int n, const void * a, const int lda, const double * b, const int ldb, const void * c, const int ldc, double * rwork );
void lapack_zlacrt(const int n, void * cx, const int incx, void * cy, const int incy, const void * c, const void * s );
double lapack_zladiv(const void * x, const void * y );
void lapack_zlaed0(const int qsiz, const int n, double * d, double * e, void * q, const int ldq, int * iwork, double * rwork, void * qstore, const int ldqs, int * info );
void lapack_zlaed7(const int n, const int cutpnt, const int qsiz, const int tlvls, const int curlvl, const int curpbm, double * d, void * q, const int ldq, const double rho, int * indxq, int * iwork, double * rwork, void * work, double * qstore, int * qptr, const int * prmptr, const int * perm, const int * givptr, const int * givcol, const double * givnum, int * info );
void lapack_zlaed8(int * k, const int n, const int qsiz, void * q, const int ldq, double * d, double * rho, const int cutpnt, const double * z, double * dlamda, void * q2, const int ldq2, double * w, int * indxp, int * indx, const int * indxq, int * perm, int * givptr, int * givcol, double * givnum, int * info );
void lapack_zlaein(const long int rightv, const long int noinit, const int n, const void * h, const int ldh, const void * w, void * v, void * b, const int ldb, double * rwork, const double eps3, const double smlnum, int * info );
void lapack_zlaesy(const void * a, const void * b, const void * c, void * rt1, void * rt2, void * evscal, void * cs1, void * sn1 );
void lapack_zlaev2(const void * a, const void * b, const void * c, double * rt1, double * rt2, double * cs1, void * sn1 );
void lapack_zlags2(const long int upper, const double a1, const void * a2, const double a3, const double b1, const void * b2, const double b3, double * csu, void * snu, double * csv, void * snv, double * csq, void * snq );
void lapack_zlagtm(const enum lapack_trans_type trans, const int n, const int nrhs, const double alpha, const void * dl, const void * d, const void * du, const void * x, const int ldx, const double beta, void * b, const int ldb );
void lapack_zlahef(const enum lapack_uplo_type uplo, const int n, const int nb, int * kb, void * a, const int lda, int * ipiv, void * w, const int ldw, int * info );
void lapack_zlahqr(const long int wantt, const long int wantz, const int n, const int ilo, const int ihi, void * h, const int ldh, void * w, const int iloz, const int ihiz, void * z, const int ldz, int * info );
void lapack_zlahrd(const int n, const int k, const int nb, void * a, const int lda, void * tau, void * t, const int ldt, void * y, const int ldy );
void lapack_zlaic1(const int job, const int j, const void * x, const double sest, const void * w, const void * gamma, double * sestpr, void * s, void * c );
void lapack_zlals0(const int icompq, const int nl, const int nr, const int sqre, const int nrhs, void * b, const int ldb, void * bx, const int ldbx, const int * perm, const int givptr, const int * givcol, const int ldgcol, const double * givnum, const int ldgnum, const double * poles, const double * difl, const double * difr, const double * z, const int k, const double c, const double s, double * rwork, int * info );
void lapack_zlalsa(const int icompq, const int smlsiz, const int n, const int nrhs, void * b, const int ldb, void * bx, const int ldbx, const double * u, const int ldu, const double * vt, const int * k, const double * difl, const double * difr, const double * z, const double * poles, const int * givptr, const int * givcol, const int ldgcol, const int * perm, const double * givnum, const double * c, const double * s, double * rwork, int * iwork, int * info );
void lapack_zlalsd(const enum lapack_uplo_type uplo, const int smlsiz, const int n, const int nrhs, double * d, double * e, void * b, const int ldb, const double rcond, int * rank, void * work, double * rwork, int * iwork, int * info );
double lapack_zlangb(const enum lapack_norm_type norm, const int n, const int kl, const int ku, const void * ab, const int ldab, double * work );
double lapack_zlange(const enum lapack_norm_type norm, const int m, const int n, const void * a, const int lda, double * work );
double lapack_zlangt(const enum lapack_norm_type norm, const int n, const void * dl, const void * d, const void * du );
double lapack_zlanhb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const int k, const void * ab, const int ldab, double * work );
double lapack_zlanhe(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, double * work );
double lapack_zlanhp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * ap, double * work );
double lapack_zlanhs(const enum lapack_norm_type norm, const int n, const void * a, const int lda, double * work );
double lapack_zlanht(const enum lapack_norm_type norm, const int n, const double * d, const void * e );
double lapack_zlansb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const int k, const void * ab, const int ldab, double * work );
double lapack_zlansp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * ap, double * work );
double lapack_zlansy(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, double * work );
double lapack_zlantb(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int k, const void * ab, const int ldab, double * work );
double lapack_zlantp(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const void * ap, double * work );
double lapack_zlantr(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int m, const int n, const void * a, const int lda, double * work );
void lapack_zlapll(const int n, void * x, const int incx, void * y, const int incy, double * ssmin );
void lapack_zlapmt(const long int forwrd, const int m, const int n, void * x, const int ldx, int * k );
void lapack_zlaqgb(const int m, const int n, const int kl, const int ku, void * ab, const int ldab, const double * r, const double * c, const double rowcnd, const double colcnd, const double amax, char * equed );
void lapack_zlaqge(const int m, const int n, void * a, const int lda, const double * r, const double * c, const double rowcnd, const double colcnd, const double amax, char * equed );
void lapack_zlaqhb(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, double * s, const double scond, const double amax, char * equed );
void lapack_zlaqhe(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const double * s, const double scond, const double amax, char * equed );
void lapack_zlaqhp(const enum lapack_uplo_type uplo, const int n, void * ap, const double * s, const double scond, const double amax, char * equed );
void lapack_zlaqp2(const int m, const int n, const int offset, void * a, const int lda, int * jpvt, void * tau, double * vn1, double * vn2, void * work );
void lapack_zlaqps(const int m, const int n, const int offset, const int nb, int * kb, void * a, const int lda, int * jpvt, void * tau, double * vn1, double * vn2, void * auxv, void * f, const int ldf );
void lapack_zlaqsb(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, const double * s, const double scond, const double amax, char * equed );
void lapack_zlaqsp(const enum lapack_uplo_type uplo, const int n, void * ap, const double * s, const double scond, const double amax, char * equed );
void lapack_zlaqsy(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const double * s, const double scond, const double amax, char * equed );
void lapack_zlar1v(const int n, const int b1, const int bn, const double sigma, const double * l, const double * d, const double * ld, const double * lld, const double * gersch, void * z, double * ztz, double * mingma, int * r, int * isuppz, double * work );
void lapack_zlar2v(const int n, void * x, void * y, void * z, const int incx, const double * c, const void * s, const int incc );
void lapack_zlarcm(const int m, const int n, const double * a, const int lda, const double * b, const int ldb, const void * c, const int ldc, double * rwork );
void lapack_zlarf(const enum lapack_side_type side, const int m, const int n, const void * v, const int incv, const void * tau, void * c, const int ldc, void * work );
void lapack_zlarfb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const void * v, const int ldv, const void * t, const int ldt, void * c, const int ldc, void * work, const int ldwork );
void lapack_zlarfg(const int n, void * alpha, void * x, const int incx, void * tau );
void lapack_zlarft(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, void * v, const int ldv, const void * tau, void * t, const int ldt );
void lapack_zlarfx(const enum lapack_side_type side, const int m, const int n, const void * v, const void * tau, void * c, const int ldc, void * work );
void lapack_zlargv(const int n, void * x, const int incx, void * y, const int incy, double * c, const int incc );
void lapack_zlarnv(const int idist, int * iseed, const int n, void * x );
void lapack_zlarrv(const int n, double * d, double * l, const int * isplit, const int m, const double * w, const int * iblock, const double * gersch, const double tol, void * z, const int ldz, int * isuppz, double * work, int * iwork, int * info );
void lapack_zlartg(const void * f, const void * g, double * cs, void * sn, void * r );
void lapack_zlartv(const int n, void * x, const int incx, void * y, const int incy, const double * c, const void * s, const int incc );
void lapack_zlarz(const enum lapack_side_type side, const int m, const int n, const int l, const void * v, const int incv, const void * tau, void * c, const int ldc, void * work );
void lapack_zlarzb(const enum lapack_side_type side, const enum lapack_trans_type trans, const enum lapack_direction_type direct, const enum lapack_store_type storev, const int m, const int n, const int k, const int l, const void * v, const int ldv, const void * t, const int ldt, void * c, const int ldc, void * work, const int ldwork );
void lapack_zlarzt(const enum lapack_direction_type direct, const enum lapack_store_type storev, const int n, const int k, void * v, const int ldv, const void * tau, void * t, const int ldt );
void lapack_zlascl(const enum lapack_symmetry_type type, const int kl, const int ku, const double cfrom, const double cto, const int m, const int n, void * a, const int lda, int * info );
void lapack_zlaset(const enum lapack_uplo_type uplo, const int m, const int n, const void * alpha, const void * beta, void * a, const int lda );
void lapack_zlasr(const enum lapack_side_type side, const enum lapack_pivot_type pivot, const enum lapack_direction_type direct, const int m, const int n, const double * c, const double * s, void * a, const int lda );
void lapack_zlassq(const int n, const void * x, const int incx, double * scale, double * sumsq );
void lapack_zlaswp(const int n, void * a, const int lda, const int k1, const int k2, const int * ipiv, const int incx );
void lapack_zlasyf(const enum lapack_uplo_type uplo, const int n, const int nb, int * kb, void * a, const int lda, int * ipiv, void * w, const int ldw, int * info );
void lapack_zlatbs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const int kd, const void * ab, const int ldab, void * x, double * scale, double * cnorm, int * info );
void lapack_zlatdf(const int ijob, const int n, const double * z, const int ldz, double * rhs, double * rdsum, double * rdscal, const int * ipiv, const int * jpiv );
void lapack_zlatps(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const void * ap, void * x, double * scale, double * cnorm, int * info );
void lapack_zlatrd(const enum lapack_uplo_type uplo, const int n, const int nb, void * a, const int lda, double * e, void * tau, void * w, const int ldw );
void lapack_zlatrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const enum lapack_column_norm_type normin, const int n, const void * a, const int lda, void * x, double * scale, double * cnorm, int * info );
void lapack_zlatrz(const int m, const int n, const int l, void * a, const int lda, void * tau, void * work );
void lapack_zlatzm(const enum lapack_side_type side, const int m, const int n, const void * v, const int incv, const void * tau, void * c1, void * c2, const int ldc, void * work );
void lapack_zlauu2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_zlauum(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_zpbcon(const enum lapack_uplo_type uplo, const int n, const int kd, const void * ab, const int ldab, const double anorm, double * rcond, void * work, double * rwork, int * info );
void lapack_zpbequ(const enum lapack_uplo_type uplo, const int n, const int kd, const void * ab, const int ldab, double * s, double * scond, double * amax, int * info );
void lapack_zpbrfs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const double * ab, const int ldab, const void * afb, const int ldafb, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zpbstf(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, int * info );
void lapack_zpbsv(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, void * ab, const int ldab, void * b, const int ldb, int * info );
void lapack_zpbsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, void * ab, const int ldab, void * afb, const int ldafb, char * equed, double * s, void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zpbtf2(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, int * info );
void lapack_zpbtrf(const enum lapack_uplo_type uplo, const int n, const int kd, void * ab, const int ldab, int * info );
void lapack_zpbtrs(const enum lapack_uplo_type uplo, const int n, const int kd, const int nrhs, const void * ab, const int ldab, void * b, const int ldb, int * info );
void lapack_zpocon(const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, const double anorm, double * rcond, void * work, double * rwork, int * info );
void lapack_zpoequ(const int n, const void * a, const int lda, double * s, double * scond, double * amax, int * info );
void lapack_zporfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zposv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, void * b, const int ldb, int * info );
void lapack_zposvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, void * af, const int ldaf, char * equed, double * s, void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zpotf2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_zpotrf(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_zpotri(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * info );
void lapack_zpotrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, void * b, const int ldb, int * info );
void lapack_zppcon(const enum lapack_uplo_type uplo, const int n, const void * ap, const double anorm, double * rcond, void * work, double * rwork, int * info );
void lapack_zppequ(const enum lapack_uplo_type uplo, const int n, const void * ap, double * s, double * scond, double * amax, int * info );
void lapack_zpprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const void * afp, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zppsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, void * b, const int ldb, int * info );
void lapack_zppsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, void * afp, char * equed, double * s, void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zpptrf(const enum lapack_uplo_type uplo, const int n, void * ap, int * info );
void lapack_zpptri(const enum lapack_uplo_type uplo, const int n, void * ap, int * info );
void lapack_zpptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, void * b, const int ldb, int * info );
void lapack_zptcon(const int n, const double * d, const void * e, const double anorm, double * rcond, double * rwork, int * info );
void lapack_zpteqr(const enum lapack_compute_type compz, const int n, double * d, double * e, void * z, const int ldz, double * work, int * info );
void lapack_zptrfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * d, const void * e, const double * df, const void * ef, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zptsv(const int n, const int nrhs, double * d, void * e, void * b, const int ldb, int * info );
void lapack_zptsvx(const enum lapack_fact_type fact, const int n, const int nrhs, const double * d, const void * e, double * df, void * ef, const void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zpttrf(const int n, double * d, void * e, int * info );
void lapack_zpttrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const double * d, const void * e, double * b, const int ldb, int * info );
void lapack_zptts2(const int iuplo, const int n, const int nrhs, const double * d, const void * e, double * b, const int ldb );
void lapack_zrot(const int n, void * cx, const int incx, void * cy, const int incy, const double c, const void * s );
void lapack_zspcon(const enum lapack_uplo_type uplo, const int n, const void * ap, const int * ipiv, const double anorm, double * rcond, void * work, int * info );
void lapack_zspmv(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * ap, const void * x, const int incx, const void * beta, void * y, const int incy );
void lapack_zspr(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * x, const int incx, void * ap );
void lapack_zsprfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const void * afp, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zspsv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * ap, int * ipiv, void * b, const int ldb, int * info );
void lapack_zspsvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, void * afp, int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zsptrf(const enum lapack_uplo_type uplo, const int n, void * ap, int * ipiv, int * info );
void lapack_zsptri(const enum lapack_uplo_type uplo, const int n, void * ap, const int * ipiv, void * work, int * info );
void lapack_zsptrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * ap, const int * ipiv, void * b, const int ldb, int * info );
void lapack_zstedc(const enum lapack_compute_type compz, const int n, double * d, double * e, void * z, const int ldz, void * work, const int lwork, double * rwork, const int lrwork, int * iwork, const int liwork, int * info );
void lapack_zstegr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, double * d, double * e, const double vl, const double vu, const int il, const int iu, const double abstol, int * m, double * w, void * z, const int ldz, int * isuppz, double * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_zstein(const int n, const double * d, const double * e, const int m, const double * w, const int * iblock, const int * isplit, void * z, const int ldz, double * work, int * iwork, int * ifail, int * info );
void lapack_zsteqr(const enum lapack_compute_type compz, const int n, double * d, double * e, void * z, const int ldz, double * work, int * info );
void lapack_zsycon(const enum lapack_uplo_type uplo, const int n, const void * a, const int lda, const int * ipiv, const double anorm, double * rcond, void * work, int * info );
void lapack_zsymv(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * a, const int lda, const void * x, const int incx, const void * beta, void * y, const int incy );
void lapack_zsyr(const enum lapack_uplo_type uplo, const int n, const void * alpha, const void * x, const int incx, void * a, const int lda );
void lapack_zsyrfs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const void * af, const int ldaf, const int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_zsysv(const enum lapack_uplo_type uplo, const int n, const int nrhs, void * a, const int lda, int * ipiv, void * b, const int ldb, void * work, const int lwork, int * info );
void lapack_zsysvx(const enum lapack_fact_type fact, const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, void * af, const int ldaf, int * ipiv, const void * b, const int ldb, void * x, const int ldx, double * rcond, double * ferr, double * berr, void * work, const int lwork, double * rwork, int * info );
void lapack_zsytf2(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, int * info );
void lapack_zsytrf(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, int * ipiv, void * work, const int lwork, int * info );
void lapack_zsytri(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const int * ipiv, void * work, int * info );
void lapack_zsytrs(const enum lapack_uplo_type uplo, const int n, const int nrhs, const void * a, const int lda, const int * ipiv, void * b, const int ldb, int * info );
void lapack_ztbcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const int kd, const void * ab, const int ldab, double * rcond, void * work, double * rwork, int * info );
void lapack_ztbrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const void * ab, const int ldab, const void * b, const int ldb, const void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_ztbtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int kd, const int nrhs, const void * ab, const int ldab, void * b, const int ldb, int * info );
void lapack_ztgevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, const long int * select, const int n, const void * s, const int lds, const void * p, const int ldp, void * vl, const int ldvl, void * vr, const int ldvr, const int mm, int * m, void * work, double * rwork, int * info );
void lapack_ztgex2(const long int wantq, const long int wantz, const int n, void * a, const int lda, void * b, const int ldb, void * q, const int ldq, void * z, const int ldz, const int j1, int * info );
void lapack_ztgexc(const long int wantq, const long int wantz, const int n, void * a, const int lda, void * b, const int ldb, void * q, const int ldq, void * z, const int ldz, const int ifst, int * ilst, int * info );
void lapack_ztgsen(const int ijob, const long int wantq, const long int wantz, const long int * select, const int n, void * a, const int lda, void * b, const int ldb, void * alpha, void * beta, void * q, const int ldq, void * z, const int ldz, int * m, double * pl, double * pr, double * dif, void * work, const int lwork, int * iwork, const int liwork, int * info );
void lapack_ztgsja(const enum lapack_compute_tgsj_type jobu, const enum lapack_compute_tgsj_type jobv, const enum lapack_compute_tgsj_type jobq, const int m, const int p, const int n, const int k, const int l, void * a, const int lda, void * b, const int ldb, const double tola, const double tolb, double * alpha, double * beta, void * u, const int ldu, void * v, const int ldv, void * q, const int ldq, void * work, int * ncycle, int * info );
void lapack_ztgsna(const enum lapack_balance_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const void * a, const int lda, const void * b, const int ldb, const void * vl, const int ldvl, const void * vr, const int ldvr, double * s, double * dif, const int mm, int * m, void * work, const int lwork, int * iwork, int * info );
void lapack_ztgsy2(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const void * a, const int lda, const void * b, const int ldb, void * c, const int ldc, const void * d, const int ldd, const void * e, const int lde, void * f, const int ldf, double * scale, double * rdsum, double * rdscal, int * info );
void lapack_ztgsyl(const enum lapack_trans_type trans, const int ijob, const int m, const int n, const void * a, const int lda, const void * b, const int ldb, void * c, const int ldc, const void * d, const int ldd, const void * e, const int lde, void * f, const int ldf, double * dif, double * scale, void * work, const int lwork, int * iwork, int * info );
void lapack_ztpcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const void * ap, double * rcond, void * work, double * rwork, int * info );
void lapack_ztprfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * ap, const void * b, const int ldb, const void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_ztptri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, void * ap, int * info );
void lapack_ztptrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * ap, void * b, const int ldb, int * info );
void lapack_ztrcon(const enum lapack_norm_type norm, const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, const void * a, const int lda, double * rcond, void * work, double * rwork, int * info );
void lapack_ztrevc(const enum lapack_eigenvectors_side_type side, const enum lapack_how_many_type howmny, const long int * select, const int n, void * t, const int ldt, void * vl, const int ldvl, void * vr, const int ldvr, const int mm, int * m, void * work, double * rwork, int * info );
void lapack_ztrexc(const enum lapack_compute_type compq, const int n, void * t, const int ldt, void * q, const int ldq, const int ifst, const int ilst, int * info );
void lapack_ztrrfs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * a, const int lda, const void * b, const int ldb, const void * x, const int ldx, double * ferr, double * berr, void * work, double * rwork, int * info );
void lapack_ztrsen(const enum lapack_compute_cond_type job, const enum lapack_compute_type compq, const long int * select, const int n, void * t, const int ldt, void * q, const int ldq, void * w, int * m, double * s, double * sep, void * work, const int lwork, int * info );
void lapack_ztrsna(const enum lapack_compute_cond_type job, const enum lapack_how_many_type howmny, const long int * select, const int n, const void * t, const int ldt, const void * vl, const int ldvl, const void * vr, const int ldvr, double * s, double * sep, const int mm, int * m, void * work, const int ldwork, double * rwork, int * info );
void lapack_ztrsyl(const enum lapack_trans_type trana, const enum lapack_trans_type tranb, const int isgn, const int m, const int n, const void * a, const int lda, const void * b, const int ldb, void * c, const int ldc, double * scale, int * info );
void lapack_ztrti2(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, void * a, const int lda, int * info );
void lapack_ztrtri(const enum lapack_uplo_type uplo, const enum lapack_diag_type diag, const int n, void * a, const int lda, int * info );
void lapack_ztrtrs(const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const enum lapack_diag_type diag, const int n, const int nrhs, const void * a, const int lda, void * b, const int ldb, int * info );
void lapack_ztzrqf(const int m, const int n, void * a, const int lda, void * tau, int * info );
void lapack_ztzrzf(const int m, const int n, void * a, const int lda, void * tau, void * work, const int lwork, int * info );
void lapack_zung2l(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_zung2r(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_zungbr(const enum lapack_form_matrices_type vect, const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zunghr(const int n, const int ilo, const int ihi, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zungl2(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_zunglq(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zungql(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zungqr(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zungr2(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, int * info );
void lapack_zungrq(const int m, const int n, const int k, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zungtr(const enum lapack_uplo_type uplo, const int n, void * a, const int lda, const void * tau, void * work, const int lwork, int * info );
void lapack_zunm2l(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_zunm2r(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_zunmbr(const enum lapack_form_matrices_type vect, const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunmhr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int ilo, const int ihi, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunml2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_zunmlq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunmql(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunmqr(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunmr2(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_zunmr3(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, int * info );
void lapack_zunmrq(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunmrz(const enum lapack_side_type side, const enum lapack_trans_type trans, const int m, const int n, const int k, const int l, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zunmtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const void * a, const int lda, const void * tau, void * c, const int ldc, void * work, const int lwork, int * info );
void lapack_zupgtr(const enum lapack_uplo_type uplo, const int n, const void * ap, const void * tau, void * q, const int ldq, void * work, int * info );
void lapack_zupmtr(const enum lapack_side_type side, const enum lapack_uplo_type uplo, const enum lapack_trans_type trans, const int m, const int n, const void * ap, const void * tau, void * c, const int ldc, void * work, int * info );
#endif /* LAPACK_H */
