//==============================================================================================
//
//  Innovative Computing Laboratory - Computer Science Department - University of Tennessee
//  Written by Jakub Kurzak
//
//==============================================================================================

#ifndef _SPU_COMM_H_
#define _SPU_COMM_H_


#include "../cbe/cbe_blas.h"


#define DMA_LISTS 16


void spu_recv_call_args();
void spu_wait_tag(int tag);

void spu_ppu_ack(Response response, int tag);

void spu_recv_tile(float *spu_block, unsigned int ppu_block, int LDA, int tag);
void spu_send_tile(float *spu_block, unsigned int ppu_block, int LDA, int tag);

void spu_recv_tile_blocked      (float *spu_block, unsigned int ppu_block, int tag);
void spu_recv_tile_blocked_fence(float *spu_block, unsigned int ppu_block, int tag);
void spu_send_tile_blocked      (float *spu_block, unsigned int ppu_block, int tag);

void spu_recv_tile_double(double *spu_block, unsigned int ppu_block, int LDA, int tag);
void spu_send_tile_double(double *spu_block, unsigned int ppu_block, int LDA, int tag);

void spu_recv_tile_blocked_double(double *spu_block, unsigned int ppu_block, int tag);
void spu_send_tile_blocked_double(double *spu_block, unsigned int ppu_block, int tag);


#endif

//----------------------------------------------------------------------------------------------
