//==============================================================================================
//
//  Innovative Computing Laboratory - Computer Science Department - University of Tennessee
//  Written by Jakub Kurzak
//
//==============================================================================================

#include <sys/time.h>
#include "ppu_timer.h"

//----------------------------------------------------------------------------------------------

TimeStruct get_current_time(void)
{
    static struct timeval time_val;
    static struct timezone time_zone;
    TimeStruct    time;


    gettimeofday(&time_val, &time_zone);
    time.sec = time_val.tv_sec;
    time.usec = time_val.tv_usec;
    return (time);
}

//----------------------------------------------------------------------------------------------

double get_elapsed_time(TimeStruct time_1, TimeStruct time_2)
{
    int sec, usec;


    sec  = time_2.sec  - time_1.sec;
    usec = time_2.usec - time_1.usec;
    return ((double)(sec) + (double)(usec) * 0.000001);
}

//----------------------------------------------------------------------------------------------
