//==============================================================================================
//
//  Innovative Computing Laboratory - Computer Science Department - University of Tennessee
//  Written by Jakub Kurzak
//
//==============================================================================================

#ifndef _PPU_BLAS_H_
#define _PPU_BLAS_H_


void ppu_spus_init(int num, int NB, int DNB);
void ppu_spus_finish();
int dump_trace(char trace_file_name[]);

void ppu_spotrf(int M, int N, float *A, int LDA, int *INFO);
void ppu_dgemm(int M, int N, int K, double *A, int LDA, double *B, int LDB, double *C, int LDC);
void ppu_strsm_no_trans(int M, int N, float *T, int LDT, float *B, int LDB);
void ppu_strsm_trans(int M, int N, float *T, int LDT, float *B, int LDB);

void ppu_lapack2blocked(int M, int N, float *A, float *B);
void ppu_blocked2lapack(int M, int N, float *A, float *B);
void ppu_lapack2blocked_double(int M, int N, double *A, double *B);
void ppu_blocked2lapack_double(int M, int N, double *A, double *B);

void ppu_convert_d2s(int M, int N, double *D, float *S);


#endif

//----------------------------------------------------------------------------------------------
















