//==============================================================================================
//
//  Innovative Computing Laboratory - Computer Science Department - University of Tennessee
//  Written by Jakub Kurzak, July 2006
//
//==============================================================================================

#ifndef _CBE_BLAS_H_
#define _CBE_BLAS_H_


#define SPUS_MAX  8
#define BUFFERS   8
#define DBUFFERS 16

//----------------------------------------------------------------------------------------------

typedef struct globalparams
{
    unsigned int    local_store[SPUS_MAX];
    unsigned int    spu_event_log[SPUS_MAX];

    int             spus_num;
    unsigned int    ppu_call_args_p;
    unsigned int    ppu_spu_ack_p[SPUS_MAX];
    int             NB;
    int             DNB;
    unsigned char   pad[80];
}
GlobalParams;

//----------------------------------------------------------

typedef enum
{
    SPOTRF,
    STRSM_NOTRANS,
    STRSM_TRANS,
    DGEMM,

    LAPACK2BLOCKED,
    BLOCKED2LAPACK,
    LAPACK2BLOCKED_DOUBLE,
    BLOCKED2LAPACK_DOUBLE,

    CONVERT_D2S,
    
    END
}
Command;

//----------------------------------------------------------

typedef enum
{
    DONE  = 1
}
Response;

//----------------------------------------------------------

typedef union callargs
{
    // xPOTRF
    struct
    {
        int             M;
        int             N;
        unsigned int    A;
        int             LDA;
        unsigned int    INFO;
    }
    potrf;

    // xGEMM
    struct
    {
        int             M, N, K;
        unsigned int    A;
        int             LDA;
        unsigned int    B;
        int             LDB;
        unsigned int    C;
        int             LDC;
    }
    gemm;

    // xTRSM
    struct
    {
        int             M, N;
        unsigned int    T;
        int             LDT;
        unsigned int    B;
        int             LDB;
    }
    trsm;
        
    // Block format
    struct
    {
        int M;
        int N;
        unsigned int A;
        unsigned int B;
    }
    blocked_format;

    // Single-double conversion
    struct
    {
        int M;
        int N;
        unsigned int D;
        unsigned int S;
    }
    convert;
    
    unsigned char pad[128];
}
CallArgs;


#endif

//----------------------------------------------------------------------------------------------
