C
C original code purely by Graham
C Oct-Nov 2000
C
C adopted to the new semantics of FTMPI by Edgar
C July 2003
C
C This program shows how to do a master-slave framework with FT-MPI. We
C introduce structures for the work and for each proc. This is
C necessary, since we are designing this example now to work with
C REBUILD, BLANK and SHRINK modes.
C
C Additionally, this example makes use of the two additional
C attributes of FT-MPI, which indicate who has died and how
C many have died. By activating the COLLECTIVE_CHECKWHODIED flag, 
C a more portable (however also more expensive) version of the 
C checkwhodied routines is invoked. Attention: the collective 
C version of checkwhodied just works for the REBUILD mode!
C
C Graham Fagg 2000(c)
C Edgar Gabriel 2003(c)


      program fpift

      implicit none
      
      include "mpif.h"
      include "fsolvergen.inc"

      integer nextwork
      
      integer myrank, size
      integer i, rc
      integer mode
      double precision recval

#ifdef COLLECTIVE_CHECKWHODIED
      integer tmparr(MAXSIZE)
      integer numrespawned
#endif

      recval=SPECIALRECOVERYVALUE
  
      call MPI_Init ( rc )
      call MPI_Comm_rank (MPI_COMM_WORLD, myrank, rc)
      call MPI_Comm_size (MPI_COMM_WORLD, size, rc)
      write (*,*) "I am [", myrank,"] of [", size, "]"
      
#ifdef COLLECTIVE_CHECKWHODIED
      call checkwhodied ( wasalivebefore, size, numrespawned,
     &                    tmparr )
      wasalivebefore = 1
#endif

      if ( myrank.eq.0)  then
         maxworkers = size
         call master ()
      else
         call slave ( myrank )
      end if
      

      call MPI_Finalize (rc)
      end 
C**********************************************************************
C**********************************************************************
C**********************************************************************
C the master code 

      subroutine master ()

      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      
      integer i, rc

C     result stuff 
      double precision result, deltaresult
      integer slicestodo
      integer status(MPI_STATUS_SIZE)

C     work distribution 
      integer currentworkers, next
        
C     recovery 
      integer failed, reclaimed
      integer isfinished

C     startup 
      isfinished = 0
      slicestodo  = slices
      result      = 0.0
      deltaresult = 0.0
      next    = 0

C     init worker states 
      call init_states (maxworkers)
      call init_work ()

C     loop until we have done all the work or lost all my workers 
C     The loop contains of two parts: distribute work, and 
C     collect the results. In case a worker dies, his work is
C     marked as 'not done' and redistributed. 

 20    continue

C      distribute work 
       do 30 thisproc = 1, maxworkers-1
          if ( state(thisproc) .eq. AVAILABLE ) then
             call getnextwork ( next)
	     call MPI_Send (next, 1, MPI_INTEGER, thisproc, WORK_TAG,
     &            comm, rc)
             if ( rc .eq. MPI_ERR_OTHER ) then
                call recover_master ( comm, rc )
             end if
             call advance_state (thisproc, next)
           end if
 30     continue
      
C     get results 
        isfinished = 0
        do 40, thisproc=1, maxworkers-1
           if ( state(thisproc).eq. WORKING ) then
	      call MPI_Recv (deltaresult, 1, MPI_DOUBLE_PRECISION,  
     &             thisproc, RES_TAG, comm, status, rc )
              if ( rc .eq. MPI_ERR_OTHER ) then
                 call recover_master ( comm, rc )
              end if
	      call advance_state (thisproc, NULLWORKID)
           end if

           if ( state(thisproc) .eq. RECEIVED ) then
              result = result + deltaresult
              slicestodo = slicestodo - 1
              call advance_state (thisproc, NULLWORKID)
           else if (state(thisproc).eq.FINISHED.or.
     &             state(thisproc).eq.DEAD ) then
              isfinished = isfinished + 1 
           end if
 40     continue
      
C     if no more work to be done AND everybody received
C	 the FINISHED-msg, exit
        if ((slicestodo.eq.0).and.(isfinished.eq.(maxworkers-1))) then 
           goto 50 
        else
           goto 20 
        end if
        
 50     continue
  
      if (slicestodo .gt. 0 ) then 
         write (*,*) "There are ", slicestodo, 
     &        " slices left to calculate"
      end if
  
  
      write (*,*) "Root has finished, result found = ", result
      
      return 
      end

C**********************************************************************
C**********************************************************************
C**********************************************************************
      subroutine init_states (max)

      implicit none
      include "mpif.h"
      include "fsolvergen.inc"
      
      integer i, max
  
C     note: 0 is me.. and I don't work 
      do 10 i=1, max
         rank(i)        = i
         currentwork(i) = -1
         state(i)       = AVAILABLE

 10    continue
      end


      subroutine init_work ()
      
      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer i

C     note: slice is from 0 to slices-1
      do 10 i=1,SLICES
         wworkid(i)    = i
         wrank(i)      = MPI_UNDEFINED
         wworkstate(i) = WNOTDONE
 10   continue
      end 

C**********************************************************************
C**********************************************************************
C**********************************************************************
C Comment: the second argument workid is just used in a single case 
      subroutine advance_state ( r,  workid)
      
      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer tmp, r, workid, rc

      if ( state(r) .eq.AVAILABLE ) then

         if ( workid .eq. NULLWORKID ) then
            write (*,*) "Invalid workid ", workid, " for proc: ", r
            call MPI_Abort ( MPI_COMM_WORLD, 1, rc )
         else if ( workid .eq. FINISH ) then
            state(r)       = FINISHED
            currentwork(r) = slices;  ! empty tag 
            write (*,*) "FINISHED: [", r, "]"
         else 
            state(r)       = WORKING
            currentwork(r) = workid
      
            write (*,*) "SENT WORK: [", r, "] work [", workid,"]"
C     mark work as 'in progress' 
            wworkstate(workid) = WINPROGRESS
            wrank(workid)      = r
         end if

      else if  (state(r) .eq. WORKING) then       
       state(r) = RECEIVED
      else if ( state(r) .eq. RECEIVED) then
C        mark work as finished */
         tmp = currentwork(r)
         wworkstate(tmp)  = WDONE

         state(r)       = AVAILABLE
         currentwork(r) = slices	! i.e. empty tag 
         write (*,*) "DONE WORK: [", r, "] work [", tmp, "]"  
      else if  ( state(r). eq. SEND_FAILED ) then
         state(r) = AVAILABLE
      else if ( state(r) .eq. RECV_FAILED) then
        state(r) = WORKING
      else if  (state(r) .eq. DEAD) then
C       State of process not updated, since done or dead 
#if !defined(USE_BLANK_MODE) && !defined(USE_SHRINK_MODE) 	
        state(r) = AVAILABLE
	currentwork(r) = slices ! empty tag 
	write (*,*) "MASTER: rank ", r, " was reset to AVAILABLE"
#endif
      else if  (state(r) .eq. FINISHED) then
C       do nothing anymore 
      else
         write (*,*) "Invalid state of proc ", r 
         call MPI_Abort ( MPI_COMM_WORLD, 1, rc )
      end if

      end
C**********************************************************************
C**********************************************************************
C**********************************************************************
      subroutine mark_error ( r )

      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer tmp, r

      if ( state(r) .eq. AVAILABLE )  then
         state(r) = SEND_FAILED
      else if ( state(r) .eq. WORKING ) then
         state(r) = RECV_FAILED
      end if

      end
C**********************************************************************
C**********************************************************************
C**********************************************************************
      subroutine mark_dead ( r)
      
      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer tmp, r

#if !defined(USE_BLANK_MODE) && !defined(USE_SHRINK_MODE) 	
      if ((state(r) .eq. SEND_FAILED ) .or.
     &    (state(r) .eq. RECV_FAILED ) ) then
#endif
      state(r) = DEAD
#if !defined(USE_BLANK_MODE) && !defined(USE_SHRINK_MODE) 	
      else
         state(r) = AVAILABLE
      end if
#endif

C     mark its current work as not yet done again 
      tmp             = currentwork(r)
      wworkstate(tmp) = WNOTDONE
      wrank(tmp)      = MPI_UNDEFINED
  
      end
C**********************************************************************
C**********************************************************************
C**********************************************************************
C getnextwork 
      subroutine getnextwork ( next )

      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer next
      integer slice
      integer i
  
      slice = FINISH
      do 10 i=1, SLICES
         if ( wworkstate(i) .eq. WNOTDONE )  then
            slice = wworkid(i)
            goto 20
         end if
 10   continue

 20   continue

      next = slice
      return 
      
      end

C**********************************************************************
C**********************************************************************
C**********************************************************************
#ifdef COLLECTIVE_CHECKWHODIED
C This routine is used to check, who and how many processes are
C   respawned. It is called by all processes after MPI_Init and
C   in the recovery function. The way how to determine who is respawned
C   is done by using a static, global  variable, which is set to
C   1 after checkwhodied has been called the first time. Therefore,
C   we have three possibilities:
C   - the sum of the global variables is zero: all processes are
C     freshly started
C   - the sum of the global variables is: 1<sum<size-1 : Using an
C     allgather, we can even determine who is respawned
C   - sum > size-1: something went wrong, abort:
C
C   ATTENTION: I think this routine does not survive a failure
C              during its execution /I have to think about this.
C
C	      This routines does not work for the SHRINK mode
C
C   EG July 13 2003

      subroutine checkwhodied ( wasb, size, numrespawned,
     &     respawnedarr )


      implicit none
      include "mpif.h"
      include "fsolvergen.inc"


      integer rc, size, wasb
      integer totalarr(MAXSIZE)
      integer i, j, sum , numrespawned
      integer respawnedarr(MAXSIZE)

      call MPI_Allreduce (wasb, sum, 1, MPI_INTEGER, MPI_SUM, 
     &     MPI_COMM_WORLD, rc )
  
      if ( sum .eq. 0 ) then
C        All processes are freshly started 
         numrespawned = 0
      else if ( (sum .gt. 0) .and. (sum .le. (size-1)) ) then
         call MPI_Allgather ( wasalivebefore, 1, MPI_INTEGER, totalarr,
     &        1, MPI_INTEGER, MPI_COMM_WORLD, rc )
         j = 1
         do 100 i = 1, size
            if ( totalarr(i) .eq. 0 ) then
               respawnedarr(j) = i - 1
               j = j + 1
            end if
 100     continue
      numrespawned = (size - sum )
      else
C        If we are here, sum was > size-1, which means, something
C        went completly wrong.... 
         call MPI_Abort ( MPI_COMM_WORLD, 1, rc)
      end if

      return
      end
   

#else
C   This routine is used to check, who and how many processes 
C   have failed. It uses two differen attributes to determine
C   how many procs have failed (FTMPI_NUM_FAILED_PROCS) and
C   who. The latter one is hidden in the Error string returned
C   by the Attribute FTMPI_ERRCODE_FAILED (which is in fact
C   an error code).
C   
C   In contrary to the previous version this
C   routine is purely local, and does not involve any communication.
C 
C   EG August 6 2003

      subroutine checkwhodied ( wasb, size, numfailed, failedarr )

      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer rc, size, wasb
      integer numfailed
      integer failedarr(MAXSIZE)

      integer valp1, errcode, flag
      integer i

      character*128 headerstring
      character*1024 errstring
      
      call MPI_Attr_get (comm,FTMPI_ERROR_FAILURE, valp1, flag, rc)
      errcode = valp1

      call MPI_Attr_get (comm,FTMPI_NUM_FAILED_PROCS,valp1,flag,rc)
      numfailed = valp1

C     Get error string and parse it 
      call MPI_Error_string ( errcode, errstring, flag, rc)

      read (errstring, '(a23)') headerstring
      read (errstring(24:flag), *) (failedarr(i), i=1,numfailed)

      return
      end

#endif
C**********************************************************************
C**********************************************************************
C**********************************************************************
      subroutine recover_master ( rcomm, err)

      implicit none
      include "mpif.h"
      include "fsolvergen.inc"

      integer rcomm, err, most
      integer oldcomm, newcomm
      integer rc, size, i, k, newrank
      integer tmparr(MAXSIZE)
      integer copyrank, copystate, copycurrentwork

C     Mark the communication to the procs. which didn't succeed
C     as erroneous  
      call mark_error ( thisproc ) 

      oldcomm = MPI_COMM_WORLD
      newcomm = FT_MPI_CHECK_RECOVER
      call MPI_Comm_dup (oldcomm, newcomm, rc )

      call MPI_Comm_rank (MPI_COMM_WORLD, newrank, rc)
      call MPI_Comm_size (MPI_COMM_WORLD, size, rc)

      write(*,*) "AFTER Recovery  rank ", newrank, " size ", size
      
      call checkwhodied ( wasalivebefore, size, rc, tmparr)
      if ( rc .ne. 0 ) then
         write (*,*) "MASTER: ", rc, " procs has/have failed"
         do 110 i = 1, rc
            write(*,*) "MASTER: rank ", tmparr(i), " failed"
            call mark_dead ( tmparr(i) )
 110     continue 
      end if

#ifdef USE_SHRINK_MODE 
C     Shrink the procs-list 
      most = size + rc
      k = 1
      do 120 i = 1, most
         copycurrentwork = currentwork(i)
         copyrank        = rank(i)
         copystate       = state(i)
         if ( i .ne. k ) then
            rank(i)        = MPI_UNDEFINED
            currentwork(i) = MPI_UNDEFINED
            state(i)       = MPI_UNDEFINED
            
            rank(k)        = copyrank
            currentwork(k) = copycurrentwork
            state(k)       = copystate
         end if
         if ( state(i) .ne. DEAD) then
            k = k + 1;
         end if
 120  continue
       maxworkers = size
#endif


      return 
      end


      

