/*
 * Copyright (c) 2011      The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 */

#include "dague.h"
#include "data_dist/matrix/matrix.h"
#include "reduce_col.h"
#include "reduce_row.h"

struct dague_object_t*
dague_reduce_col_New( const tiled_matrix_desc_t* src,
                      tiled_matrix_desc_t* dest,
                      dague_operator_t operator,
                      void* op_data )
{
    struct dague_object_t* dague;

    dague = (struct dague_object_t*)dague_reduce_col_new( src, dest, operator, op_data, 0, 0, src->lnt, src->lmt );
    return dague;
}

void dague_reduce_col_Destruct( struct dague_object_t *o )
{
    dague_reduce_col_destroy( (dague_reduce_col_object_t*)o );
}

struct dague_object_t*
dague_reduce_row_New( const tiled_matrix_desc_t* src,
                      tiled_matrix_desc_t* dest,
                      dague_operator_t operator,
                      void* op_data )
{
    struct dague_object_t* dague;

    dague = (struct dague_object_t*)dague_reduce_row_new( src, dest, operator, op_data );
    return dague;
}

void dague_reduce_row_Destruct( struct dague_object_t *o )
{
    dague_reduce_row_destroy( (dague_reduce_row_object_t*)o );
}

